/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.util.concurrent.atomic.AtomicBoolean;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class InternalDebugOperation
extends MRCOperation {
    private Thread bgrChkptr;
    private final AtomicBoolean asyncChkptRunning = new AtomicBoolean(false);

    public InternalDebugOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.stringMessage rqArgs = (MRC.stringMessage)rq.getRequestArgs();
        if (this.master.getConfig().getAdminPassword().length() > 0 && !this.master.getConfig().getAdminPassword().equals(rq.getDetails().password)) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "invalid password");
        }
        if (rqArgs.getAString().equals("shutdown_babudb")) {
            this.master.getVolumeManager().checkpointDB();
            this.master.getVolumeManager().shutdown();
            rq.setResponse(MRC.stringMessage.newBuilder().setAString("ok").build());
        } else if (rqArgs.getAString().equals("startup_babudb")) {
            this.master.getVolumeManager().init();
            rq.setResponse(MRC.stringMessage.newBuilder().setAString("ok").build());
        } else if (rqArgs.getAString().equals("async_checkpoint")) {
            Runnable asynChkpt = new Runnable(){

                @Override
                public void run() {
                    try {
                        InternalDebugOperation.this.asyncChkptRunning.set(true);
                        long tStart = System.currentTimeMillis();
                        InternalDebugOperation.this.master.getVolumeManager().checkpointDB();
                        long tEnd = System.currentTimeMillis();
                        InternalDebugOperation.this.asyncChkptRunning.set(false);
                        Logging.logMessage(6, this, "checkpoint took " + (tEnd - tStart) + " ms ", new Object[0]);
                    }
                    catch (DatabaseException ex) {
                        Logging.logError(3, this, ex);
                    }
                }
            };
            this.bgrChkptr = new Thread(asynChkpt);
            this.bgrChkptr.start();
            rq.setResponse(MRC.stringMessage.newBuilder().setAString("ok").build());
        } else if (rqArgs.getAString().equals("checkpoint_done")) {
            if (!this.asyncChkptRunning.get()) {
                rq.setResponse(MRC.stringMessage.newBuilder().setAString("yes").build());
            } else {
                rq.setResponse(MRC.stringMessage.newBuilder().setAString("no").build());
            }
        } else {
            rq.setResponse(MRC.stringMessage.newBuilder().setAString("unknown command").build());
        }
        this.finishRequest(rq);
    }
}

