/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import com.google.protobuf.Message;
import java.io.IOException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.utils.ReusableBufferInputStream;
import org.xtreemfs.mrc.ErrorRecord;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceConstants;

public abstract class MRCOperation {
    protected final MRCRequestDispatcher master;

    public MRCOperation(MRCRequestDispatcher master) {
        this.master = master;
    }

    public abstract void startRequest(MRCRequest var1) throws Throwable;

    public ErrorRecord parseRequestArgs(MRCRequest rq) {
        try {
            Message rqPrototype;
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.stage, this, "parsing request arguments", new Object[0]);
            }
            if ((rqPrototype = MRCServiceConstants.getRequestMessage(rq.getRPCRequest().getHeader().getRequestHeader().getProcId())) == null) {
                rq.setRequestArgs(null);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.net, this, "received request with empty message", new Object[0]);
                }
            } else if (rq.getRPCRequest().getMessage() != null) {
                rq.setRequestArgs(rqPrototype.newBuilderForType().mergeFrom(new ReusableBufferInputStream(rq.getRPCRequest().getMessage())).build());
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.net, this, "received request of type %s", rq.getRequestArgs().getClass().getName());
                }
            } else {
                rq.setRequestArgs((Message)rqPrototype.getDefaultInstanceForType());
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.net, this, "received request of type %s (empty message)", rq.getRequestArgs().getClass().getName());
                }
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "parsed request: %s", rqPrototype);
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.stage, this, "successfully parsed request arguments:", new Object[0]);
            }
            return null;
        }
        catch (Throwable exc) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.stage, this, "could not parse request arguments:", new Object[0]);
                Logging.logUserError(7, Logging.Category.stage, this, exc);
            }
            return new ErrorRecord(RPC.ErrorType.GARBAGE_ARGS, RPC.POSIXErrno.POSIX_ERROR_EINVAL, exc.getMessage(), exc);
        }
    }

    public RPC.UserCredentials getUserCredentials(MRCRequest rq) throws IOException {
        RPC.UserCredentials cred = rq.getRPCRequest().getHeader().getRequestHeader().getUserCreds();
        return cred;
    }

    public void finishRequest(MRCRequest rq) {
        this.master.requestFinished(rq);
    }

    public void finishRequest(MRCRequest rq, ErrorRecord error) {
        rq.setError(error);
        this.master.requestFinished(rq);
    }

    protected void validateContext(MRCRequest rq) throws UserException, IOException {
        RPC.UserCredentials ctx = this.getUserCredentials(rq);
        if (ctx == null || ctx.getGroupsCount() == 0 || ctx.getUsername().length() == 0) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EACCES, "UserCredentials must contain a non-empty userID and at least one groupID!");
        }
    }
}

