/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.net.InetSocketAddress;
import org.xtreemfs.common.Capability;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class MoveOperation
extends MRCOperation {
    public MoveOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        MRC.renameRequest rqArgs = (MRC.renameRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path sp = new Path(rqArgs.getVolumeName(), rqArgs.getSourcePath());
        StorageManager sMan = vMan.getStorageManagerByName(sp.getComp(0));
        PathResolver sRes = new PathResolver(sMan, sp);
        VolumeInfo volume = sMan.getVolumeInfo();
        faMan.checkSearchPermission(sMan, sRes, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        faMan.checkPermission(FileAccessManager.O_WRONLY, sMan, sRes.getParentDir(), sRes.getParentsParentId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        Path tp = new Path(rqArgs.getVolumeName(), rqArgs.getTargetPath());
        if (sp.getCompCount() == 1) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "cannot move a volume");
        }
        if (!sp.getComp(0).equals(tp.getComp(0))) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "cannot move between volumes");
        }
        sRes.checkIfFileDoesNotExist();
        faMan.checkPermission(0x400000, sMan, sRes.getFile(), sRes.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        FileMetadata source = sRes.getFile();
        MRCHelper.FileType sourceType = source.isDirectory() ? MRCHelper.FileType.dir : MRCHelper.FileType.file;
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        PathResolver tRes = null;
        tRes = new PathResolver(sMan, tp);
        FileMetadata targetParentDir = tRes.getParentDir();
        if (targetParentDir == null || !targetParentDir.isDirectory()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOTDIR, "'" + tp.getComps(0, tp.getCompCount() - 2) + "' is not a directory");
        }
        FileMetadata target = tRes.getFile();
        MRCHelper.FileType targetType = tp.getCompCount() == 1 ? MRCHelper.FileType.dir : (target == null ? MRCHelper.FileType.nexists : (target.isDirectory() ? MRCHelper.FileType.dir : MRCHelper.FileType.file));
        GlobalTypes.FileCredentials.Builder creds = null;
        if (sp.equals(tp)) {
            rq.setResponse(MoveOperation.buildResponse(0, creds));
            this.finishRequest(rq);
            return;
        }
        faMan.checkSearchPermission(sMan, tRes, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        faMan.checkPermission(FileAccessManager.O_WRONLY, sMan, tRes.getParentDir(), tRes.getParentsParentId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        block0 : switch (sourceType) {
            case dir: {
                if (tp.isSubDirOf(sp)) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "cannot move '" + sp + "' to one of its own subdirectories");
                }
                switch (targetType) {
                    case nexists: {
                        MoveOperation.relink(sMan, sRes.getParentDirId(), sRes.getFileName(), source, tRes.getParentDirId(), tRes.getFileName(), update);
                        break block0;
                    }
                    case dir: {
                        faMan.checkPermission(0x200000, sMan, target, tRes.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
                        DatabaseResultSet<FileMetadata> children = sMan.getChildren(target.getId(), 0, Integer.MAX_VALUE);
                        boolean hasChildren = children.hasNext();
                        children.destroy();
                        if (hasChildren) {
                            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOTEMPTY, "target directory '" + tRes + "' is not empty");
                        }
                        sMan.delete(tRes.getParentDirId(), tRes.getFileName(), update);
                        MoveOperation.relink(sMan, sRes.getParentDirId(), sRes.getFileName(), source, tRes.getParentDirId(), tRes.getFileName(), update);
                        break block0;
                    }
                    case file: {
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOTDIR, "cannot rename directory '" + sRes + "' to file '" + tRes + "'");
                    }
                }
                break;
            }
            case file: {
                switch (targetType) {
                    case nexists: {
                        MoveOperation.relink(sMan, sRes.getParentDirId(), sRes.getFileName(), source, tRes.getParentDirId(), tRes.getFileName(), update);
                        break block0;
                    }
                    case dir: {
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EISDIR, "cannot rename file '" + sRes + "' to directory '" + tRes + "'");
                    }
                    case file: {
                        faMan.checkPermission(0x400000, sMan, tRes.getFile(), tRes.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
                        if (sMan.getSoftlinkTarget(target.getId()) == null && target.getLinkCount() == 1) {
                            Capability cap = new Capability(MRCHelper.createGlobalFileId(volume, target), 0x200000, this.master.getConfig().getCapabilityTimeout(), Integer.MAX_VALUE, ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress().getHostAddress(), target.getEpoch(), false, !volume.isSnapshotsEnabled() ? GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED : (volume.isSnapVolume() ? GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP : GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_CURRENT), volume.getCreationTime(), this.master.getConfig().getCapabilitySecret());
                            creds = GlobalTypes.FileCredentials.newBuilder().setXcap(cap.getXCap()).setXlocs(Converter.xLocListToXLocSet(target.getXLocList()));
                        }
                        sMan.delete(tRes.getParentDirId(), tRes.getFileName(), update);
                        MoveOperation.relink(sMan, sRes.getParentDirId(), sRes.getFileName(), source, tRes.getParentDirId(), tRes.getFileName(), update);
                    }
                }
            }
        }
        MRCHelper.updateFileTimes(sRes.getParentsParentId(), sRes.getParentDir(), false, true, true, sMan, time, update);
        MRCHelper.updateFileTimes(tRes.getParentsParentId(), tRes.getParentDir(), false, true, true, sMan, time, update);
        rq.setResponse(MoveOperation.buildResponse(time, creds));
        update.execute();
    }

    private static void relink(StorageManager sMan, long sourceParentDirId, String sourceFileName, FileMetadata source, long targetParentDirId, String targetFileName, AtomicDBUpdate update) throws DatabaseException {
        short newLinkCount = sMan.unlink(sourceParentDirId, sourceFileName, update);
        source.setLinkCount(newLinkCount);
        source.setCtime((int)(TimeSync.getGlobalTime() / 1000L));
        sMan.link(source, targetParentDirId, targetFileName, update);
    }

    private static MRC.renameResponse buildResponse(int time, GlobalTypes.FileCredentials.Builder creds) {
        MRC.renameResponse.Builder resp = MRC.renameResponse.newBuilder();
        if (creds != null) {
            resp.setCreds(creds);
        }
        resp.setTimestampS(time);
        return resp.build();
    }
}

