/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.xtreemfs.common.Capability;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.ReplicationPolicy;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.stages.XLocSetLock;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class OpenOperation
extends MRCOperation {
    public OpenOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        boolean replicateOnClose;
        ReplicationPolicy defaultReplPolicy;
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        MRC.openRequest rqArgs = (MRC.openRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        VolumeInfo volume = sMan.getVolumeInfo();
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        FileMetadata file = null;
        boolean create = (rqArgs.getFlags() & FileAccessManager.O_CREAT) != 0;
        boolean excl = (rqArgs.getFlags() & FileAccessManager.O_EXCL) != 0;
        boolean truncate = (rqArgs.getFlags() & FileAccessManager.O_TRUNC) != 0;
        boolean write = (rqArgs.getFlags() & (FileAccessManager.O_WRONLY | FileAccessManager.O_RDWR)) != 0;
        boolean createNew = false;
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        try {
            long volumeQuota = volume.getVolumeQuota();
            if ((write || create) && volumeQuota != 0L && volumeQuota <= volume.getVolumeSize()) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOSPC, "the volume's quota is reached");
            }
            res.checkIfFileDoesNotExist();
            if (create && excl) {
                res.checkIfFileExistsAlready();
            }
            if ((file = res.getFile()).isDirectory() || sMan.getSoftlinkTarget(file.getId()) != null) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EISDIR, "open is restricted to files");
            }
            if (file.isReadOnly() && (rqArgs.getFlags() & (FileAccessManager.O_RDWR | FileAccessManager.O_WRONLY | FileAccessManager.O_TRUNC | FileAccessManager.O_APPEND)) != 0) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "read-only files cannot be written");
            }
            faMan.checkPermission(rqArgs.getFlags(), sMan, file, res.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        }
        catch (UserException exc) {
            if (exc.getErrno() == RPC.POSIXErrno.POSIX_ERROR_ENOENT && create) {
                faMan.checkPermission(FileAccessManager.O_WRONLY, sMan, res.getParentDir(), res.getParentsParentId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
                long fileId = sMan.getNextFileId();
                if ((rqArgs.getMode() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFIFO.getNumber()) != 0) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EIO, "FIFOs not supported");
                }
                file = sMan.createFile(fileId, res.getParentDirId(), res.getFileName(), time, time, time, rq.getDetails().userId, rq.getDetails().groupIds.get(0), rqArgs.getMode(), rqArgs.getAttributes(), 0L, false, 0, 0, update);
                sMan.setLastFileId(fileId, update);
                createNew = true;
            }
            throw exc;
        }
        XLocList xLocList = file.getXLocList();
        XLocSetLock lock = this.master.getXLocSetCoordinator().getXLocSetLock(file, sMan);
        if (lock.isLocked()) {
            if (lock.hasCrashed()) {
                XLoc[] replicas = new XLoc[xLocList.getReplicaCount()];
                for (int i = 0; i < xLocList.getReplicaCount(); ++i) {
                    replicas[i] = xLocList.getReplica(i);
                }
                xLocList = sMan.createXLocList(replicas, xLocList.getReplUpdatePolicy(), xLocList.getVersion() + 1);
                this.master.getXLocSetCoordinator().unlockXLocSet(file, sMan, update);
            } else {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EAGAIN, "xLocSet change already in progress. Please retry.");
            }
        }
        int trEpoch = file.getEpoch();
        if (truncate) {
            file.setIssuedEpoch(file.getIssuedEpoch() + 1);
            trEpoch = file.getIssuedEpoch();
            sMan.setMetadata(file, (byte)1, update);
        }
        if ((defaultReplPolicy = sMan.getDefaultReplicationPolicy(res.getParentDirId())) == null) {
            defaultReplPolicy = sMan.getDefaultReplicationPolicy(1L);
        }
        boolean bl = replicateOnClose = defaultReplPolicy != null && "ronly".equals(defaultReplPolicy.getName());
        if ((xLocList == null || xLocList.getReplicaCount() == 0) && (create || write)) {
            boolean singleReplica;
            boolean bl2 = singleReplica = defaultReplPolicy == null || "".equals(defaultReplPolicy.getName()) || replicateOnClose;
            if (singleReplica) {
                XLoc replica = MRCHelper.createReplica(null, sMan, this.master.getOSDStatusManager(), volume, res.getParentDirId(), p.toString(), ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress(), rqArgs.getCoordinates(), xLocList, 0);
                String[] osds = new String[replica.getOSDCount()];
                for (int j = 0; j < osds.length; ++j) {
                    osds[j] = replica.getOSD(j);
                }
                ArrayList<XLoc> repls = new ArrayList<XLoc>();
                repls.add(replica);
                xLocList = sMan.createXLocList(repls.toArray(new XLoc[repls.size()]), "", 0);
            } else {
                int numReplicas = 1;
                if (defaultReplPolicy != null) {
                    numReplicas = defaultReplPolicy.getFactor();
                }
                ArrayList<XLoc> repls = new ArrayList<XLoc>();
                for (int i = 0; i < numReplicas; ++i) {
                    XLoc replica = MRCHelper.createReplica(null, sMan, this.master.getOSDStatusManager(), volume, res.getParentDirId(), p.toString(), ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress(), rqArgs.getCoordinates(), xLocList, defaultReplPolicy != null ? defaultReplPolicy.getFlags() : 0);
                    String[] osds = new String[replica.getOSDCount()];
                    for (int j = 0; j < osds.length; ++j) {
                        osds[j] = replica.getOSD(j);
                    }
                    repls.add(replica);
                    xLocList = sMan.createXLocList(repls.toArray(new XLoc[repls.size()]), defaultReplPolicy != null ? defaultReplPolicy.getName() : "", 0);
                }
            }
            file.setXLocList(xLocList);
            sMan.setMetadata(file, (byte)1, update);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "assigned the following XLoc list to file %s:%d: %s", volume.getId(), file.getId(), xLocList.toString());
            }
        }
        GlobalTypes.XLocSet.Builder xLocSet = Converter.xLocListToXLocSet(xLocList);
        List<GlobalTypes.Replica> sortedReplList = this.master.getOSDStatusManager().getSortedReplicaList(volume.getId(), ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress(), rqArgs.getCoordinates(), xLocSet.getReplicasList(), xLocList).getReplicasList();
        xLocSet.clearReplicas();
        xLocSet.addAllReplicas(sortedReplList);
        xLocSet.setReadOnlyFileSize(file.getSize());
        Capability cap = new Capability(MRCHelper.createGlobalFileId(volume, file), rqArgs.getFlags(), this.master.getConfig().getCapabilityTimeout(), TimeSync.getGlobalTime() / 1000L + (long)this.master.getConfig().getCapabilityTimeout(), ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress().getHostAddress(), trEpoch, replicateOnClose, !volume.isSnapshotsEnabled() ? GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED : (volume.isSnapVolume() ? GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP : GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_CURRENT), volume.getCreationTime(), this.master.getConfig().getCapabilitySecret());
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.proc, this, "issued the following capability for %s:%d: %s", volume.getId(), file.getId(), cap.toString());
        }
        if (createNew || truncate) {
            MRCHelper.updateFileTimes(res.getParentsParentId(), file, createNew ? !this.master.getConfig().isNoAtime() : false, true, true, sMan, time, update);
        } else if (!this.master.getConfig().isNoAtime()) {
            MRCHelper.updateFileTimes(res.getParentsParentId(), file, true, false, false, sMan, time, update);
        } else {
            time = 0;
        }
        if (createNew) {
            MRCHelper.updateFileTimes(res.getParentsParentId(), res.getParentDir(), false, true, true, sMan, time, update);
        }
        rq.setResponse(MRC.openResponse.newBuilder().setCreds(GlobalTypes.FileCredentials.newBuilder().setXcap(cap.getXCap()).setXlocs(xLocSet)).setTimestampS(time).build());
        update.execute();
    }
}

