/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.io.File;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCException;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class ReadDirAndStatOperation
extends MRCOperation {
    public ReadDirAndStatOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        long knownEtag;
        MRC.Stat stat;
        long newEtag;
        MRC.readdirRequest rqArgs = (MRC.readdirRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        VolumeInfo volume = sMan.getVolumeInfo();
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        res.checkIfFileDoesNotExist();
        FileMetadata file = res.getFile();
        faMan.checkPermission(FileAccessManager.O_RDONLY, sMan, file, res.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        int seenEntries = (int)rqArgs.getSeenDirectoryEntriesCount();
        int numEntries = rqArgs.getLimitDirectoryEntriesCount() <= 0 ? Integer.MAX_VALUE : rqArgs.getLimitDirectoryEntriesCount();
        boolean namesOnly = rqArgs.getNamesOnly();
        try {
            faMan.checkPermission(0x100000, sMan, file, res.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        }
        catch (UserException exc) {
            if (exc.getErrno() == RPC.POSIXErrno.POSIX_ERROR_EACCES) {
                namesOnly = true;
            }
            throw exc;
        }
        MRC.DirectoryEntries.Builder dirContent = MRC.DirectoryEntries.newBuilder();
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        if (!this.master.getConfig().isNoAtime()) {
            MRCHelper.updateFileTimes(res.getParentDirId(), file, true, false, false, sMan, time, update);
        }
        FileMetadata parentDir = res.getParentDir();
        if (seenEntries == 0 && numEntries > 0) {
            MRC.DirectoryEntry.Builder entry;
            if (parentDir != null) {
                entry = MRC.DirectoryEntry.newBuilder().setName("..");
                if (!namesOnly) {
                    entry.setStbuf(this.getStat(sMan, faMan, rq, volume, parentDir));
                }
                dirContent.addEntries(entry);
            } else {
                entry = MRC.DirectoryEntry.newBuilder().setName("..");
                if (!namesOnly) {
                    entry.setStbuf(this.getStat(sMan, faMan, rq, volume, file));
                }
                dirContent.addEntries(entry);
            }
        }
        if ((newEtag = (stat = this.getStat(sMan, faMan, rq, volume, file)).getEtag()) != (knownEtag = rqArgs.getKnownEtag())) {
            if (seenEntries == 0 && numEntries >= 2 || seenEntries == 1 && numEntries >= 1) {
                MRC.DirectoryEntry.Builder entry = MRC.DirectoryEntry.newBuilder().setName(".");
                if (!namesOnly) {
                    entry.setStbuf(stat);
                }
                dirContent.addEntries(entry);
            }
            DatabaseResultSet<FileMetadata> it = sMan.getChildren(res.getFile().getId(), seenEntries - 2, numEntries - dirContent.getEntriesCount());
            while (it.hasNext()) {
                FileMetadata child = (FileMetadata)it.next();
                if (child.getFileName().equals("")) {
                    Logging.logMessage(4, this, "WARNING: found nested %s w/ empty name", child.isDirectory() ? "directory" : "file");
                    continue;
                }
                MRC.DirectoryEntry.Builder entry = MRC.DirectoryEntry.newBuilder().setName(child.getFileName());
                if (!namesOnly) {
                    entry.setStbuf(this.getStat(sMan, faMan, rq, volume, child));
                }
                dirContent.addEntries(entry);
            }
            it.destroy();
        }
        rq.setResponse(dirContent.build());
        update.execute();
    }

    private MRC.Stat getStat(StorageManager sMan, FileAccessManager faMan, MRCRequest rq, VolumeInfo volume, FileMetadata file) throws DatabaseException, MRCException {
        XLocList xlocList;
        String linkTarget = sMan.getSoftlinkTarget(file.getId());
        int mode = faMan.getPosixAccessMode(sMan, file, rq.getDetails().userId, rq.getDetails().groupIds);
        mode |= linkTarget != null ? GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFLNK.getNumber() : (file.isDirectory() ? GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFDIR.getNumber() : ((file.getPerms() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFIFO.getNumber()) != 0 ? GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFIFO.getNumber() : GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFREG.getNumber()));
        long size = linkTarget != null ? (long)linkTarget.length() : (file.isDirectory() ? 0L : file.getSize());
        int blkSize = 0;
        if (linkTarget == null && !file.isDirectory() && (xlocList = file.getXLocList()) != null && xlocList.getReplicaCount() > 0) {
            blkSize = xlocList.getReplica(0).getStripingPolicy().getStripeSize() * 1024;
        }
        long newEtag = file.getMtime() + file.getCtime();
        MRC.Stat stat = MRC.Stat.newBuilder().setDev(volume.getId().hashCode()).setIno(file.getId()).setMode(mode).setNlink(file.getLinkCount()).setUserId(file.getOwnerId()).setGroupId(file.getOwningGroupId()).setSize(size).setAtimeNs((long)file.getAtime() * 1000000000L).setCtimeNs((long)file.getCtime() * 1000000000L).setMtimeNs((long)file.getMtime() * 1000000000L).setBlksize(blkSize).setTruncateEpoch(file.isDirectory() ? 0 : file.getEpoch()).setAttributes((int)file.getW32Attrs()).setEtag(newEtag).build();
        return stat;
    }

    public static void main(String[] args) throws Exception {
        String path = "/home/stender/mnt";
        File f = new File(path);
        System.out.println(f.createNewFile());
    }
}

