/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.net.InetSocketAddress;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.xloc.ReplicationFlags;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.stages.XLocSetCoordinator;
import org.xtreemfs.mrc.stages.XLocSetCoordinatorCallback;
import org.xtreemfs.mrc.stages.XLocSetLock;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class RemoveReplicaOperation
extends MRCOperation
implements XLocSetCoordinatorCallback {
    public RemoveReplicaOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        int i;
        FileMetadata file;
        StorageManager sMan;
        String volumeId;
        String fileId;
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        MRC.xtreemfs_replica_removeRequest rqArgs = (MRC.xtreemfs_replica_removeRequest)rq.getRequestArgs();
        FileAccessManager faMan = this.master.getFileAccessManager();
        VolumeManager vMan = this.master.getVolumeManager();
        this.validateContext(rq);
        if (rqArgs.hasFileId()) {
            fileId = rqArgs.getFileId();
            MRCHelper.GlobalFileIdResolver idRes = new MRCHelper.GlobalFileIdResolver(fileId);
            volumeId = idRes.getVolumeId();
            sMan = vMan.getStorageManager(idRes.getVolumeId());
            file = sMan.getMetadata(idRes.getLocalFileId());
            if (file == null) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + rqArgs.getFileId() + "' does not exist");
            }
        } else if (rqArgs.hasVolumeName() && rqArgs.hasPath()) {
            Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
            sMan = vMan.getStorageManagerByName(p.getComp(0));
            volumeId = sMan.getVolumeInfo().getId();
            PathResolver res = new PathResolver(sMan, p);
            res.checkIfFileDoesNotExist();
            file = res.getFile();
            fileId = MRCHelper.createGlobalFileId(sMan.getVolumeInfo(), file);
            faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        } else {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "either file ID or volume name + path required");
        }
        if (file.isDirectory()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "replicas may only be removed from files");
        }
        if (sMan.getSoftlinkTarget(file.getId()) != null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "file '" + rqArgs.getFileId() + "' is a symbolic link");
        }
        XLocSetLock lock = this.master.getXLocSetCoordinator().getXLocSetLock(file, sMan);
        if (lock.isLocked()) {
            if (lock.hasCrashed()) {
                if (Logging.isDebug()) {
                    Logging.logMessage(7, this, "Previous xLocSet change did not finish.", new Object[0]);
                }
            } else {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EAGAIN, "xLocSet change already in progress. Please retry.");
            }
        }
        faMan.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        XLocList oldXLocList = file.getXLocList();
        assert (oldXLocList != null);
        if ("".equals(oldXLocList.getReplUpdatePolicy())) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Replica cannot be removed because the file's replication policy is set to 'none' i.e., the file has only one replica which shouldn't be deleted. Delete the whole file instead.");
        }
        XLoc replica = null;
        for (i = 0; i < oldXLocList.getReplicaCount() && !(replica = oldXLocList.getReplica(i)).getOSD(0).equals(rqArgs.getOsdUuid()); ++i) {
        }
        if (i == oldXLocList.getReplicaCount()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "OSD '" + rqArgs.getOsdUuid() + "' is not head OSD of any replica");
        }
        XLoc[] newReplList = new XLoc[oldXLocList.getReplicaCount() - 1];
        int count = 0;
        for (int j = 0; j < oldXLocList.getReplicaCount(); ++j) {
            if (j == i) continue;
            newReplList[count++] = oldXLocList.getReplica(j);
        }
        XLocList newXLocList = sMan.createXLocList(newReplList, oldXLocList.getReplUpdatePolicy(), oldXLocList.getVersion() + 1);
        if ("ronly".equals(oldXLocList.getReplUpdatePolicy())) {
            boolean completeOrFullExists = false;
            for (int k = 0; k < newXLocList.getReplicaCount(); ++k) {
                if (!ReplicationFlags.isReplicaComplete(newXLocList.getReplica(k).getReplicationFlags()) && !ReplicationFlags.isFullReplica(newXLocList.getReplica(k).getReplicationFlags())) continue;
                completeOrFullExists = true;
                break;
            }
            if (!completeOrFullExists) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Could not remove OSD '" + rqArgs.getOsdUuid() + "': read-only replication w/ partial replicas requires at " + "least one remaining replica that is full or complete");
            }
        }
        XLocSetCoordinator coordinator = this.master.getXLocSetCoordinator();
        XLocSetCoordinator.RequestMethod m = coordinator.removeReplicas(fileId, file, oldXLocList, newXLocList, rq, this);
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(coordinator, m);
        coordinator.lockXLocSet(file, sMan, update);
        update.execute();
    }

    @Override
    public void installXLocSet(MRCRequest rq, String fileId, XLocList xLocList, XLocList oldXLocList) throws Throwable {
        MRCHelper.GlobalFileIdResolver idRes;
        VolumeManager vMan = this.master.getVolumeManager();
        StorageManager sMan = vMan.getStorageManager((idRes = new MRCHelper.GlobalFileIdResolver(fileId)).getVolumeId());
        FileMetadata file = sMan.getMetadata(idRes.getLocalFileId());
        if (file == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + fileId + "' does not exist");
        }
        file.setXLocList(xLocList);
        if (xLocList.getReplicaCount() == 1) {
            file.setReadOnly(false);
        }
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        sMan.setMetadata(file, (byte)1, update);
        this.master.getXLocSetCoordinator().unlockXLocSet(file, sMan, update);
        Capability deleteCap = new Capability(idRes.getVolumeId() + ":" + file.getId(), 0x200000, this.master.getConfig().getCapabilityTimeout(), Integer.MAX_VALUE, ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress().getHostAddress(), file.getEpoch(), false, !sMan.getVolumeInfo().isSnapshotsEnabled() ? GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED : (sMan.getVolumeInfo().isSnapVolume() ? GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP : GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_CURRENT), sMan.getVolumeInfo().getCreationTime(), this.master.getConfig().getCapabilitySecret());
        GlobalTypes.XLocSet.Builder xLocSet = Converter.xLocListToXLocSet(oldXLocList);
        GlobalTypes.FileCredentials fc = GlobalTypes.FileCredentials.newBuilder().setXcap(deleteCap.getXCap()).setXlocs(xLocSet).build();
        rq.setResponse(fc);
        update.execute();
    }
}

