/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.common.Capability;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class RenewOperation
extends MRCOperation {
    public final boolean renewTimedOutCaps;

    public RenewOperation(MRCRequestDispatcher master) {
        super(master);
        this.renewTimedOutCaps = master.getConfig().isRenewTimedOutCaps();
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        GlobalTypes.XCap xcap = (GlobalTypes.XCap)rq.getRequestArgs();
        Capability cap = new Capability(xcap, this.master.getConfig().getCapabilitySecret());
        if (!cap.hasValidSignature()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, cap + " does not have a valid signature");
        }
        if (cap.hasExpired() && !this.renewTimedOutCaps) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, cap + " has expired");
        }
        Capability newCap = new Capability(cap.getFileId(), cap.getAccessMode(), this.master.getConfig().getCapabilityTimeout(), TimeSync.getGlobalTime() / 1000L + (long)this.master.getConfig().getCapabilityTimeout(), cap.getClientIdentity(), cap.getEpochNo(), cap.isReplicateOnClose(), cap.getSnapConfig(), cap.getSnapTimestamp(), this.master.getConfig().getCapabilitySecret());
        rq.setResponse(newCap.getXCap());
        this.finishRequest(rq);
    }
}

