/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.ErrorRecord;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.DBAdminHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class RestoreDBOperation
extends MRCOperation {
    public RestoreDBOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        try {
            MRC.xtreemfs_dump_restore_databaseRequest rqArgs = (MRC.xtreemfs_dump_restore_databaseRequest)rq.getRequestArgs();
            if (this.master.getConfig().getAdminPassword().length() > 0 && !this.master.getConfig().getAdminPassword().equals(rq.getDetails().password)) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "invalid password");
            }
            final VolumeManager vMan = this.master.getVolumeManager();
            if (vMan.getStorageManagers() == null) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "cannot restore database because volume manager has not yet been initialized");
            }
            if (vMan.getStorageManagers().size() != 0) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "Restoring from a dump is only possible on an MRC with no database. Please delete the existing MRC database on the server and restart the MRC!");
            }
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(new File(rqArgs.getDumpFile()), new DefaultHandler(){
                private DBAdminHelper.DBRestoreState state;
                private int dbVersion = 1;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    try {
                        if (qName.equals("volume")) {
                            this.state = new DBAdminHelper.DBRestoreState();
                            this.state.currentVolumeId = attributes.getValue(attributes.getIndex("id"));
                            this.state.currentVolumeName = attributes.getValue(attributes.getIndex("name"));
                            this.state.currentVolumeACPolicy = Short.parseShort(attributes.getValue(attributes.getIndex("acPolicy")));
                            this.state.currentVolumeQuota = Long.valueOf(attributes.getValue(attributes.getIndex("quota")));
                        } else if (qName.equals("filesystem")) {
                            try {
                                this.dbVersion = Integer.parseInt(attributes.getValue(attributes.getIndex("dbversion")));
                            }
                            catch (Exception exc) {
                                Logging.logMessage(4, Logging.Category.storage, this, "restoring database with invalid version number", new Object[0]);
                            }
                        } else {
                            this.handleNestedElement(qName, attributes, true);
                        }
                    }
                    catch (Exception exc) {
                        Logging.logMessage(3, Logging.Category.storage, this, "could not restore DB from XML dump", new Object[0]);
                        Logging.logUserError(3, Logging.Category.storage, this, exc);
                        throw new SAXException(exc);
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    try {
                        if (qName.equals("slice") || qName.equals("filesystem")) {
                            return;
                        }
                        this.handleNestedElement(qName, null, false);
                    }
                    catch (Exception exc) {
                        Logging.logMessage(3, Logging.Category.storage, this, "could not restore DB from XML dump", new Object[0]);
                        Logging.logUserError(3, Logging.Category.storage, this, exc);
                        throw new SAXException(exc);
                    }
                }

                private void handleNestedElement(String qName, Attributes attributes, boolean openTag) throws UserException, DatabaseException {
                    if (qName.equalsIgnoreCase("volume")) {
                        StorageManager sMan = vMan.getStorageManager(this.state.currentVolumeId);
                        AtomicDBUpdate update = sMan.createAtomicDBUpdate(null, null);
                        sMan.setLastFileId(this.state.largestFileId, update);
                        update.execute();
                        this.state.largestFileId = 0L;
                    } else if (qName.equalsIgnoreCase("dir")) {
                        DBAdminHelper.restoreDir(vMan, RestoreDBOperation.this.master.getFileAccessManager(), attributes, this.state, this.dbVersion, openTag);
                    } else if (qName.equalsIgnoreCase("file")) {
                        DBAdminHelper.restoreFile(vMan, RestoreDBOperation.this.master.getFileAccessManager(), attributes, this.state, this.dbVersion, openTag);
                    } else if (qName.equalsIgnoreCase("xLocList")) {
                        DBAdminHelper.restoreXLocList(vMan, RestoreDBOperation.this.master.getFileAccessManager(), attributes, this.state, this.dbVersion, openTag);
                    } else if (qName.equalsIgnoreCase("xLoc")) {
                        DBAdminHelper.restoreXLoc(vMan, RestoreDBOperation.this.master.getFileAccessManager(), attributes, this.state, this.dbVersion, openTag);
                    } else if (qName.equalsIgnoreCase("osd")) {
                        DBAdminHelper.restoreOSD(vMan, RestoreDBOperation.this.master.getFileAccessManager(), attributes, this.state, this.dbVersion, openTag);
                    } else if (qName.equalsIgnoreCase("acl")) {
                        DBAdminHelper.restoreACL(vMan, RestoreDBOperation.this.master.getFileAccessManager(), attributes, this.state, this.dbVersion, openTag);
                    } else if (qName.equalsIgnoreCase("entry")) {
                        DBAdminHelper.restoreEntry(vMan, RestoreDBOperation.this.master.getFileAccessManager(), attributes, this.state, this.dbVersion, openTag);
                    } else if (qName.equalsIgnoreCase("attr")) {
                        DBAdminHelper.restoreAttr(vMan, RestoreDBOperation.this.master.getFileAccessManager(), attributes, this.state, this.dbVersion, openTag);
                    }
                }
            });
            rq.setResponse(Common.emptyResponse.getDefaultInstance());
            this.finishRequest(rq);
        }
        catch (SAXException exc) {
            this.finishRequest(rq, new ErrorRecord(RPC.ErrorType.ERRNO, RPC.POSIXErrno.POSIX_ERROR_NONE, exc.getException().getMessage() == null ? "an error has occurred" : exc.getException().getMessage(), exc.getException()));
        }
    }
}

