/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class RestoreFileOperation
extends MRCOperation {
    public RestoreFileOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        MRC.xtreemfs_restore_fileRequest rqArgs = (MRC.xtreemfs_restore_fileRequest)rq.getRequestArgs();
        if (this.master.getConfig().getAdminPassword().length() > 0 && !this.master.getConfig().getAdminPassword().equals(rq.getDetails().password)) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "invalid password");
        }
        VolumeManager vMan = this.master.getVolumeManager();
        MRCHelper.GlobalFileIdResolver idRes = new MRCHelper.GlobalFileIdResolver(rqArgs.getFileId());
        Path p = new Path(vMan.getStorageManager(idRes.getVolumeId()).getVolumeInfo().getName(), rqArgs.getFilePath());
        StorageManager sMan = vMan.getStorageManager(idRes.getVolumeId());
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        long nextFileId = sMan.getNextFileId();
        FileMetadata[] path = sMan.resolvePath(p);
        long parentId = 1L;
        for (int i = 0; i < p.getCompCount(); ++i) {
            try {
                if (path[i] != null) {
                    parentId = path[i].getId();
                    continue;
                }
                sMan.createDir(nextFileId, parentId, p.getComp(i), time, time, time, rq.getDetails().userId, rq.getDetails().groupIds.get(0), 509, 0L, update);
                parentId = nextFileId++;
                sMan.setLastFileId(nextFileId, update);
                continue;
            }
            catch (DatabaseException exc) {
                if (exc.getType() == DatabaseException.ExceptionType.FILE_EXISTS) continue;
                throw exc;
            }
        }
        FileMetadata file = sMan.createFile(idRes.getLocalFileId(), parentId, rqArgs.getFileId(), time, time, time, rq.getDetails().userId, rq.getDetails().groupIds.get(0), 511, 0L, rqArgs.getFileSize(), false, 0, 0, update);
        int size = rqArgs.getStripeSize() < 1024 ? 1 : (rqArgs.getStripeSize() % 1024 != 0 ? rqArgs.getStripeSize() / 1024 + 1 : rqArgs.getStripeSize() / 1024);
        StripingPolicy sp = sMan.createStripingPolicy(GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0.name(), size, 1);
        XLoc replica = sMan.createXLoc(sp, new String[]{rqArgs.getOsdUuid()}, 0);
        XLocList xLocList = sMan.createXLocList(new XLoc[]{replica}, "", 0);
        file.setXLocList(xLocList);
        sMan.setMetadata(file, (byte)1, update);
        rq.setResponse(Common.emptyResponse.getDefaultInstance());
        update.execute();
    }
}

