/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class SetReadOnlyXattrOperation
extends MRCOperation {
    public SetReadOnlyXattrOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.xtreemfs_set_read_only_xattrRequest rqArgs = (MRC.xtreemfs_set_read_only_xattrRequest)rq.getRequestArgs();
        FileAccessManager fam = this.master.getFileAccessManager();
        VolumeManager vMan = this.master.getVolumeManager();
        this.validateContext(rq);
        MRCHelper.GlobalFileIdResolver gfr = new MRCHelper.GlobalFileIdResolver(rqArgs.getFileId());
        String volId = gfr.getVolumeId();
        Long localFileID = gfr.getLocalFileId();
        StorageManager sMan = vMan.getStorageManager(volId);
        FileMetadata file = sMan.getMetadata(localFileID);
        if (file == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + rqArgs.getFileId() + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "replica-update policies may only be set on files");
        }
        fam.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        Boolean currentMode = file.isReadOnly();
        if (currentMode.booleanValue() == rqArgs.getValue()) {
            if (Logging.isDebug()) {
                Logging.logMessage(6, Logging.Category.storage, (Object)null, "File with fileID %s has already set Xattr xtreemfs.read_only=%s", localFileID, currentMode.toString());
            }
            rq.setResponse(MRC.xtreemfs_set_read_only_xattrResponse.newBuilder().setWasSet(false).build());
            this.finishRequest(rq);
        } else {
            AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
            file.setReadOnly(rqArgs.getValue());
            sMan.setMetadata(file, (byte)1, update);
            rq.setResponse(MRC.xtreemfs_set_read_only_xattrResponse.newBuilder().setWasSet(true).build());
            update.execute();
        }
    }
}

