/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.stages.XLocSetLock;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class SetReplicaUpdatePolicyOperation
extends MRCOperation {
    public SetReplicaUpdatePolicyOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.xtreemfs_set_replica_update_policyRequest rqArgs = (MRC.xtreemfs_set_replica_update_policyRequest)rq.getRequestArgs();
        String newReplUpdatePolicy = rqArgs.getUpdatePolicy();
        FileAccessManager fam = this.master.getFileAccessManager();
        VolumeManager vMan = this.master.getVolumeManager();
        this.validateContext(rq);
        MRCHelper.GlobalFileIdResolver gfr = new MRCHelper.GlobalFileIdResolver(rqArgs.getFileId());
        String volId = gfr.getVolumeId();
        Long localFileID = gfr.getLocalFileId();
        StorageManager sMan = vMan.getStorageManager(volId);
        FileMetadata file = sMan.getMetadata(localFileID);
        if (file == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + rqArgs.getFileId() + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "replica-update policies may only be set on files");
        }
        fam.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        XLocSetLock lock = this.master.getXLocSetCoordinator().getXLocSetLock(file, sMan);
        if (lock.isLocked()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EAGAIN, "xLocSet change already in progress. Please retry.");
        }
        XLocList curXLocList = file.getXLocList();
        if ("".equals(newReplUpdatePolicy) && curXLocList.getReplicaCount() > 1) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "number of replicas has to be reduced 1 before replica update policy can be set to  (current replica count = " + curXLocList.getReplicaCount() + ")");
        }
        if ("WaRa".equals(newReplUpdatePolicy)) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Do no longer use the policy WaRa. Instead you're probably looking for the WaR1 policy (write all replicas, read from one)." + newReplUpdatePolicy);
        }
        if (!("WaR1".equals(newReplUpdatePolicy) || "".equals(newReplUpdatePolicy) || "ronly".equals(newReplUpdatePolicy) || "WqRq".equals(newReplUpdatePolicy))) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid replica update policy: " + newReplUpdatePolicy);
        }
        StripingPolicy stripingPolicy = file.getXLocList().getReplica(0).getStripingPolicy();
        if (stripingPolicy.getWidth() > 1 && (newReplUpdatePolicy.equals("WaR1") || newReplUpdatePolicy.equals("WqRq"))) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "RW-replication of striped files is not supported yet.");
        }
        XLoc[] xLocs = new XLoc[file.getXLocList().getReplicaCount()];
        for (int i = 0; i < file.getXLocList().getReplicaCount(); ++i) {
            xLocs[i] = file.getXLocList().getReplica(i);
        }
        XLocList newXLocList = sMan.createXLocList(xLocs, newReplUpdatePolicy, file.getXLocList().getVersion() + 1);
        file.setXLocList(newXLocList);
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        sMan.setMetadata(file, (byte)1, update);
        MRC.xtreemfs_set_replica_update_policyResponse response = MRC.xtreemfs_set_replica_update_policyResponse.newBuilder().setOldUpdatePolicy(curXLocList.getReplUpdatePolicy()).build();
        rq.setResponse(response);
        update.execute();
    }
}

