/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class SetXAttrOperation
extends MRCOperation {
    public SetXAttrOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        byte[] attrVal;
        MRC.setxattrRequest rqArgs = (MRC.setxattrRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        res.checkIfFileDoesNotExist();
        FileMetadata file = res.getFile();
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        String attrKey = rqArgs.getName();
        Object object = rqArgs.hasValueBytesString() ? rqArgs.getValueBytesString().toByteArray() : (attrVal = (Object)(rqArgs.hasValue() ? rqArgs.getValue().getBytes() : null));
        if (attrKey.startsWith("xtreemfs.")) {
            boolean privileged = false;
            if (this.master.getConfig().getAdminPassword().length() > 0 && this.master.getConfig().getAdminPassword().equals(rq.getDetails().password)) {
                privileged = true;
            }
            faMan.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser || privileged, rq.getDetails().groupIds);
            MRCHelper.setSysAttrValue(sMan, vMan, faMan, res.getParentDirId(), file, attrKey.substring("xtreemfs.".length()), new String(attrVal), update);
        } else {
            boolean exists;
            boolean bl = exists = sMan.getXAttr(file.getId(), rq.getDetails().userId, attrKey) != null;
            if (exists && rqArgs.getFlags() == MRC.XATTR_FLAGS.XATTR_FLAGS_CREATE.getNumber()) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EEXIST, "attribute exists already");
            }
            if (!exists && rqArgs.getFlags() == MRC.XATTR_FLAGS.XATTR_FLAGS_REPLACE.getNumber()) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENODATA, "attribute does not exist");
            }
            sMan.setXAttr(file.getId(), rq.getDetails().userId, attrKey, attrVal.length == 0 ? null : attrVal, update);
        }
        int time = (int)(TimeSync.getGlobalTime() / 1000L);
        MRCHelper.updateFileTimes(res.getParentDirId(), file, false, true, false, sMan, time, update);
        rq.setResponse(Common.emptyResponse.getDefaultInstance());
        update.execute();
    }
}

