/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class SetattrOperation
extends MRCOperation {
    public SetattrOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.setattrRequest rqArgs = (MRC.setattrRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        res.checkIfFileDoesNotExist();
        FileMetadata file = res.getFile();
        int time = 0;
        boolean setMode = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_MODE.getNumber()) == MRC.Setattrs.SETATTR_MODE.getNumber();
        boolean setUID = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_UID.getNumber()) == MRC.Setattrs.SETATTR_UID.getNumber();
        boolean setGID = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_GID.getNumber()) == MRC.Setattrs.SETATTR_GID.getNumber();
        boolean setSize = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_SIZE.getNumber()) == MRC.Setattrs.SETATTR_SIZE.getNumber();
        boolean setAtime = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_ATIME.getNumber()) == MRC.Setattrs.SETATTR_ATIME.getNumber();
        boolean setCtime = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_CTIME.getNumber()) == MRC.Setattrs.SETATTR_CTIME.getNumber();
        boolean setMtime = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_MTIME.getNumber()) == MRC.Setattrs.SETATTR_MTIME.getNumber();
        boolean setAttributes = (rqArgs.getToSet() & MRC.Setattrs.SETATTR_ATTRIBUTES.getNumber()) == MRC.Setattrs.SETATTR_ATTRIBUTES.getNumber();
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        if (setMode) {
            faMan.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
            faMan.setPosixAccessMode(sMan, file, res.getParentDirId(), rq.getDetails().userId, rq.getDetails().groupIds, file.getPerms() & 0xFFFFF000 | rqArgs.getStbuf().getMode() & 0xFFF, rq.getDetails().superUser, update);
            if (time == 0) {
                time = (int)(TimeSync.getGlobalTime() / 1000L);
            }
            MRCHelper.updateFileTimes(res.getParentDirId(), file, false, true, false, sMan, time, update);
        }
        if (setUID || setGID) {
            if (setUID) {
                byte[] value = sMan.getXAttr(1L, "", "xtreemfs.volattr.chown_non_root");
                if (value != null && new String(value).equals("true")) {
                    faMan.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
                } else if (!rq.getDetails().superUser) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "changing owners is restricted to superusers");
                }
            }
            if (setGID) {
                faMan.checkPrivilegedPermissions(sMan, file, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
                if (!rq.getDetails().superUser && !rq.getDetails().groupIds.contains(rqArgs.getStbuf().getGroupId())) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "changing owning groups is restricted to superusers or file owners who are in the group that is supposed to be assigned");
                }
            }
            file.setOwnerAndGroup(setUID ? rqArgs.getStbuf().getUserId() : file.getOwnerId(), setGID ? rqArgs.getStbuf().getGroupId() : file.getOwningGroupId());
            if (time == 0) {
                time = (int)(TimeSync.getGlobalTime() / 1000L);
            }
            MRCHelper.updateFileTimes(res.getParentDirId(), file, false, true, false, sMan, time, update);
        }
        if (setSize) {
            long newFileSize = rqArgs.getStbuf().getSize();
            int epochNo = rqArgs.getStbuf().getTruncateEpoch();
            if (epochNo >= file.getEpoch()) {
                boolean epochChanged;
                boolean bl = epochChanged = epochNo > file.getEpoch();
                if (epochChanged || newFileSize > file.getSize()) {
                    long oldFileSize = file.getSize();
                    if (time == 0) {
                        time = (int)(TimeSync.getGlobalTime() / 1000L);
                    }
                    file.setSize(newFileSize);
                    file.setEpoch(epochNo);
                    file.setCtime(time);
                    file.setMtime(time);
                    if (epochChanged) {
                        sMan.setMetadata(file, (byte)1, update);
                    }
                    sMan.getVolumeInfo().updateVolumeSize(newFileSize - oldFileSize, update);
                } else if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.proc, this, "received update for outdated file size: " + newFileSize + ", current file size=" + file.getSize(), new Object[0]);
                }
            } else if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "received file size update w/ outdated epoch: " + epochNo + ", current epoch=" + file.getEpoch(), new Object[0]);
            }
        }
        if (setAtime || setCtime || setMtime) {
            if (setAtime) {
                file.setAtime((int)(rqArgs.getStbuf().getAtimeNs() / 1000000000L));
            }
            if (setCtime) {
                file.setCtime((int)(rqArgs.getStbuf().getCtimeNs() / 1000000000L));
            }
            if (setMtime) {
                file.setMtime((int)(rqArgs.getStbuf().getMtimeNs() / 1000000000L));
            }
        }
        if (setAttributes) {
            faMan.checkPermission("w", sMan, file, res.getParentDirId(), rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
            file.setW32Attrs(rqArgs.getStbuf().getAttributes());
        }
        if (setUID || setGID || setAttributes) {
            sMan.setMetadata(file, (byte)1, update);
        }
        if (setAtime || setCtime || setMtime || setSize) {
            sMan.setMetadata(file, (byte)0, update);
        }
        rq.setResponse(MRC.timestampResponse.newBuilder().setTimestampS(time).build());
        update.execute();
    }
}

