/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class StatFSOperation
extends MRCOperation {
    public StatFSOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.statvfsRequest rqArgs = (MRC.statvfsRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        StorageManager sMan = vMan.getStorageManagerByName(rqArgs.getVolumeName());
        MRC.StatVFS volumeInfo = StatFSOperation.getVolumeInfo(this.master, sMan);
        rq.setResponse(volumeInfo);
        this.finishRequest(rq);
    }

    protected static MRC.StatVFS getVolumeInfo(MRCRequestDispatcher master, StorageManager sMan) throws DatabaseException {
        VolumeInfo volume = sMan.getVolumeInfo();
        FileMetadata volumeRoot = sMan.getMetadata(1L);
        int blockSize = sMan.getDefaultStripingPolicy(1L).getStripeSize() * 1024;
        long availSpace = master.getOSDStatusManager().getUsableSpace(volume.getId());
        long freeSpace = master.getOSDStatusManager().getFreeSpace(volume.getId());
        long totalSpace = master.getOSDStatusManager().getTotalSpace(volume.getId());
        long quota = sMan.getVolumeQuota();
        if (quota != 0L) {
            long quotaFreeSpace = quota - sMan.getVolumeInfo().getVolumeSize();
            quotaFreeSpace = quotaFreeSpace < 0L ? 0L : quotaFreeSpace;
            freeSpace = freeSpace < quotaFreeSpace ? freeSpace : quotaFreeSpace;
            availSpace = availSpace < quotaFreeSpace ? availSpace : quotaFreeSpace;
        }
        long bavail = availSpace / (long)blockSize;
        long bfree = freeSpace / (long)blockSize;
        long blocks = totalSpace / (long)blockSize;
        String volumeId = volume.getId();
        GlobalTypes.AccessControlPolicyType acPolId = GlobalTypes.AccessControlPolicyType.valueOf(volume.getAcPolicyId());
        GlobalTypes.StripingPolicy.Builder defaultStripingPolicy = Converter.stripingPolicyToStripingPolicy(sMan.getDefaultStripingPolicy(1L));
        String volumeName = volume.getName();
        String owningGroupId = volumeRoot.getOwningGroupId();
        String ownerId = volumeRoot.getOwnerId();
        int perms = volumeRoot.getPerms();
        long newEtag = (long)blockSize + bavail + blocks;
        return MRC.StatVFS.newBuilder().setBsize(blockSize).setBfree(bfree).setBavail(bavail).setBlocks(blocks).setFsid(volumeId).setNamemax(1024).setOwnerUserId(ownerId).setOwnerGroupId(owningGroupId).setName(volumeName).setEtag(newEtag).setMode(perms).setAccessControlPolicy(acPolId).setDefaultStripingPolicy(defaultStripingPolicy).build();
    }
}

