/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.Path;
import org.xtreemfs.mrc.utils.PathResolver;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class StatOperation
extends MRCOperation {
    public StatOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        MRC.getattrRequest rqArgs = (MRC.getattrRequest)rq.getRequestArgs();
        VolumeManager vMan = this.master.getVolumeManager();
        FileAccessManager faMan = this.master.getFileAccessManager();
        this.validateContext(rq);
        Path p = new Path(rqArgs.getVolumeName(), rqArgs.getPath());
        StorageManager sMan = vMan.getStorageManagerByName(p.getComp(0));
        PathResolver res = new PathResolver(sMan, p);
        VolumeInfo volume = sMan.getVolumeInfo();
        faMan.checkSearchPermission(sMan, res, rq.getDetails().userId, rq.getDetails().superUser, rq.getDetails().groupIds);
        res.checkIfFileDoesNotExist();
        FileMetadata file = res.getFile();
        long knownEtag = rqArgs.getKnownEtag();
        long newEtag = file.getCtime() + file.getMtime();
        MRC.getattrResponse.Builder stat = MRC.getattrResponse.newBuilder();
        if (knownEtag != newEtag) {
            XLocList xlocList;
            String linkTarget = sMan.getSoftlinkTarget(file.getId());
            int mode = faMan.getPosixAccessMode(sMan, file, rq.getDetails().userId, rq.getDetails().groupIds);
            mode |= linkTarget != null ? GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFLNK.getNumber() : (file.isDirectory() ? GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFDIR.getNumber() : ((file.getPerms() & GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFIFO.getNumber()) != 0 ? GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFIFO.getNumber() : GlobalTypes.SYSTEM_V_FCNTL.SYSTEM_V_FCNTL_H_S_IFREG.getNumber()));
            long size = linkTarget != null ? (long)linkTarget.length() : (file.isDirectory() ? 0L : file.getSize());
            int blkSize = 0;
            if (linkTarget == null && !file.isDirectory() && (xlocList = file.getXLocList()) != null && xlocList.getReplicaCount() > 0) {
                blkSize = xlocList.getReplica(0).getStripingPolicy().getStripeSize() * 1024;
            }
            stat.setStbuf(MRC.Stat.newBuilder().setDev(volume.getId().hashCode()).setIno(file.getId()).setMode(mode).setNlink(file.getLinkCount()).setUserId(file.getOwnerId()).setGroupId(file.getOwningGroupId()).setSize(size).setAtimeNs((long)file.getAtime() * 1000000000L).setCtimeNs((long)file.getCtime() * 1000000000L).setMtimeNs((long)file.getMtime() * 1000000000L).setBlksize(blkSize).setTruncateEpoch(file.isDirectory() ? 0 : file.getEpoch()).setAttributes((int)file.getW32Attrs()).setEtag(newEtag));
        }
        rq.setResponse(stat.build());
        this.finishRequest(rq);
    }
}

