/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.net.InetSocketAddress;
import org.xtreemfs.common.Capability;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class TruncateOperation
extends MRCOperation {
    public TruncateOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        GlobalTypes.XCap xcap = (GlobalTypes.XCap)rq.getRequestArgs();
        Capability writeCap = new Capability(xcap, this.master.getConfig().getCapabilitySecret());
        if (!writeCap.hasValidSignature()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, writeCap + " does not have a valid signature");
        }
        if (writeCap.hasExpired()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, writeCap + " has expired");
        }
        if ((writeCap.getAccessMode() & (FileAccessManager.O_WRONLY | FileAccessManager.O_RDWR | FileAccessManager.O_TRUNC)) == 0) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EACCES, writeCap + " is not a write capability");
        }
        MRCHelper.GlobalFileIdResolver idRes = new MRCHelper.GlobalFileIdResolver(writeCap.getFileId());
        StorageManager sMan = this.master.getVolumeManager().getStorageManager(idRes.getVolumeId());
        FileMetadata file = sMan.getMetadata(idRes.getLocalFileId());
        if (file == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + writeCap.getFileId() + "' does not exist");
        }
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        int newEpoch = file.getIssuedEpoch() + 1;
        file.setIssuedEpoch(newEpoch);
        sMan.setMetadata(file, (byte)1, update);
        Capability truncCap = new Capability(writeCap.getFileId(), writeCap.getAccessMode() | FileAccessManager.O_TRUNC, this.master.getConfig().getCapabilityTimeout(), TimeSync.getGlobalTime() / 1000L + (long)this.master.getConfig().getCapabilityTimeout(), ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress().getHostAddress(), newEpoch, writeCap.isReplicateOnClose(), !sMan.getVolumeInfo().isSnapshotsEnabled() ? GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED : (sMan.getVolumeInfo().isSnapVolume() ? GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_SNAP : GlobalTypes.SnapConfig.SNAP_CONFIG_ACCESS_CURRENT), sMan.getVolumeInfo().getCreationTime(), this.master.getConfig().getCapabilitySecret());
        rq.setResponse(truncCap.getXCap());
        update.execute();
    }
}

