/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.operations;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.xloc.ReplicationFlags;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.ReplicationPolicy;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.mrc.utils.MRCHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;

public class UpdateFileSizeOperation
extends MRCOperation {
    public UpdateFileSizeOperation(MRCRequestDispatcher master) {
        super(master);
    }

    @Override
    public void startRequest(MRCRequest rq) throws Throwable {
        if (this.master.getReplMasterUUID() != null && !this.master.getReplMasterUUID().equals(this.master.getConfig().getUUID().toString())) {
            throw new DatabaseException(DatabaseException.ExceptionType.REDIRECT);
        }
        MRC.xtreemfs_update_file_sizeRequest rqArgs = (MRC.xtreemfs_update_file_sizeRequest)rq.getRequestArgs();
        Capability cap = new Capability(rqArgs.getXcap(), this.master.getConfig().getCapabilitySecret());
        if (!cap.hasValidSignature()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, cap + " does not have a valid signature");
        }
        if (cap.hasExpired()) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, cap + " has expired");
        }
        MRCHelper.GlobalFileIdResolver idRes = new MRCHelper.GlobalFileIdResolver(cap.getFileId());
        StorageManager sMan = this.master.getVolumeManager().getStorageManager(idRes.getVolumeId());
        FileMetadata file = sMan.getMetadata(idRes.getLocalFileId());
        if (file == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file '" + cap.getFileId() + "' does not exist");
        }
        AtomicDBUpdate update = sMan.createAtomicDBUpdate(this.master, rq);
        if (rqArgs.getOsdWriteResponse().hasSizeInBytes()) {
            if (file.isReadOnly()) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "file '" + cap.getFileId() + "' is read-only");
            }
            if (!rqArgs.getOsdWriteResponse().hasTruncateEpoch()) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "missing truncate epoch in OSDWriteResponse");
            }
            long newFileSize = rqArgs.getOsdWriteResponse().getSizeInBytes();
            int epochNo = rqArgs.getOsdWriteResponse().getTruncateEpoch();
            if (epochNo >= file.getEpoch()) {
                boolean epochChanged;
                boolean bl = epochChanged = epochNo > file.getEpoch();
                if (epochChanged || newFileSize > file.getSize()) {
                    long oldFileSize = file.getSize();
                    int time = (int)(TimeSync.getGlobalTime() / 1000L);
                    file.setSize(newFileSize);
                    file.setEpoch(epochNo);
                    file.setCtime(time);
                    file.setMtime(time);
                    sMan.setMetadata(file, (byte)0, update);
                    if (epochChanged) {
                        sMan.setMetadata(file, (byte)1, update);
                    }
                    sMan.getVolumeInfo().updateVolumeSize(newFileSize - oldFileSize, update);
                } else if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.proc, this, "received update for outdated file size: " + newFileSize + ", current file size=" + file.getSize(), new Object[0]);
                }
            } else if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "received file size update w/ outdated epoch: " + epochNo + ", current epoch=" + file.getEpoch(), new Object[0]);
            }
        }
        if (rqArgs.getCloseFile() && cap.getXCap().getReplicateOnClose()) {
            int requiredReplicaCount;
            VolumeInfo vol = sMan.getVolumeInfo();
            file.setReadOnly(true);
            Logging.logMessage(7, Logging.Category.proc, this, "file closed and set to readOnly", new Object[0]);
            Logging.logMessage(7, Logging.Category.replication, this, "replicating file", new Object[0]);
            XLocList xLocList = file.getXLocList();
            ReplicationPolicy defaultReplPolicy = sMan.getDefaultReplicationPolicy(file.getId());
            if (defaultReplPolicy == null) {
                defaultReplPolicy = sMan.getDefaultReplicationPolicy(1L);
            }
            if (defaultReplPolicy == null) {
                Logging.logMessage(4, (Object)Logging.Category.replication, "replicate on close enabled w/o default replication policy", new Object[0]);
                requiredReplicaCount = 1;
            } else {
                requiredReplicaCount = defaultReplPolicy.getFactor();
            }
            if (requiredReplicaCount > xLocList.getReplicaCount()) {
                assert (defaultReplPolicy != null);
                ArrayList<XLoc> repls = new ArrayList<XLoc>();
                for (int i = 0; i < xLocList.getReplicaCount(); ++i) {
                    repls.add(xLocList.getReplica(i));
                }
                int newVer = xLocList.getVersion() + 1;
                int initialReplCount = xLocList.getReplicaCount();
                XLoc firstRepl = (XLoc)repls.get(0);
                firstRepl.setReplicationFlags(ReplicationFlags.setFullReplica(ReplicationFlags.setReplicaIsComplete(firstRepl.getReplicationFlags())));
                try {
                    for (int i = 0; i < requiredReplicaCount - initialReplCount; ++i) {
                        XLoc newRepl = MRCHelper.createReplica(firstRepl.getStripingPolicy(), sMan, this.master.getOSDStatusManager(), vol, -1L, cap.getFileId(), ((InetSocketAddress)rq.getRPCRequest().getSenderAddress()).getAddress(), rqArgs.getCoordinates(), xLocList, defaultReplPolicy.getFlags());
                        String[] osds = new String[newRepl.getOSDCount()];
                        for (int j = 0; j < osds.length; ++j) {
                            osds[j] = newRepl.getOSD(j);
                        }
                        repls.add(sMan.createXLoc(firstRepl.getStripingPolicy(), osds, newRepl.getReplicationFlags()));
                        xLocList = sMan.createXLocList(repls.toArray(new XLoc[repls.size()]), "ronly", newVer);
                    }
                }
                catch (Exception exc) {
                    Logging.logMessage(4, Logging.Category.replication, this, "could not replicate file '%d' on close", file.getId());
                    Logging.logMessage(4, Logging.Category.replication, this, OutputUtils.stackTraceToString(exc), new Object[0]);
                }
                file.setXLocList(xLocList);
            }
            sMan.setMetadata(file, (byte)1, update);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "added %d replicas", requiredReplicaCount - xLocList.getReplicaCount());
            }
            if (file.getSize() > 0L && ReplicationFlags.isFullReplica(defaultReplPolicy.getFlags())) {
                GlobalTypes.XLocSet.Builder xLocSet = Converter.xLocListToXLocSet(xLocList);
                xLocSet.setReadOnlyFileSize(file.getSize());
                rq.getDetails().context = new HashMap<String, Object>();
                rq.getDetails().context.put("xLocList", xLocSet.build());
                this.master.getOnCloseReplicationThread().enqueueRequest(rq);
            }
        }
        rq.setResponse(Common.emptyResponse.getDefaultInstance());
        update.execute();
    }
}

