/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Properties;
import org.xtreemfs.foundation.LRUCache;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.osdselection.Inet4AddressMatcher;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;

public abstract class DCMapPolicyBase
implements OSDSelectionPolicy {
    public static final String CONFIG_FILE_PATH = "/etc/xos/xtreemfs/datacentermap";
    protected int[][] distMap;
    protected Inet4AddressMatcher[][] matchers;
    protected LRUCache<Inet4Address, Integer> matchingDCcache;
    private boolean initialized;

    public DCMapPolicyBase() {
        try {
            File f = new File(CONFIG_FILE_PATH);
            Properties p = new Properties();
            p.load(new FileInputStream(f));
            this.readConfig(p);
            int maxCacheSize = Integer.valueOf(p.getProperty("max_cache_size", "1000").trim());
            this.matchingDCcache = new LRUCache(maxCacheSize);
            this.initialized = true;
        }
        catch (IOException ex) {
            Logging.logMessage(4, Logging.Category.misc, this, "cannot load %s, DCMap replica selection policy will not work", CONFIG_FILE_PATH);
            Logging.logError(4, this, ex);
            this.initialized = false;
        }
    }

    public DCMapPolicyBase(Properties p) {
        this.readConfig(p);
        int maxCacheSize = Integer.valueOf(p.getProperty("max_cache_size", "1000"));
        this.matchingDCcache = new LRUCache(maxCacheSize);
        this.initialized = true;
    }

    private void readConfig(Properties p) {
        int i;
        String tmp = p.getProperty("datacenters");
        if (tmp == null) {
            throw new IllegalArgumentException("Cannot initialize " + this.getClass().getSimpleName() + ": a list of datacenters must be specified in the configuration");
        }
        String[] dcs = tmp.split(",");
        if (dcs.length == 0) {
            Logging.logMessage(4, this, "no datacenters specified", new Object[0]);
            return;
        }
        for (i = 0; i < dcs.length; ++i) {
            if (dcs[i].matches("[a-zA-Z0-9_]+")) continue;
            throw new IllegalArgumentException("Cannot initialize " + this.getClass().getSimpleName() + ": datacenter name '" + dcs[i] + "' is invalid");
        }
        this.distMap = new int[dcs.length][dcs.length];
        this.matchers = new Inet4AddressMatcher[dcs.length][];
        for (i = 0; i < dcs.length; ++i) {
            for (int j = i + 1; j < dcs.length; ++j) {
                String distStr = p.getProperty("distance." + dcs[i] + "-" + dcs[j]);
                if (distStr == null) {
                    distStr = p.getProperty("distance." + dcs[j] + "-" + dcs[i]);
                }
                if (distStr == null) {
                    throw new IllegalArgumentException("Cannot initialize " + this.getClass().getSimpleName() + ": distance between datacenter '" + dcs[i] + "' and '" + dcs[j] + "' is not specified");
                }
                try {
                    int n = Integer.valueOf(distStr);
                    this.distMap[j][i] = n;
                    this.distMap[i][j] = n;
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Cannot initialize " + this.getClass().getSimpleName() + ": distance '" + distStr + "' between datacenter '" + dcs[i] + "' and '" + dcs[j] + "' is not a valid integer");
                }
            }
            String dcMatch = p.getProperty("addresses." + dcs[i]);
            if (dcMatch == null) {
                dcMatch = p.getProperty(dcs[i] + ".addresses");
            }
            if (dcMatch == null) {
                this.matchers[i] = new Inet4AddressMatcher[0];
                Logging.logMessage(4, this, "datacenter '" + dcs[i] + "' has no entries!", new Object[0]);
                continue;
            }
            String[] entries = dcMatch.split(",");
            this.matchers[i] = new Inet4AddressMatcher[entries.length];
            for (int e = 0; e < entries.length; ++e) {
                String entry = entries[e];
                if (entry.contains("/")) {
                    try {
                        String ipAddr = entry.substring(0, entry.indexOf("/"));
                        String prefix = entry.substring(entry.indexOf("/") + 1);
                        Inet4Address ia = (Inet4Address)InetAddress.getByName(ipAddr);
                        this.matchers[i][e] = new Inet4AddressMatcher(ia, Integer.valueOf(prefix));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Cannot initialize " + this.getClass().getSimpleName() + ": netmask in '" + entry + "' for datacenter '" + dcs[i] + "' is not a valid integer");
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("Cannot initialize " + this.getClass().getSimpleName() + ": address '" + entry + "' for datacenter '" + dcs[i] + "' is not a valid IPv4 address");
                    }
                }
                try {
                    Inet4Address ia = (Inet4Address)InetAddress.getByName(entry);
                    this.matchers[i][e] = new Inet4AddressMatcher(ia);
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Cannot initialize " + this.getClass().getSimpleName() + ": address '" + entry + "' for datacenter '" + dcs[i] + "' is not a valid IPv4 address");
                }
            }
        }
    }

    protected int getDistance(Inet4Address addr1, Inet4Address addr2) {
        if (!this.initialized) {
            return 0;
        }
        int dc1 = this.getMatchingDC(addr1);
        int dc2 = this.getMatchingDC(addr2);
        if (dc1 != -1 && dc2 != -1) {
            return this.distMap[dc1][dc2];
        }
        return Integer.MAX_VALUE;
    }

    protected int getMatchingDC(Inet4Address addr) {
        if (!this.initialized) {
            return -1;
        }
        Integer cached = (Integer)this.matchingDCcache.get(addr);
        if (cached == null) {
            for (int i = 0; i < this.matchers.length; ++i) {
                for (int j = 0; j < this.matchers[i].length; ++j) {
                    if (!this.matchers[i][j].matches(addr)) continue;
                    this.matchingDCcache.put(addr, i);
                    return i;
                }
            }
            this.matchingDCcache.put(addr, -1);
            return -1;
        }
        return cached;
    }
}

