/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.util.ArrayList;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;

public abstract class FQDNPolicyBase
implements OSDSelectionPolicy {
    protected int getMatch(String dn1, String dn2) {
        String[] array1 = FQDNPolicyBase.tokenizeAndReverseDN(dn1);
        String[] array2 = FQDNPolicyBase.tokenizeAndReverseDN(dn2);
        int len = Math.min(array1.length, array2.length);
        int match = 0;
        for (int i = 0; i < len && array1[i].equals(array2[i]); ++i) {
            ++match;
        }
        return match;
    }

    private static String[] tokenizeAndReverseDN(String dn) {
        ArrayList<Integer> dots = new ArrayList<Integer>();
        for (int i = 0; i < dn.length(); ++i) {
            if (dn.charAt(i) != '.') continue;
            dots.add(i);
        }
        String[] array = new String[dots.size() + 1];
        for (int i = 0; i < array.length; ++i) {
            int currDot = i >= dots.size() ? dn.length() : ((Integer)dots.get(i)).intValue();
            int prevDot = i == 0 ? -1 : (Integer)dots.get(i - 1);
            array[array.length - i - 1] = dn.substring(prevDot + 1, currDot);
        }
        return array;
    }
}

