/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;
import org.xtreemfs.mrc.osdselection.PolicyHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class FilterDefaultPolicy
implements OSDSelectionPolicy {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_FILTER_DEFAULT.getNumber();
    private static final String OFFLINE_TIME_SECS = "offline_time_secs";
    private static final String FREE_CAPACITY_BYTES = "free_capacity_bytes";
    private static final String OSD_HEALTH_CHECK = "osd_health_check";
    private static final String NOT_IN = "not.";
    private long minFreeCapacity = Integer.MIN_VALUE;
    private long maxOfflineTime = 300L;
    private OSD.OSDHealthResult osdHealthCheck = OSD.OSDHealthResult.OSD_HEALTH_RESULT_WARNING;
    private HashMap<String, String> customFilter = new HashMap();
    private HashMap<String, String> customNotFilter = new HashMap();

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        if (allOSDs == null) {
            return null;
        }
        DIR.ServiceSet.Builder osds = PolicyHelper.removeUsedOSDs(allOSDs, currentXLoc);
        return this.getOSDs(osds);
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        if (allOSDs == null) {
            return null;
        }
        DIR.ServiceSet.Builder filteredOSDs = DIR.ServiceSet.newBuilder();
        for (DIR.Service osd : allOSDs.getServicesList()) {
            if (this.hasTimedOut(osd) || !this.hasFreeCapacity(osd) || !this.isAvailable(osd) || !this.isHealthy(osd)) continue;
            if (this.customFilter.isEmpty()) {
                if (!this.customNotFilter.isEmpty() && FilterDefaultPolicy.checkMatch(this.customNotFilter, filteredOSDs, osd)) continue;
                filteredOSDs.addServices(osd);
                continue;
            }
            if (FilterDefaultPolicy.checkMatch(this.customNotFilter, filteredOSDs, osd) || !FilterDefaultPolicy.checkMatch(this.customFilter, filteredOSDs, osd)) continue;
            filteredOSDs.addServices(osd);
        }
        return filteredOSDs;
    }

    private static boolean checkMatch(Map<String, String> customFilter, DIR.ServiceSet.Builder filteredOSDs, DIR.Service osd) {
        for (Map.Entry<String, String> entry : customFilter.entrySet()) {
            String osdParameterValue = KeyValuePairs.getValue(osd.getData().getDataList(), "config." + entry.getKey());
            if (!FilterDefaultPolicy.matches(entry.getValue(), osdParameterValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (OFFLINE_TIME_SECS.equals(key)) {
            this.maxOfflineTime = Long.parseLong(value);
        } else if (FREE_CAPACITY_BYTES.equals(key)) {
            this.minFreeCapacity = Long.parseLong(value);
        } else if (OSD_HEALTH_CHECK.equals(key)) {
            if (value.toUpperCase().equals("WARNING")) {
                this.osdHealthCheck = OSD.OSDHealthResult.OSD_HEALTH_RESULT_WARNING;
            } else if (value.toUpperCase().equals("FAILED")) {
                this.osdHealthCheck = OSD.OSDHealthResult.OSD_HEALTH_RESULT_FAILED;
            }
        } else if (value == null) {
            if (key.toLowerCase().startsWith(NOT_IN)) {
                key = key.substring(NOT_IN.length(), key.length());
                this.customNotFilter.remove(key);
            } else {
                this.customFilter.remove(key);
            }
        } else if (key.toLowerCase().startsWith(NOT_IN)) {
            key = key.substring(NOT_IN.length(), key.length());
            this.customNotFilter.put(key, value);
        } else {
            this.customFilter.put(key, value);
        }
    }

    private boolean hasTimedOut(DIR.Service osd) {
        long lastUpdate = Long.parseLong(KeyValuePairs.getValue(osd.getData().getDataList(), "seconds_since_last_update"));
        return lastUpdate > this.maxOfflineTime;
    }

    private boolean hasFreeCapacity(DIR.Service osd) {
        String freeStr = KeyValuePairs.getValue(osd.getData().getDataList(), "free");
        if (freeStr == null) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, this, "invalid OSD registry (free is null!): %s", osd.toString());
            }
            return false;
        }
        long free = Long.parseLong(freeStr);
        return free > this.minFreeCapacity;
    }

    private boolean isAvailable(DIR.Service osd) {
        String osdStatus = KeyValuePairs.getValue(osd.getData().getDataList(), "static.status");
        if (osdStatus == null) {
            return true;
        }
        return Integer.valueOf(osdStatus).intValue() == DIR.ServiceStatus.SERVICE_STATUS_AVAIL.getNumber();
    }

    private boolean isHealthy(DIR.Service osd) {
        String smartTestResult = KeyValuePairs.getValue(osd.getData().getDataList(), OSD_HEALTH_CHECK);
        if (smartTestResult == null) {
            return true;
        }
        if (this.osdHealthCheck == OSD.OSDHealthResult.OSD_HEALTH_RESULT_WARNING) {
            return Integer.valueOf(smartTestResult) != 2 && Integer.valueOf(smartTestResult) != 1;
        }
        return Integer.valueOf(smartTestResult) != 2;
    }

    private static boolean matches(String filterString, String customProperty) {
        StringTokenizer st = new StringTokenizer(filterString);
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(customProperty)) continue;
            return true;
        }
        return false;
    }
}

