/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class FilterFQDNPolicy
implements OSDSelectionPolicy {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_FILTER_FQDN.getNumber();
    private static final String DOMAINS = "domains";
    private final List<String> domains = new LinkedList<String>();

    public FilterFQDNPolicy() {
        this.domains.add("*");
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        return this.getOSDs(allOSDs);
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        if (allOSDs == null) {
            return null;
        }
        DIR.ServiceSet.Builder filteredOSDs = DIR.ServiceSet.newBuilder();
        for (DIR.Service osd : allOSDs.getServicesList()) {
            if (!this.isInDomains(osd)) continue;
            filteredOSDs.addServices(osd);
        }
        return filteredOSDs;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (key.equals(DOMAINS)) {
            StringTokenizer st;
            this.domains.clear();
            if (value == null) {
                value = "";
            }
            if ((st = new StringTokenizer(value, " ,;\t\n")) != null) {
                while (st.hasMoreTokens()) {
                    this.domains.add(st.nextToken());
                }
            }
        }
    }

    private boolean isInDomains(DIR.Service osd) {
        try {
            ServiceUUID uuid = new ServiceUUID(osd.getUuid());
            String osdHostName = uuid.getAddress().getHostName();
            for (String domain : this.domains) {
                if (domain.endsWith("*") && osdHostName.startsWith(domain.substring(0, domain.length() - 1))) {
                    return true;
                }
                if (domain.startsWith("*") && osdHostName.endsWith(domain.substring(1, domain.length()))) {
                    return true;
                }
                if (!domain.equals(osdHostName)) continue;
                return true;
            }
            return false;
        }
        catch (UnknownUUIDException exc) {
            Logging.logMessage(3, Logging.Category.misc, this, "invalid OSD UUID", new Object[0]);
            Logging.logError(3, this, exc);
            return false;
        }
    }
}

