/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class FilterUUIDPolicy
implements OSDSelectionPolicy {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_FILTER_UUID.getNumber();
    private static final String UUIDS = "uuids";
    private List<String> uuids = new LinkedList<String>();

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        return this.getOSDs(allOSDs);
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        if (allOSDs == null) {
            return null;
        }
        DIR.ServiceSet.Builder filteredOSDs = DIR.ServiceSet.newBuilder();
        for (DIR.Service osd : allOSDs.getServicesList()) {
            if (!this.isInUUIDs(osd)) continue;
            filteredOSDs.addServices(osd);
        }
        return filteredOSDs;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (key.equals(UUIDS)) {
            this.uuids.clear();
            if (value != null) {
                StringTokenizer st = new StringTokenizer(value, " ,;\t\n");
                while (st.hasMoreTokens()) {
                    this.uuids.add(st.nextToken());
                }
            }
        }
    }

    private boolean isInUUIDs(DIR.Service osd) {
        String osdUUID = new ServiceUUID(osd.getUuid()).toString();
        if (this.uuids.size() == 0) {
            return true;
        }
        for (String uuid : this.uuids) {
            if (uuid.endsWith("*") && osdUUID.startsWith(uuid.substring(0, uuid.length() - 1))) {
                return true;
            }
            if (uuid.startsWith("*") && osdUUID.endsWith(uuid.substring(1, uuid.length()))) {
                return true;
            }
            if (!uuid.equals(osdUUID)) continue;
            return true;
        }
        return false;
    }
}

