/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.Properties;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.DCMapPolicyBase;
import org.xtreemfs.mrc.osdselection.PolicyHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class GroupDCMapPolicy
extends DCMapPolicyBase {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_GROUP_DCMAP.getNumber();

    public GroupDCMapPolicy() {
    }

    public GroupDCMapPolicy(Properties p) {
        super(p);
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        allOSDs = this.getOSDs(allOSDs);
        int currentDC = 0;
        int currentDCSize = 0;
        int currentIndex = 0;
        int bestClientDist = Integer.MAX_VALUE;
        int bestIndex = -1;
        for (int i = 0; i < allOSDs.getServicesCount(); ++i) {
            try {
                int cd;
                DIR.Service s = allOSDs.getServices(i);
                Inet4Address addr = (Inet4Address)new ServiceUUID(s.getUuid()).getAddress().getAddress();
                int dc = this.getMatchingDC(addr);
                if (dc == currentDC) {
                    if (++currentDCSize != numOSDs || (cd = this.getDistance(addr, (Inet4Address)clientIP)) >= bestClientDist) continue;
                    bestClientDist = cd;
                    bestIndex = currentIndex;
                    continue;
                }
                currentDCSize = 1;
                currentDC = dc;
                currentIndex = i;
                if (currentDCSize != numOSDs || (cd = this.getDistance(addr, (Inet4Address)clientIP)) >= bestClientDist) continue;
                bestClientDist = cd;
                bestIndex = currentIndex;
                continue;
            }
            catch (UnknownUUIDException exc) {
                Logging.logError(3, this, exc);
                break;
            }
        }
        DIR.ServiceSet.Builder result = DIR.ServiceSet.newBuilder();
        if (bestIndex != -1) {
            for (int i = 0; i < numOSDs; ++i) {
                result.addServices(allOSDs.getServices(bestIndex + i));
            }
        }
        return result;
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        if (allOSDs != null) {
            allOSDs = PolicyHelper.sortServiceSet(allOSDs, new Comparator<DIR.Service>(){

                @Override
                public int compare(DIR.Service o1, DIR.Service o2) {
                    try {
                        Inet4Address addr1 = (Inet4Address)new ServiceUUID(o1.getUuid()).getAddress().getAddress();
                        Inet4Address addr2 = (Inet4Address)new ServiceUUID(o2.getUuid()).getAddress().getAddress();
                        return GroupDCMapPolicy.this.getMatchingDC(addr1) - GroupDCMapPolicy.this.getMatchingDC(addr2);
                    }
                    catch (UnknownUUIDException exc) {
                        Logging.logError(3, this, exc);
                        return 0;
                    }
                }
            });
        }
        return allOSDs;
    }

    @Override
    public void setAttribute(String key, String value) {
    }
}

