/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.InetAddress;
import java.util.Comparator;
import org.xtreemfs.common.util.NetUtils;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.FQDNPolicyBase;
import org.xtreemfs.mrc.osdselection.PolicyHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class GroupFQDNPolicy
extends FQDNPolicyBase {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_GROUP_FQDN.getNumber();

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, final InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        if (allOSDs == null) {
            return null;
        }
        allOSDs = PolicyHelper.sortServiceSet(allOSDs, new Comparator<DIR.Service>(){

            @Override
            public int compare(DIR.Service o1, DIR.Service o2) {
                try {
                    String host1 = new ServiceUUID(o1.getUuid()).getAddress().getHostName();
                    String host2 = new ServiceUUID(o2.getUuid()).getAddress().getHostName();
                    return GroupFQDNPolicy.this.getMatch(host2, clientIP.getHostName()) - GroupFQDNPolicy.this.getMatch(host1, clientIP.getHostName());
                }
                catch (UnknownUUIDException exc) {
                    Logging.logError(3, this, exc);
                    return 0;
                }
            }
        });
        String currentDomain = "";
        int currentDomainSize = 0;
        int currentIndex = 0;
        int bestClientMatch = 0;
        int bestIndex = -1;
        for (int i = 0; i < allOSDs.getServicesCount(); ++i) {
            try {
                int cd;
                DIR.Service s = allOSDs.getServices(i);
                String hostName = new ServiceUUID(s.getUuid()).getAddress().getHostName();
                String domain = NetUtils.getDomain(hostName);
                if (domain.equals(currentDomain)) {
                    if (++currentDomainSize != numOSDs || (cd = this.getMatch(hostName, clientIP.getCanonicalHostName())) <= bestClientMatch) continue;
                    bestClientMatch = cd;
                    bestIndex = currentIndex;
                    continue;
                }
                currentDomainSize = 1;
                currentDomain = domain;
                currentIndex = i;
                if (currentDomainSize != numOSDs || (cd = this.getMatch(hostName, clientIP.getCanonicalHostName())) <= bestClientMatch) continue;
                bestClientMatch = cd;
                bestIndex = currentIndex;
                continue;
            }
            catch (UnknownUUIDException exc) {
                Logging.logError(3, this, exc);
                break;
            }
        }
        DIR.ServiceSet.Builder result = DIR.ServiceSet.newBuilder();
        if (bestIndex != -1) {
            for (int i = 0; i < numOSDs; ++i) {
                result.addServices(allOSDs.getServices(bestIndex + i));
            }
        }
        return result;
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        return allOSDs;
    }

    @Override
    public void setAttribute(String key, String value) {
    }
}

