/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.Inet4Address;
import java.net.InetAddress;
import org.xtreemfs.mrc.osdselection.InetAddressMatcher;

public class Inet4AddressMatcher
implements InetAddressMatcher {
    private final Inet4Address addr;
    private final int addrAsInt;
    private final int networkPrefixLen;
    private final int netmask;
    public static final int NETWORK_PREFIX_SINGLE_ADDR = 32;

    public Inet4AddressMatcher(Inet4Address addr) {
        this(addr, 32);
    }

    public Inet4AddressMatcher(Inet4Address addr, int networkPrefixLen) {
        this.networkPrefixLen = networkPrefixLen;
        this.addr = addr;
        this.addrAsInt = Inet4AddressMatcher.bytesToInt(addr.getAddress());
        this.netmask = -1 << 32 - networkPrefixLen & 0xFFFFFFFF;
    }

    @Override
    public boolean matches(InetAddress addr) {
        try {
            Inet4Address i4addr = (Inet4Address)addr;
            if (this.networkPrefixLen == 32) {
                return this.addr.equals(i4addr);
            }
            int otherAddrAsInt = Inet4AddressMatcher.bytesToInt(i4addr.getAddress());
            return (this.addrAsInt & this.netmask) == (otherAddrAsInt & this.netmask);
        }
        catch (ClassCastException ex) {
            return false;
        }
    }

    private static int bytesToInt(byte[] arr) {
        int tmp = arr[3] & 0xFF;
        tmp += (arr[2] & 0xFF) << 8;
        tmp += (arr[1] & 0xFF) << 16;
        return tmp += (arr[0] & 0xFF) << 24;
    }
}

