/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.VolumeChangeListener;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.VolumeOSDFilter;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class OSDStatusManager
extends LifeCycleThread
implements VolumeChangeListener {
    private int checkIntervalMillis = 5000;
    private final Map<String, VolumeOSDFilter> volumeMap;
    private DIR.ServiceSet.Builder knownOSDs;
    private final Map<String, DIR.Service> knownOSDMap;
    private boolean quit = false;
    private final MRCRequestDispatcher master;

    public OSDStatusManager(MRCRequestDispatcher master) throws IOException {
        super("OSDStatusManager");
        this.master = master;
        this.volumeMap = new HashMap<String, VolumeOSDFilter>();
        this.knownOSDs = DIR.ServiceSet.newBuilder();
        this.knownOSDMap = new HashMap<String, DIR.Service>();
        int interval = master.getConfig().getOsdCheckInterval();
        this.checkIntervalMillis = 1000 * interval;
    }

    @Override
    public synchronized void volumeChanged(VolumeInfo volume) {
        String volId = volume.getId();
        VolumeOSDFilter vol = this.volumeMap.get(volId);
        if (vol == null) {
            vol = new VolumeOSDFilter(this.master, this.knownOSDMap);
            this.volumeMap.put(volId, vol);
        }
        try {
            vol.init(volume);
        }
        catch (DatabaseException e) {
            Logging.logError(3, this, e);
        }
        this.notifyAll();
    }

    @Override
    public synchronized void volumeDeleted(String volumeId) {
        this.volumeMap.remove(volumeId);
    }

    @Override
    public synchronized void attributeSet(String volumeId, String key, String value) {
        VolumeOSDFilter vol = this.volumeMap.get(volumeId);
        if (vol == null) {
            Logging.logError(3, this, new Exception("no volume OSD filter found for volume " + volumeId));
            return;
        }
        vol.setAttribute(key, value);
    }

    @Override
    public synchronized void shutdown() {
        this.quit = true;
        this.interrupt();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.knownOSDs = this.master.getDirClient().xtreemfs_service_get_by_type(null, RPCAuthentication.authNone, RPCAuthentication.userService, DIR.ServiceType.SERVICE_TYPE_OSD).toBuilder();
        }
        catch (Throwable exc) {
            this.notifyCrashed(exc);
        }
        this.notifyStarted();
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.lifecycle, this, "OSD status manager operational, using DIR %s", this.master.getConfig().getDirectoryService().toString());
        }
        while (!this.quit) {
            OSDStatusManager exc = this;
            synchronized (exc) {
                try {
                    this.wait(this.knownOSDs == null || this.knownOSDs.getServicesCount() == 0 ? (long)(this.checkIntervalMillis / 2) : (long)this.checkIntervalMillis);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            Logging.logMessage(7, Logging.Category.misc, this, "sending request for OSD list to DIR...", new Object[0]);
            try {
                this.knownOSDs = this.master.getDirClient().xtreemfs_service_get_by_type(null, RPCAuthentication.authNone, RPCAuthentication.userService, DIR.ServiceType.SERVICE_TYPE_OSD).toBuilder();
                Logging.logMessage(7, Logging.Category.misc, this, "... received OSD list from DIR", new Object[0]);
                this.evaluateResponse(this.knownOSDs);
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (Exception exc2) {
                if (this.quit) continue;
                Logging.logMessage(3, Logging.Category.misc, this, OutputUtils.stackTraceToString(exc2), new Object[0]);
            }
        }
        this.notifyStopped();
    }

    public synchronized DIR.ServiceSet.Builder getUsableOSDs(String volumeId, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        VolumeOSDFilter vol = this.volumeMap.get(volumeId);
        if (vol == null) {
            Logging.logMessage(4, Logging.Category.misc, this, "no volume registered at OSDStatusManager with ID '%s'", volumeId);
            return null;
        }
        DIR.ServiceSet.Builder result = vol.filterByOSDSelectionPolicy(this.knownOSDs, clientIP, clientCoords, currentXLoc, numOSDs);
        return result;
    }

    public synchronized DIR.ServiceSet.Builder getUsableOSDs(String volumeId) {
        VolumeOSDFilter vol = this.volumeMap.get(volumeId);
        if (vol == null) {
            Logging.logMessage(4, Logging.Category.misc, this, "no volume registered at OSDStatusManager with ID '%s'", volumeId);
            return null;
        }
        return vol.filterByOSDSelectionPolicy(this.knownOSDs);
    }

    public synchronized GlobalTypes.Replicas getSortedReplicaList(String volumeId, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, List<GlobalTypes.Replica> repls, XLocList xLocList) {
        VolumeOSDFilter vol = this.volumeMap.get(volumeId);
        if (vol == null) {
            Logging.logMessage(4, Logging.Category.misc, this, "no volume registered at OSDStatusManager with ID '%s'", volumeId);
            return null;
        }
        return vol.sortByReplicaSelectionPolicy(clientIP, clientCoords, repls, xLocList);
    }

    public synchronized void evaluateResponse(DIR.ServiceSet.Builder knownOSDs) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "response...", new Object[0]);
        }
        assert (knownOSDs != null);
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.misc, this, "registered OSDs", new Object[0]);
        }
        if (knownOSDs.getServicesCount() == 0) {
            Logging.logMessage(4, Logging.Category.misc, this, "there are currently no OSDs available", new Object[0]);
        }
        if (Logging.isDebug()) {
            for (DIR.Service osd : knownOSDs.getServicesList()) {
                Logging.logMessage(7, Logging.Category.misc, this, "%s", osd.getUuid());
            }
        }
        this.knownOSDs = knownOSDs;
        this.knownOSDMap.clear();
        for (DIR.Service osd : knownOSDs.getServicesList()) {
            this.knownOSDMap.put(osd.getUuid(), osd);
        }
    }

    public synchronized DIR.Service getOSDService(String uuid) {
        return this.knownOSDMap.get(uuid);
    }

    public long getFreeSpace(String volumeId) {
        long free = 0L;
        DIR.ServiceSet.Builder usableOSDs = this.getUsableOSDs(volumeId);
        if (usableOSDs == null) {
            return 0L;
        }
        for (DIR.Service entry : usableOSDs.getServicesList()) {
            String freeStr = KeyValuePairs.getValue(entry.getData().getDataList(), "free");
            if (freeStr == null) continue;
            free += Long.valueOf(freeStr).longValue();
        }
        return free;
    }

    public long getUsableSpace(String volumeId) {
        long usable = 0L;
        DIR.ServiceSet.Builder usableOSDs = this.getUsableOSDs(volumeId);
        if (usableOSDs == null) {
            return 0L;
        }
        for (DIR.Service entry : usableOSDs.getServicesList()) {
            String usableStr = KeyValuePairs.getValue(entry.getData().getDataList(), "usable");
            if (usableStr == null) continue;
            usable += Long.valueOf(usableStr).longValue();
        }
        return usable;
    }

    public long getTotalSpace(String volumeId) {
        long total = 0L;
        DIR.ServiceSet.Builder usableOSDs = this.getUsableOSDs(volumeId);
        if (usableOSDs == null) {
            return 0L;
        }
        for (DIR.Service entry : usableOSDs.getServicesList()) {
            String totalStr = KeyValuePairs.getValue(entry.getData().getDataList(), "total");
            if (totalStr == null) continue;
            total += Long.valueOf(totalStr).longValue();
        }
        return total;
    }
}

