/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class PolicyHelper {
    public static DIR.ServiceSet.Builder removeUsedOSDs(DIR.ServiceSet.Builder allOSDs, XLocList xLocList) {
        if (xLocList == null) {
            return allOSDs;
        }
        HashSet<DIR.Service> newOSDs = new HashSet<DIR.Service>(allOSDs.getServicesList());
        for (int i = 0; i < xLocList.getReplicaCount(); ++i) {
            XLoc currentRepl = xLocList.getReplica(i);
            for (int j = 0; j < currentRepl.getOSDCount(); ++j) {
                for (DIR.Service osd : allOSDs.getServicesList()) {
                    if (!currentRepl.getOSD(j).equals(osd.getUuid())) continue;
                    newOSDs.remove(osd);
                }
            }
        }
        return DIR.ServiceSet.newBuilder().addAllServices(newOSDs);
    }

    public static DIR.ServiceSet.Builder sortServiceSet(DIR.ServiceSet.Builder set, Comparator<DIR.Service> comp) {
        List<DIR.Service> immutableList = set.getServicesList();
        ArrayList<DIR.Service> list = new ArrayList<DIR.Service>(immutableList);
        Collections.sort(list, comp);
        return DIR.ServiceSet.newBuilder().addAllServices(list);
    }

    public static DIR.ServiceSet.Builder shuffleServiceSet(DIR.ServiceSet.Builder set) {
        List<DIR.Service> immutableList = set.getServicesList();
        ArrayList<DIR.Service> list = new ArrayList<DIR.Service>(immutableList);
        Collections.shuffle(list);
        return DIR.ServiceSet.newBuilder().addAllServices(list);
    }

    public static DIR.ServiceSet.Builder reverseServiceSet(DIR.ServiceSet.Builder set) {
        List<DIR.Service> immutableList = set.getServicesList();
        ArrayList<DIR.Service> list = new ArrayList<DIR.Service>(immutableList);
        Collections.reverse(list);
        return DIR.ServiceSet.newBuilder().addAllServices(list);
    }
}

