/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.Properties;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.DCMapPolicyBase;
import org.xtreemfs.mrc.osdselection.PolicyHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class SortDCMapPolicy
extends DCMapPolicyBase {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_SORT_DCMAP.getNumber();

    public SortDCMapPolicy() {
    }

    public SortDCMapPolicy(Properties p) {
        super(p);
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        final Inet4Address cAddr = (Inet4Address)clientIP;
        if (allOSDs != null) {
            allOSDs = PolicyHelper.sortServiceSet(allOSDs, new Comparator<DIR.Service>(){

                @Override
                public int compare(DIR.Service o1, DIR.Service o2) {
                    try {
                        ServiceUUID uuid1 = new ServiceUUID(o1.getUuid());
                        ServiceUUID uuid2 = new ServiceUUID(o2.getUuid());
                        Inet4Address osdAddr1 = (Inet4Address)uuid1.getAddress().getAddress();
                        Inet4Address osdAddr2 = (Inet4Address)uuid2.getAddress().getAddress();
                        return SortDCMapPolicy.this.getDistance(osdAddr1, cAddr) - SortDCMapPolicy.this.getDistance(osdAddr2, cAddr);
                    }
                    catch (UnknownUUIDException e) {
                        Logging.logMessage(4, Logging.Category.misc, this, "cannot compare UUIDs", new Object[0]);
                        Logging.logMessage(4, this, OutputUtils.stackTraceToString(e), new Object[0]);
                        return 0;
                    }
                }
            });
        }
        return allOSDs;
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        return allOSDs;
    }

    @Override
    public void setAttribute(String key, String value) {
    }
}

