/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.InetAddress;
import java.util.Comparator;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.FQDNPolicyBase;
import org.xtreemfs.mrc.osdselection.PolicyHelper;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class SortFQDNPolicy
extends FQDNPolicyBase {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_SORT_FQDN.getNumber();

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, final InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        if (allOSDs == null) {
            return null;
        }
        allOSDs = PolicyHelper.sortServiceSet(allOSDs, new Comparator<DIR.Service>(){

            @Override
            public int compare(DIR.Service o1, DIR.Service o2) {
                try {
                    return SortFQDNPolicy.this.getMatch(new ServiceUUID(o2.getUuid()).getAddress().getHostName(), clientIP.getCanonicalHostName()) - SortFQDNPolicy.this.getMatch(new ServiceUUID(o1.getUuid()).getAddress().getHostName(), clientIP.getCanonicalHostName());
                }
                catch (UnknownUUIDException e) {
                    Logging.logMessage(4, Logging.Category.misc, this, "cannot compare FQDNs", new Object[0]);
                    Logging.logMessage(4, this, OutputUtils.stackTraceToString(e), new Object[0]);
                    return 0;
                }
            }
        });
        return allOSDs;
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        return allOSDs;
    }

    @Override
    public void setAttribute(String key, String value) {
    }
}

