/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class SortHostRoundRobinPolicy
implements OSDSelectionPolicy {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_SORT_HOST_ROUND_ROBIN.getNumber();

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        return this.getOSDs(allOSDs);
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        HashMap hostToOsdsMap = new HashMap();
        for (DIR.Service osd : allOSDs.getServicesList()) {
            try {
                String host = new ServiceUUID(osd.getUuid()).getAddress().getHostName();
                if (hostToOsdsMap.containsKey(host)) {
                    ((LinkedList)hostToOsdsMap.get(host)).add(osd);
                    continue;
                }
                hostToOsdsMap.put(host, new LinkedList());
                ((LinkedList)hostToOsdsMap.get(host)).add(osd);
            }
            catch (UnknownUUIDException exc) {
                Logging.logError(3, this, exc);
            }
        }
        DIR.ServiceSet.Builder result = DIR.ServiceSet.newBuilder();
        while (result.getServicesCount() < allOSDs.getServicesCount()) {
            for (LinkedList osds : hostToOsdsMap.values()) {
                if (osds.isEmpty()) continue;
                result.addServices((DIR.Service)osds.pop());
            }
        }
        return result;
    }

    @Override
    public void setAttribute(String key, String value) {
    }
}

