/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.LinkedList;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;
import org.xtreemfs.osd.vivaldi.VivaldiNode;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class SortVivaldiPolicy
implements OSDSelectionPolicy {
    public static final short POLICY_ID = (short)GlobalTypes.OSDSelectionPolicyType.OSD_SELECTION_POLICY_SORT_VIVALDI.getNumber();

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        if (allOSDs == null) {
            return null;
        }
        Hashtable<String, Double> distances = new Hashtable<String, Double>();
        for (DIR.Service oneOSD : allOSDs.getServicesList()) {
            GlobalTypes.VivaldiCoordinates osdCoords;
            DIR.ServiceDataMap sdm = oneOSD.getData();
            String strCoords = KeyValuePairs.getValue(sdm.getDataList(), "vivaldi_coordinates");
            if (strCoords == null || (osdCoords = VivaldiNode.stringToCoordinates(strCoords)) == null) continue;
            double currentDistance = VivaldiNode.calculateDistance(clientCoords, osdCoords);
            distances.put(oneOSD.getUuid(), currentDistance);
        }
        LinkedList<DIR.Service> retSet = new LinkedList<DIR.Service>();
        for (DIR.Service oneOSD : allOSDs.getServicesList()) {
            Double oneOSDDistance = (Double)distances.get(oneOSD.getUuid());
            if (oneOSDDistance != null) {
                boolean inserted = false;
                int i = 0;
                while (!inserted) {
                    if (i >= retSet.size()) {
                        retSet.add(oneOSD);
                        inserted = true;
                        continue;
                    }
                    Double iDistance = (Double)distances.get(((DIR.Service)retSet.get(i)).getUuid());
                    if (iDistance == null || oneOSDDistance < iDistance) {
                        retSet.add(i, oneOSD);
                        inserted = true;
                        continue;
                    }
                    ++i;
                }
                continue;
            }
            retSet.add(oneOSD);
        }
        return DIR.ServiceSet.newBuilder().addAllServices(retSet);
    }

    @Override
    public DIR.ServiceSet.Builder getOSDs(DIR.ServiceSet.Builder allOSDs) {
        return allOSDs;
    }

    @Override
    public void setAttribute(String key, String value) {
    }
}

