/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.osdselection;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.metadata.XAttr;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.OSDSelectionPolicy;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class VolumeOSDFilter {
    private final MRCRequestDispatcher master;
    private String volId;
    private short[] osdPolicy;
    private short[] replPolicy;
    private Map<Short, OSDSelectionPolicy> policyMap;
    private final Map<String, DIR.Service> knownOSDMap;

    public VolumeOSDFilter(MRCRequestDispatcher master, Map<String, DIR.Service> knownOSDMap) {
        this.master = master;
        this.knownOSDMap = knownOSDMap;
    }

    public void init(VolumeInfo volume) throws DatabaseException {
        this.volId = volume.getId();
        this.osdPolicy = volume.getOsdPolicy();
        this.replPolicy = volume.getReplicaPolicy();
        this.policyMap = new HashMap<Short, OSDSelectionPolicy>();
        for (short pol : this.osdPolicy) {
            try {
                if (this.policyMap.containsKey(pol)) continue;
                this.policyMap.put(pol, this.master.getPolicyContainer().getOSDSelectionPolicy(pol));
            }
            catch (Exception e) {
                Logging.logMessage(3, (Object)Logging.Category.misc, "could not instantiate OSDSelectionPolicy %d", pol);
                Logging.logMessage(3, (Object)Logging.Category.misc, OutputUtils.stackTraceToString(e), new Object[0]);
            }
        }
        for (short pol : this.replPolicy) {
            try {
                if (this.policyMap.containsKey(pol)) continue;
                this.policyMap.put(pol, this.master.getPolicyContainer().getOSDSelectionPolicy(pol));
            }
            catch (Exception e) {
                Logging.logMessage(3, (Object)Logging.Category.misc, "could not instantiate OSDSelectionPolicy %d", pol);
                Logging.logMessage(3, (Object)Logging.Category.misc, OutputUtils.stackTraceToString(e), new Object[0]);
            }
        }
        try {
            DatabaseResultSet<XAttr> xattrs = this.master.getVolumeManager().getStorageManager(this.volId).getXAttrs(1L, "");
            while (xattrs.hasNext()) {
                XAttr xattr = (XAttr)xattrs.next();
                if (!xattr.getKey().startsWith("xtreemfs.policies.")) continue;
                this.setAttribute(xattr.getKey(), new String(xattr.getValue()));
            }
            xattrs.destroy();
        }
        catch (Exception exc) {
            Logging.logMessage(3, (Object)Logging.Category.misc, "could not set policy attributes", new Object[0]);
            Logging.logMessage(3, (Object)Logging.Category.misc, OutputUtils.stackTraceToString(exc), new Object[0]);
        }
    }

    public void setAttribute(String key, String value) {
        assert (key.startsWith("xtreemfs.policies."));
        int index = (key = key.substring("xtreemfs.policies.".length())).indexOf(46);
        if (index == -1) {
            Logging.logMessage(4, Logging.Category.misc, this, "'%s=%s :' XtreemFS no longer supports global policy attributes. It is necessary to specify a policy e.g., '1000.%s=%s'", key, value, key, value);
        } else {
            short policyId = Short.parseShort(key.substring(0, index));
            OSDSelectionPolicy pol = this.policyMap.get(policyId);
            if (pol != null) {
                pol.setAttribute(key.substring(index + 1), value);
            }
        }
    }

    public DIR.ServiceSet.Builder filterByOSDSelectionPolicy(DIR.ServiceSet.Builder knownOSDs, InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, XLocList currentXLoc, int numOSDs) {
        DIR.ServiceSet.Builder result = DIR.ServiceSet.newBuilder().addAllServices(knownOSDs.getServicesList());
        for (short id : this.osdPolicy) {
            OSDSelectionPolicy policy = this.policyMap.get(id);
            if (policy == null) {
                Logging.logMessage(3, Logging.Category.proc, this, "could not find OSD selection policy with ID=%d, will be ignored", id);
                continue;
            }
            result = policy.getOSDs(result, clientIP, clientCoords, currentXLoc, numOSDs);
        }
        return result;
    }

    public DIR.ServiceSet.Builder filterByOSDSelectionPolicy(DIR.ServiceSet.Builder knownOSDs) {
        DIR.ServiceSet.Builder result = DIR.ServiceSet.newBuilder().addAllServices(knownOSDs.getServicesList());
        for (short id : this.osdPolicy) {
            OSDSelectionPolicy policy = this.policyMap.get(id);
            if (policy == null) {
                Logging.logMessage(4, Logging.Category.misc, this, "could not find OSD selection policy with ID %d, will be ignored", id);
                continue;
            }
            result = policy.getOSDs(result);
        }
        return result;
    }

    public GlobalTypes.Replicas sortByReplicaSelectionPolicy(InetAddress clientIP, GlobalTypes.VivaldiCoordinates clientCoords, List<GlobalTypes.Replica> unsortedRepls, XLocList xLocList) {
        HashMap<String, GlobalTypes.Replica> replMap = new HashMap<String, GlobalTypes.Replica>();
        DIR.ServiceSet.Builder headOSDServiceSetBuilder = DIR.ServiceSet.newBuilder();
        for (int i = 0; i < unsortedRepls.size(); ++i) {
            GlobalTypes.Replica repl = unsortedRepls.get(i);
            assert (repl.getOsdUuidsCount() > 0);
            String headOSD = repl.getOsdUuids(0);
            replMap.put(headOSD, repl);
            DIR.Service s = this.knownOSDMap.get(headOSD);
            if (s == null) {
                s = DIR.Service.newBuilder().setData(DIR.ServiceDataMap.newBuilder()).setLastUpdatedS(0L).setName("OSD @ " + headOSD).setType(DIR.ServiceType.SERVICE_TYPE_OSD).setUuid(headOSD).setVersion(0L).build();
            }
            headOSDServiceSetBuilder.addServices(s);
        }
        for (short id : this.replPolicy) {
            OSDSelectionPolicy policy = this.policyMap.get(id);
            if (policy == null) {
                Logging.logMessage(4, Logging.Category.misc, this, "could not find Replica selection policy with ID %d, will be ignored", id);
                continue;
            }
            headOSDServiceSetBuilder = policy.getOSDs(headOSDServiceSetBuilder, clientIP, clientCoords, xLocList, headOSDServiceSetBuilder.getServicesCount());
        }
        GlobalTypes.Replicas.Builder sortedReplsBuilder = GlobalTypes.Replicas.newBuilder();
        for (DIR.Service headOSD : headOSDServiceSetBuilder.getServicesList()) {
            GlobalTypes.Replica r = (GlobalTypes.Replica)replMap.get(headOSD.getUuid());
            assert (r != null);
            assert (r.getOsdUuidsCount() > 0);
            GlobalTypes.Replica.Builder replBuilder = GlobalTypes.Replica.newBuilder().setReplicationFlags(r.getReplicationFlags()).setStripingPolicy(r.getStripingPolicy());
            for (int j = 0; j < r.getOsdUuidsCount(); ++j) {
                replBuilder.addOsdUuids(r.getOsdUuids(j));
            }
            sortedReplsBuilder.addReplicas(replBuilder);
        }
        return sortedReplsBuilder.build();
    }
}

