/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.stages;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.stages.MRCStageCallbackInterface;

public abstract class MRCStage
extends LifeCycleThread {
    protected BlockingQueue<StageMethod> q = new LinkedBlockingQueue<StageMethod>();
    protected volatile boolean quit = false;
    public AtomicInteger _numRq = new AtomicInteger(0);
    public AtomicInteger _maxRqTime = new AtomicInteger(0);
    public AtomicInteger _minRqTime = new AtomicInteger(Integer.MAX_VALUE);
    public AtomicLong _sumRqTime = new AtomicLong(0L);

    public MRCStage(String stageName) {
        super(stageName);
    }

    public void enqueueOperation(MRCRequest rq, int method, MRCStageCallbackInterface callback) {
        this.q.add(new StageMethod(rq, method, callback));
    }

    @Override
    public void shutdown() {
        this.quit = true;
        this.interrupt();
    }

    public int getQueueLength() {
        return this.q.size();
    }

    @Override
    public void run() {
        this.notifyStarted();
        while (!this.quit) {
            MRCRequest rq = null;
            try {
                StageMethod op = this.q.take();
                rq = op.getRq();
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.stage, this, "processing request XID=%d method %d", rq.getRPCRequest().getHeader().getCallId(), op.getStageMethod());
                }
                this.processMethod(op);
            }
            catch (InterruptedException ex) {
                break;
            }
            catch (Throwable ex) {
                this.notifyCrashed(ex);
                break;
            }
        }
        this.notifyStopped();
    }

    protected abstract void processMethod(StageMethod var1);

    protected static final class StageMethod {
        private MRCRequest rq;
        private int stageMethod;
        private MRCStageCallbackInterface callback;

        public StageMethod(MRCRequest rq, int stageMethod, MRCStageCallbackInterface callback) {
            this.rq = rq;
            this.stageMethod = stageMethod;
            this.callback = callback;
        }

        public int getStageMethod() {
            return this.stageMethod;
        }

        public void setStageMethod(int stageMethod) {
            this.stageMethod = stageMethod;
        }

        public MRCRequest getRq() {
            return this.rq;
        }

        public void setRq(MRCRequest rq) {
            this.rq = rq;
        }

        public MRCStageCallbackInterface getCallback() {
            return this.callback;
        }

        public void setCallback(MRCStageCallbackInterface callback) {
            this.callback = callback;
        }
    }

    public static enum StageResponseCode {
        OK,
        FAILED,
        WAIT,
        FINISH;

    }
}

