/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.stages;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.xloc.StripingPolicyImpl;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRC;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;

public class OnCloseReplicationThread
extends LifeCycleThread {
    private final MRCRequestDispatcher master;
    private boolean quit;
    private final LinkedBlockingQueue<MRCRequest> requests;

    public OnCloseReplicationThread(MRCRequestDispatcher master) {
        super("OnCloseReplThr");
        this.master = master;
        this.requests = new LinkedBlockingQueue();
    }

    @Override
    public void shutdown() {
        this.quit = true;
        this.interrupt();
    }

    public void enqueueRequest(MRCRequest req) {
        assert (this.isAlive());
        assert (req != null);
        this.requests.add(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.notifyStarted();
        try {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.lifecycle, this, "OnCloseReplicationThread started", new Object[0]);
            }
            do {
                MRCRequest req = this.requests.take();
                GlobalTypes.XCap xcap = ((MRC.xtreemfs_update_file_sizeRequest)req.getRequestArgs()).getXcap();
                GlobalTypes.XLocSet xlocSet = (GlobalTypes.XLocSet)req.getDetails().context.get("xLocList");
                GlobalTypes.FileCredentials creds = GlobalTypes.FileCredentials.newBuilder().setXcap(xcap).setXlocs(xlocSet).build();
                try {
                    if (Logging.isDebug()) {
                        Logging.logMessage(7, Logging.Category.proc, this, "triggering replication for %s", xlocSet.toString());
                    }
                    for (int i = 1; i < xlocSet.getReplicasCount(); ++i) {
                        GlobalTypes.Replica repl = xlocSet.getReplicas(i);
                        StripingPolicyImpl spol = StripingPolicyImpl.getPolicy(repl, 0);
                        for (int j = 0; j < repl.getOsdUuidsCount(); ++j) {
                            Iterator<Long> objs = spol.getObjectsOfOSD(j, 0L, Long.MAX_VALUE);
                            long obj = objs.next();
                            RPCResponse<OSD.ObjectData> resp = null;
                            try {
                                InetSocketAddress osd = new ServiceUUID(repl.getOsdUuids(j)).getAddress();
                                resp = this.master.getOSDClient().read(osd, RPCAuthentication.authNone, RPCAuthentication.userService, creds, xcap.getFileId(), obj, 0L, 0, 1);
                                resp.get();
                                continue;
                            }
                            catch (Exception e) {
                                Logging.logMessage(4, Logging.Category.proc, this, OutputUtils.stackTraceToString(e), new Object[0]);
                                continue;
                            }
                            finally {
                                if (resp != null) {
                                    resp.freeBuffers();
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    Logging.logError(3, this, ex);
                }
            } while (!this.quit);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.notifyStopped();
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.lifecycle, this, "OnCloseReplicationThread finished", new Object[0]);
        }
    }
}

