/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.stages;

import com.google.protobuf.Descriptors;
import java.util.HashMap;
import java.util.Map;
import org.xtreemfs.common.auth.AuthenticationException;
import org.xtreemfs.common.auth.UserCredentials;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.mrc.ErrorRecord;
import org.xtreemfs.mrc.MRCException;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.StatusPage;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.operations.AccessOperation;
import org.xtreemfs.mrc.operations.AddReplicaOperation;
import org.xtreemfs.mrc.operations.CheckFileListOperation;
import org.xtreemfs.mrc.operations.CheckpointOperation;
import org.xtreemfs.mrc.operations.CreateDirOperation;
import org.xtreemfs.mrc.operations.CreateLinkOperation;
import org.xtreemfs.mrc.operations.CreateSymLinkOperation;
import org.xtreemfs.mrc.operations.CreateVolumeOperation;
import org.xtreemfs.mrc.operations.DeleteOperation;
import org.xtreemfs.mrc.operations.DeleteVolumeOperation;
import org.xtreemfs.mrc.operations.DumpDBOperation;
import org.xtreemfs.mrc.operations.FSetAttrOperation;
import org.xtreemfs.mrc.operations.GetFileCredentialsOperation;
import org.xtreemfs.mrc.operations.GetLocalVolumesOperation;
import org.xtreemfs.mrc.operations.GetSuitableOSDsOperation;
import org.xtreemfs.mrc.operations.GetXAttrOperation;
import org.xtreemfs.mrc.operations.GetXAttrsOperation;
import org.xtreemfs.mrc.operations.GetXLocListOperation;
import org.xtreemfs.mrc.operations.GetXLocSetOperation;
import org.xtreemfs.mrc.operations.InternalDebugOperation;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.operations.MoveOperation;
import org.xtreemfs.mrc.operations.OpenOperation;
import org.xtreemfs.mrc.operations.ReadDirAndStatOperation;
import org.xtreemfs.mrc.operations.ReadLinkOperation;
import org.xtreemfs.mrc.operations.RemoveReplicaOperation;
import org.xtreemfs.mrc.operations.RemoveXAttrOperation;
import org.xtreemfs.mrc.operations.RenewOperation;
import org.xtreemfs.mrc.operations.RestoreDBOperation;
import org.xtreemfs.mrc.operations.RestoreFileOperation;
import org.xtreemfs.mrc.operations.SetReadOnlyXattrOperation;
import org.xtreemfs.mrc.operations.SetReplicaUpdatePolicyOperation;
import org.xtreemfs.mrc.operations.SetXAttrOperation;
import org.xtreemfs.mrc.operations.SetattrOperation;
import org.xtreemfs.mrc.operations.ShutdownOperation;
import org.xtreemfs.mrc.operations.StatFSOperation;
import org.xtreemfs.mrc.operations.StatOperation;
import org.xtreemfs.mrc.operations.TruncateOperation;
import org.xtreemfs.mrc.operations.UpdateFileSizeOperation;
import org.xtreemfs.mrc.stages.InternalCallbackInterface;
import org.xtreemfs.mrc.stages.InternalCallbackMRCRequest;
import org.xtreemfs.mrc.stages.MRCStage;

public class ProcessingStage
extends MRCStage {
    public static final int STAGEOP_PARSE_AND_EXECUTE = 1;
    public static final int STAGEOP_INTERNAL_CALLBACK = 2;
    private final MRCRequestDispatcher master;
    private final Map<Integer, MRCOperation> operations;
    private final Map<Integer, Integer> _opCountMap;
    private final boolean statisticsEnabled = true;

    public ProcessingStage(MRCRequestDispatcher master) {
        super("ProcSt");
        this.master = master;
        this.operations = new HashMap<Integer, MRCOperation>();
        this.installOperations();
        this._opCountMap = new HashMap<Integer, Integer>();
        for (Integer i : this.operations.keySet()) {
            this._opCountMap.put(i, 0);
        }
    }

    public void installOperations() {
        this.operations.put(45, new ShutdownOperation(this.master));
        this.operations.put(47, new CreateVolumeOperation(this.master));
        this.operations.put(44, new DeleteVolumeOperation(this.master));
        this.operations.put(36, new GetLocalVolumesOperation(this.master));
        this.operations.put(4, new StatOperation(this.master));
        this.operations.put(10, new ReadDirAndStatOperation(this.master));
        this.operations.put(8, new CreateDirOperation(this.master));
        this.operations.put(18, new CreateSymLinkOperation(this.master));
        this.operations.put(19, new DeleteOperation(this.master));
        this.operations.put(14, new DeleteOperation(this.master));
        this.operations.put(5, new GetXAttrOperation(this.master));
        this.operations.put(7, new GetXAttrsOperation(this.master));
        this.operations.put(16, new SetXAttrOperation(this.master));
        this.operations.put(12, new RemoveXAttrOperation(this.master));
        this.operations.put(9, new OpenOperation(this.master));
        this.operations.put(37, new RenewOperation(this.master));
        this.operations.put(39, new AddReplicaOperation(this.master));
        this.operations.put(41, new RemoveReplicaOperation(this.master));
        this.operations.put(40, new GetXLocListOperation(this.master));
        this.operations.put(13, new MoveOperation(this.master));
        this.operations.put(6, new CreateLinkOperation(this.master));
        this.operations.put(17, new StatFSOperation(this.master));
        this.operations.put(11, new ReadLinkOperation(this.master));
        this.operations.put(32, new DumpDBOperation(this.master));
        this.operations.put(42, new RestoreDBOperation(this.master));
        this.operations.put(31, new CheckFileListOperation(this.master));
        this.operations.put(43, new RestoreFileOperation(this.master));
        this.operations.put(30, new CheckpointOperation(this.master));
        this.operations.put(15, new SetattrOperation(this.master));
        this.operations.put(2, new FSetAttrOperation(this.master));
        this.operations.put(33, new GetSuitableOSDsOperation(this.master));
        this.operations.put(3, new TruncateOperation(this.master));
        this.operations.put(34, new InternalDebugOperation(this.master));
        this.operations.put(46, new UpdateFileSizeOperation(this.master));
        this.operations.put(20, new AccessOperation(this.master));
        this.operations.put(48, new SetReplicaUpdatePolicyOperation(this.master));
        this.operations.put(49, new SetReadOnlyXattrOperation(this.master));
        this.operations.put(50, new GetFileCredentialsOperation(this.master));
        this.operations.put(51, new GetXLocSetOperation(this.master));
    }

    public Map<Integer, Integer> get_opCountMap() {
        return this._opCountMap;
    }

    @Override
    protected void processMethod(MRCStage.StageMethod method) {
        switch (method.getStageMethod()) {
            case 1: {
                this.parseAndExecute(method);
                break;
            }
            case 2: {
                this.executeInternalCallback(method);
                break;
            }
            default: {
                method.getRq().setError(RPC.ErrorType.INTERNAL_SERVER_ERROR, "unknown stage operation");
                this.master.requestFinished(method.getRq());
            }
        }
    }

    private void parseAndExecute(MRCStage.StageMethod method) {
        MRCOperation op;
        block8: {
            MRCRequest rq = method.getRq();
            RPCServerRequest rpcRequest = rq.getRPCRequest();
            RPC.RPCHeader header = rpcRequest.getHeader();
            RPC.RPCHeader.RequestHeader rqHeader = header.getRequestHeader();
            if (header.getMessageType() != RPC.MessageType.RPC_REQUEST) {
                rq.setError(RPC.ErrorType.GARBAGE_ARGS, RPC.POSIXErrno.POSIX_ERROR_EIO, "expected RPC request message type but got " + header.getMessageType());
                return;
            }
            op = this.operations.get(rqHeader.getProcId());
            if (op == null) {
                rq.setError(RPC.ErrorType.INVALID_PROC_ID, "requested operation (" + rqHeader.getProcId() + ") is not available on this MRC");
                this.master.requestFinished(rq);
                return;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.stage, this, "operation for request %s: %s", rq.toString(), op.getClass().getSimpleName());
            }
            this._opCountMap.put(rqHeader.getProcId(), this._opCountMap.get(rqHeader.getProcId()) + 1);
            ErrorRecord error = op.parseRequestArgs(rq);
            if (error != null) {
                rq.setError(error);
                this.master.requestFinished(rq);
                return;
            }
            try {
                RPC.Auth auth = header.getRequestHeader().hasAuthData() ? header.getRequestHeader().getAuthData() : null;
                RPC.UserCredentials ctx = op.getUserCredentials(rq);
                if (ctx == null) break block8;
                try {
                    UserCredentials cred = this.master.getAuthProvider().getEffectiveCredentials(ctx, rpcRequest.getConnection().getChannel());
                    rq.getDetails().superUser = cred.isSuperUser();
                    rq.getDetails().groupIds = cred.getGroupIDs();
                    rq.getDetails().userId = cred.getUserID();
                    rq.getDetails().auth = auth;
                    rq.getDetails().password = auth != null && auth.hasAuthPasswd() ? auth.getAuthPasswd().getPassword() : "";
                }
                catch (AuthenticationException ex) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, ex.getMessage());
                }
            }
            catch (Exception exc) {
                method.getRq().setError(RPC.ErrorType.INTERNAL_SERVER_ERROR, "could not initialize authentication module", exc);
                this.master.requestFinished(method.getRq());
                return;
            }
        }
        this.execute(op, method);
    }

    private void execute(MRCOperation op, MRCStage.StageMethod method) {
        MRCRequest rq = method.getRq();
        RPCServerRequest rpcRequest = rq.getRPCRequest();
        RPC.RPCHeader header = rpcRequest.getHeader();
        RPC.RPCHeader.RequestHeader rqHeader = header.getRequestHeader();
        try {
            if (Logging.isDebug()) {
                Map<Descriptors.FieldDescriptor, Object> fieldMap;
                StringBuffer params = new StringBuffer();
                Map<Descriptors.FieldDescriptor, Object> map = fieldMap = rq.getRequestArgs() == null ? null : rq.getRequestArgs().getAllFields();
                if (fieldMap != null) {
                    int i = 0;
                    for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fieldMap.entrySet()) {
                        params.append(entry.getKey().getName() + "='" + entry.getValue() + (i == fieldMap.size() - 1 ? "'" : "', "));
                        ++i;
                    }
                }
                Logging.logMessage(7, this, "parsed request: %s (%s)\n", StatusPage.getOpName(rqHeader.getProcId()), params.toString());
            }
            op.startRequest(rq);
        }
        catch (UserException exc) {
            this.reportUserError(op, rq, exc, exc.getErrno());
        }
        catch (MRCException exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof DatabaseException && ((DatabaseException)cause).getType() == DatabaseException.ExceptionType.NOT_ALLOWED) {
                this.reportUserError(op, rq, exc, RPC.POSIXErrno.POSIX_ERROR_EPERM);
            } else {
                this.reportServerError(op, rq, exc);
            }
        }
        catch (DatabaseException exc) {
            if (exc.getType() == DatabaseException.ExceptionType.NOT_ALLOWED) {
                this.reportUserError(op, rq, exc, RPC.POSIXErrno.POSIX_ERROR_EPERM);
            } else if (exc.getType() == DatabaseException.ExceptionType.REDIRECT) {
                try {
                    this.redirect(rq, exc.getAttachment() != null ? (String)exc.getAttachment() : this.master.getReplMasterUUID());
                }
                catch (MRCException e) {
                    this.reportServerError(op, rq, e);
                }
            } else {
                this.reportServerError(op, rq, exc);
            }
        }
        catch (Throwable exc) {
            this.reportServerError(op, rq, exc);
        }
    }

    public void enqueueInternalCallbackOperation(MRCRequest rq, InternalCallbackInterface callback) {
        InternalCallbackMRCRequest cbRq = new InternalCallbackMRCRequest(rq, callback);
        this.q.add(new MRCStage.StageMethod(cbRq, 2, null));
    }

    private void executeInternalCallback(MRCStage.StageMethod method) {
        this.execute(new MRCOperation(this.master){

            @Override
            public void startRequest(MRCRequest rq) throws Throwable {
                if (!(rq instanceof InternalCallbackMRCRequest)) {
                    throw new MRCException("InternalCallbackOperations must be called with a MRCCallbackRequest.");
                }
                InternalCallbackInterface callback = ((InternalCallbackMRCRequest)rq).getCallback();
                callback.execute(rq);
            }
        }, method);
    }

    private void reportUserError(MRCOperation op, MRCRequest rq, Throwable exc, RPC.POSIXErrno errno) {
        if (Logging.isDebug()) {
            Logging.logUserError(7, Logging.Category.proc, this, exc);
        }
        op.finishRequest(rq, new ErrorRecord(RPC.ErrorType.ERRNO, errno, exc.getMessage(), exc));
    }

    private void reportServerError(MRCOperation op, MRCRequest rq, Throwable exc) {
        if (Logging.isDebug()) {
            Logging.logUserError(7, Logging.Category.proc, this, exc);
        }
        op.finishRequest(rq, new ErrorRecord(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "An error has occurred at the MRC. Details: " + exc.getMessage(), exc));
    }

    private void redirect(MRCRequest rq, String uuid) {
        rq.getRPCRequest().sendRedirect(uuid);
    }
}

