/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.stages;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.libxtreemfs.Helper;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.foundation.LifeCycleThread;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCAuthentication;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.client.RPCResponseAvailableListener;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.ErrorRecord;
import org.xtreemfs.mrc.MRCException;
import org.xtreemfs.mrc.MRCRequest;
import org.xtreemfs.mrc.MRCRequestDispatcher;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DBAccessResultListener;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.operations.MRCOperation;
import org.xtreemfs.mrc.stages.InternalCallbackInterface;
import org.xtreemfs.mrc.stages.XLocSetCoordinatorCallback;
import org.xtreemfs.mrc.stages.XLocSetLock;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.osd.rwre.CoordinatedReplicaUpdatePolicy;
import org.xtreemfs.pbrpc.generatedinterfaces.Common;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class XLocSetCoordinator
extends LifeCycleThread
implements DBAccessResultListener<Object> {
    public static final String XLOCSET_CHANGE_ATTR_KEY = "xlocsetchange";
    protected volatile boolean quit = false;
    private final MRCRequestDispatcher master;
    private BlockingQueue<RequestMethod> q = new LinkedBlockingQueue<RequestMethod>();
    private final int leaseToMS;

    public XLocSetCoordinator(MRCRequestDispatcher master) {
        super("XLocSetCoordinator");
        this.master = master;
        this.leaseToMS = master.getConfig().getFleaseLeaseToMS();
    }

    @Override
    public void run() {
        this.notifyStarted();
        while (!this.quit) {
            try {
                RequestMethod m = this.q.take();
                this.processRequest(m);
            }
            catch (InterruptedException ex) {
            }
            catch (Throwable ex) {
                this.notifyCrashed(ex);
                break;
            }
        }
        this.notifyStopped();
    }

    @Override
    public void shutdown() {
        this.quit = true;
        this.interrupt();
    }

    private void processRequest(RequestMethod m) throws InterruptedException {
        try {
            switch (m.getRequestType()) {
                case ADD_REPLICAS: {
                    this.processAddReplicas(m);
                    break;
                }
                case REMOVE_REPLICAS: {
                    this.processRemoveReplicas(m);
                    break;
                }
                default: {
                    throw new Exception("unknown stage operation");
                }
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            this.handleError(m, e);
        }
    }

    public <O extends MRCOperation> RequestMethod addReplicas(String fileId, FileMetadata file, XLocList curXLocList, XLocList extXLocList, MRCRequest rq, O op) throws DatabaseException {
        return this.addReplicas(fileId, file, curXLocList, extXLocList, rq, op, (XLocSetCoordinatorCallback)((Object)op));
    }

    public RequestMethod addReplicas(String fileId, FileMetadata file, XLocList curXLocList, XLocList extXLocList, MRCRequest rq, MRCOperation op, XLocSetCoordinatorCallback callback) throws DatabaseException {
        Capability cap = this.buildCapability(fileId, file);
        RequestMethod m = new RequestMethod(RequestType.ADD_REPLICAS, fileId, rq, op, callback, cap, curXLocList, extXLocList);
        return m;
    }

    private void processAddReplicas(final RequestMethod m) throws Throwable {
        MRCRequest rq = m.getRequest();
        final String fileId = m.getFileId();
        Capability cap = m.getCapability();
        final XLocList curXLocList = m.getCurXLocList();
        final XLocList extXLocList = m.getNewXLocList();
        GlobalTypes.XLocSet curXLocSet = Converter.xLocListToXLocSet(curXLocList).build();
        GlobalTypes.XLocSet extXLocSet = Converter.xLocListToXLocSet(extXLocList).setVersion(curXLocSet.getVersion()).build();
        if (extXLocSet.getReplicaUpdatePolicy().equals("WqRq") || extXLocSet.getReplicaUpdatePolicy().equals("WaR1") || extXLocSet.getReplicaUpdatePolicy().equals("WaRa")) {
            int curNumRequiredAcks = this.calculateNumRequiredAcks(fileId, curXLocSet);
            OSD.ReplicaStatus[] states = this.invalidateReplicas(fileId, cap, curXLocSet, curNumRequiredAcks);
            OSD.AuthoritativeReplicaState authState = this.calculateAuthoritativeState(fileId, curXLocSet, states);
            Set<String> replicasUpToDate = this.calculateReplicasUpToDate(authState);
            int extNumRequiredAcks = this.calculateNumRequiredAcks(fileId, extXLocSet);
            this.updateReplicas(fileId, cap, extXLocSet, authState, extNumRequiredAcks, replicasUpToDate);
        } else if (extXLocSet.getReplicaUpdatePolicy().equals("ronly")) {
            this.invalidateReplicas(fileId, cap, curXLocSet, 1);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "replication policy (%s) will be handled by VolumeImplementation", extXLocSet.getReplicaUpdatePolicy());
            }
        } else {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "Unknown replica update policy: " + extXLocSet.getReplicaUpdatePolicy());
        }
        this.master.getProcStage().enqueueInternalCallbackOperation(rq, new InternalCallbackInterface(){

            @Override
            public void execute(MRCRequest rq) throws Throwable {
                m.getCallback().installXLocSet(rq, fileId, extXLocList, curXLocList);
            }
        });
    }

    public <O extends MRCOperation> RequestMethod removeReplicas(String fileId, FileMetadata file, XLocList curXLocList, XLocList newXLocList, MRCRequest rq, O op) throws DatabaseException {
        return this.removeReplicas(fileId, file, curXLocList, newXLocList, rq, op, (XLocSetCoordinatorCallback)((Object)op));
    }

    public RequestMethod removeReplicas(String fileId, FileMetadata file, XLocList curXLocList, XLocList newXLocList, MRCRequest rq, MRCOperation op, XLocSetCoordinatorCallback callback) throws DatabaseException {
        Capability cap = this.buildCapability(fileId, file);
        RequestMethod m = new RequestMethod(RequestType.REMOVE_REPLICAS, fileId, rq, op, callback, cap, curXLocList, newXLocList);
        return m;
    }

    private void processRemoveReplicas(final RequestMethod m) throws Throwable {
        MRCRequest rq = m.getRequest();
        final String fileId = m.getFileId();
        Capability cap = m.getCapability();
        final XLocList curXLocList = m.getCurXLocList();
        final XLocList newXLocList = m.getNewXLocList();
        GlobalTypes.XLocSet curXLocSet = Converter.xLocListToXLocSet(curXLocList).build();
        GlobalTypes.XLocSet newXLocSet = Converter.xLocListToXLocSet(newXLocList).setVersion(curXLocSet.getVersion()).build();
        if (curXLocSet.getReplicaUpdatePolicy().equals("WqRq") || curXLocSet.getReplicaUpdatePolicy().equals("WaR1") || curXLocSet.getReplicaUpdatePolicy().equals("WaRa")) {
            String OSDUUID;
            int numRequiredAcks = this.calculateNumRequiredAcks(fileId, curXLocSet);
            OSD.ReplicaStatus[] states = this.invalidateReplicas(fileId, cap, curXLocSet, numRequiredAcks);
            OSD.AuthoritativeReplicaState authState = this.calculateAuthoritativeState(fileId, curXLocSet, states);
            Set<String> replicasUpToDate = this.calculateReplicasUpToDate(authState);
            HashSet<String> newReplicas = new HashSet<String>();
            for (int i = 0; i < newXLocSet.getReplicasCount(); ++i) {
                OSDUUID = Helper.getOSDUUIDFromXlocSet(curXLocSet, i, 0);
                newReplicas.add(OSDUUID);
            }
            Iterator<String> iterator = replicasUpToDate.iterator();
            while (iterator.hasNext()) {
                OSDUUID = iterator.next();
                if (newReplicas.contains(OSDUUID)) continue;
                iterator.remove();
            }
            int newNumRequiredAcks = this.calculateNumRequiredAcks(fileId, newXLocSet);
            this.updateReplicas(fileId, cap, newXLocSet, authState, newNumRequiredAcks, replicasUpToDate);
        } else if (curXLocSet.getReplicaUpdatePolicy().equals("ronly")) {
            OSD.ReplicaStatus[] states = this.invalidateReplicas(fileId, cap, curXLocSet, 1);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.replication, this, "replication policy (%s) will be handled by VolumeImplementation", curXLocSet.getReplicaUpdatePolicy());
            }
        } else {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "Unknown replica update policy: " + curXLocSet.getReplicaUpdatePolicy());
        }
        this.master.getProcStage().enqueueInternalCallbackOperation(rq, new InternalCallbackInterface(){

            @Override
            public void execute(MRCRequest rq) throws Throwable {
                m.getCallback().installXLocSet(rq, fileId, newXLocList, curXLocList);
            }
        });
    }

    public void lockXLocSet(FileMetadata file, StorageManager sMan, AtomicDBUpdate update) throws DatabaseException {
        byte[] hashValue = new byte[4];
        ByteBuffer hashByte = ByteBuffer.wrap(hashValue).putInt(this.master.hashCode());
        sMan.setXAttr(file.getId(), "", "xtreemfs.xlocsetchange", hashValue, update);
        hashByte.clear();
    }

    public void unlockXLocSet(FileMetadata file, StorageManager sMan, AtomicDBUpdate update) throws DatabaseException {
        sMan.setXAttr(file.getId(), "", "xtreemfs.xlocsetchange", null, update);
    }

    public XLocSetLock getXLocSetLock(FileMetadata file, StorageManager sMan) throws DatabaseException {
        XLocSetLock lock;
        byte[] prevHashBytes = sMan.getXAttr(file.getId(), "", "xtreemfs.xlocsetchange");
        if (prevHashBytes != null) {
            ByteBuffer prevHashBuffer = ByteBuffer.wrap(prevHashBytes);
            int prevHash = prevHashBuffer.getInt();
            prevHashBuffer.clear();
            lock = prevHash != this.master.hashCode() ? new XLocSetLock(true, true) : new XLocSetLock(true, false);
        } else {
            lock = new XLocSetLock(false, false);
        }
        return lock;
    }

    private Capability buildCapability(String fileId, FileMetadata file) {
        String clientIdentity;
        int accessMode = FileAccessManager.O_RDWR;
        int validity = this.master.getConfig().getCapabilityTimeout();
        long expires = TimeSync.getGlobalTime() / 1000L + (long)this.master.getConfig().getCapabilityTimeout();
        try {
            clientIdentity = this.master.getConfig().getAddress() != null ? this.master.getConfig().getAddress().toString() : InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            clientIdentity = "";
        }
        int epochNo = file.getEpoch();
        boolean replicateOnClose = false;
        GlobalTypes.SnapConfig snapConfig = GlobalTypes.SnapConfig.SNAP_CONFIG_SNAPS_DISABLED;
        long snapTimestamp = 0L;
        String sharedSecret = this.master.getConfig().getCapabilitySecret();
        Capability cap = new Capability(fileId, accessMode, validity, expires, clientIdentity, epochNo, replicateOnClose, snapConfig, snapTimestamp, sharedSecret);
        return cap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OSD.ReplicaStatus[] invalidateReplicas(String fileId, Capability cap, GlobalTypes.XLocSet xLocSet, int numAcksRequired) throws InterruptedException, MRCException {
        RPCResponse[] responses = new RPCResponse[xLocSet.getReplicasCount()];
        OSDServiceClient client = this.master.getOSDClient();
        GlobalTypes.FileCredentials creds = GlobalTypes.FileCredentials.newBuilder().setXcap(cap.getXCap()).setXlocs(xLocSet).build();
        for (int i = 0; i < responses.length; ++i) {
            ServiceUUID OSDServiceUUID = new ServiceUUID(Helper.getOSDUUIDFromXlocSet(xLocSet, i, 0));
            try {
                responses[i] = client.xtreemfs_xloc_set_invalidate(OSDServiceUUID.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, creds, fileId);
                continue;
            }
            catch (IOException ex) {
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                throw new MRCException(ex);
            }
        }
        class InvalidatedResponseListener
        implements RPCResponseAvailableListener<OSD.xtreemfs_xloc_set_invalidateResponse> {
            private int numResponses = 0;
            private int numErrors = 0;
            private boolean primaryResponded = false;
            private boolean primaryExists = false;
            private RPCResponse<OSD.xtreemfs_xloc_set_invalidateResponse>[] responses;
            private OSD.ReplicaStatus[] states;

            public InvalidatedResponseListener(RPCResponse<OSD.xtreemfs_xloc_set_invalidateResponse>[] responses) {
                this.responses = responses;
                this.states = new OSD.ReplicaStatus[responses.length];
                for (int i = 0; i < responses.length; ++i) {
                    responses[i].registerListener(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void responseAvailable(RPCResponse<OSD.xtreemfs_xloc_set_invalidateResponse> r) {
                int osdNum = -1;
                for (int i = 0; i < this.responses.length; ++i) {
                    if (this.responses[i] != r) continue;
                    osdNum = i;
                    break;
                }
                assert (osdNum > -1);
                try {
                    OSD.xtreemfs_xloc_set_invalidateResponse response = r.get();
                    if (response.hasReplicaStatus()) {
                        this.states[osdNum] = response.getReplicaStatus();
                    }
                    if (response.getLeaseState() == GlobalTypes.LeaseState.PRIMARY) {
                        this.primaryResponded = true;
                    } else if (response.getLeaseState() == GlobalTypes.LeaseState.BACKUP) {
                        this.primaryExists = true;
                    }
                    ++this.numResponses;
                }
                catch (Exception ex) {
                    ++this.numErrors;
                    Logging.logMessage(7, Logging.Category.replication, this, "no invalidated response from replica due to exception: %s", ex.toString());
                }
                finally {
                    r.freeBuffers();
                    this.notifyAll();
                }
            }

            synchronized OSD.ReplicaStatus[] getReplicaStates() {
                OSD.ReplicaStatus[] result = new OSD.ReplicaStatus[this.states.length];
                System.arraycopy(this.states, 0, result, 0, this.states.length);
                return result;
            }
        }
        InvalidatedResponseListener listener = new InvalidatedResponseListener(responses);
        int numMaxErrors = responses.length - numAcksRequired;
        InvalidatedResponseListener ex = listener;
        synchronized (ex) {
            while (listener.numResponses < numAcksRequired) {
                listener.wait();
                if (listener.numErrors <= numMaxErrors) continue;
                throw new MRCException("XLocSetCoordinator failed because too many replicas didn't respond to the invalidate request.");
            }
        }
        ex = listener;
        synchronized (ex) {
            if (listener.primaryExists) {
                long now = System.currentTimeMillis();
                long leaseEndTimeMs = now + (long)this.leaseToMS;
                while (!listener.primaryResponded && now < leaseEndTimeMs && listener.numResponses + listener.numErrors < responses.length) {
                    listener.wait(leaseEndTimeMs - now);
                    now = System.currentTimeMillis();
                }
            }
        }
        OSD.ReplicaStatus[] states = listener.getReplicaStates();
        return states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReplicas(String fileId, Capability cap, GlobalTypes.XLocSet xLocSet, OSD.AuthoritativeReplicaState authState, int numAcksRequired, Set<String> replicasUpToDate) throws InterruptedException, MRCException {
        OSDServiceClient client = this.master.getOSDClient();
        ArrayList<ServiceUUID> OSDServiceUUIDs = new ArrayList<ServiceUUID>();
        for (int i = 0; i < xLocSet.getReplicasCount(); ++i) {
            String OSDUUID = Helper.getOSDUUIDFromXlocSet(xLocSet, i, 0);
            if (replicasUpToDate.contains(OSDUUID.toString())) continue;
            OSDServiceUUIDs.add(new ServiceUUID(OSDUUID));
        }
        GlobalTypes.FileCredentials fileCredentials = GlobalTypes.FileCredentials.newBuilder().setXlocs(xLocSet).setXcap(cap.getXCap()).build();
        OSD.xtreemfs_rwr_auth_stateRequest authStateRequest = OSD.xtreemfs_rwr_auth_stateRequest.newBuilder().setFileId(fileId).setFileCredentials(fileCredentials).setState(authState).build();
        RPCResponse[] responses = new RPCResponse[OSDServiceUUIDs.size()];
        for (int i = 0; i < OSDServiceUUIDs.size(); ++i) {
            try {
                RPCResponse rpcResponse;
                ServiceUUID OSDUUID = (ServiceUUID)OSDServiceUUIDs.get(i);
                responses[i] = rpcResponse = client.xtreemfs_rwr_auth_state_invalidated(OSDUUID.getAddress(), RPCAuthentication.authNone, RPCAuthentication.userService, authStateRequest);
                continue;
            }
            catch (IOException ex) {
                if (Logging.isDebug()) {
                    Logging.logError(7, this, ex);
                }
                throw new MRCException(ex);
            }
        }
        class FetchInvalidatedResponseListener
        implements RPCResponseAvailableListener<Common.emptyResponse> {
            private int numResponses = 0;
            private int numErrors = 0;

            FetchInvalidatedResponseListener(RPCResponse<Common.emptyResponse>[] responses) {
                for (int i = 0; i < responses.length; ++i) {
                    responses[i].registerListener(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void responseAvailable(RPCResponse<Common.emptyResponse> r) {
                try {
                    r.get();
                    ++this.numResponses;
                }
                catch (Exception ex) {
                    ++this.numErrors;
                    Logging.logMessage(7, Logging.Category.replication, this, "no fetchInvalidated response from replica due to exception: %s", ex.toString());
                }
                finally {
                    r.freeBuffers();
                    this.notifyAll();
                }
            }
        }
        FetchInvalidatedResponseListener listener = new FetchInvalidatedResponseListener(responses);
        int numRequiredUpdates = numAcksRequired - replicasUpToDate.size();
        int numMaxErrors = OSDServiceUUIDs.size() - numRequiredUpdates;
        FetchInvalidatedResponseListener fetchInvalidatedResponseListener = listener;
        synchronized (fetchInvalidatedResponseListener) {
            while (listener.numResponses < numRequiredUpdates) {
                listener.wait();
                if (listener.numErrors <= numMaxErrors) continue;
                throw new MRCException("XLocSetCoordinator failed because too many replicas didn't respond to the update request.");
            }
        }
    }

    private Set<String> calculateReplicasUpToDate(OSD.AuthoritativeReplicaState authState) {
        HashMap<String, Integer> replicaObjCount = new HashMap<String, Integer>();
        int totalObjCount = 0;
        for (OSD.ObjectVersionMapping ovm : authState.getObjectVersionsList()) {
            if (ovm.getOsdUuidsCount() == 0) continue;
            ++totalObjCount;
            for (String OSDUUID : ovm.getOsdUuidsList()) {
                Integer c = (Integer)replicaObjCount.get(OSDUUID);
                c = c == null ? 1 : c + 1;
                replicaObjCount.put(OSDUUID, c);
            }
        }
        Iterator iter = replicaObjCount.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            if ((Integer)e.getValue() >= totalObjCount) continue;
            iter.remove();
        }
        return replicaObjCount.keySet();
    }

    private OSD.AuthoritativeReplicaState calculateAuthoritativeState(String fileId, GlobalTypes.XLocSet xLocSet, OSD.ReplicaStatus[] states) {
        int i;
        ArrayList<ServiceUUID> OSDUUIDs = new ArrayList<ServiceUUID>(xLocSet.getReplicasCount() - 1);
        for (i = 0; i < xLocSet.getReplicasCount() - 1; ++i) {
            OSDUUIDs.add(i, new ServiceUUID(Helper.getOSDUUIDFromXlocSet(xLocSet, i, 0)));
        }
        String localUUID = Helper.getOSDUUIDFromXlocSet(xLocSet, i, 0);
        return CoordinatedReplicaUpdatePolicy.CalculateAuthoritativeState(states, fileId, localUUID, OSDUUIDs);
    }

    private int calculateNumRequiredAcks(String fileId, GlobalTypes.XLocSet xLocSet) {
        int numRequiredAcks = xLocSet.getReplicasCount() / 2 + 1;
        return numRequiredAcks;
    }

    @Override
    public void finished(Object result, Object context) {
        if (!(context instanceof RequestMethod)) {
            throw new RuntimeException("The XLocSetCoordinator DBAccessResultListener has to be called with a RequestMethod as the context.");
        }
        RequestMethod m = (RequestMethod)context;
        this.q.add(m);
    }

    @Override
    public void failed(Throwable error, Object context) {
        if (!(context instanceof RequestMethod)) {
            throw new RuntimeException("The XLocSetCoordinator DBAccessResultListener has to be called with a RequestMethod as the context.");
        }
        RequestMethod m = (RequestMethod)context;
        this.master.failed(error, m.getRequest());
    }

    private void handleError(RequestMethod m, Throwable err) {
        MRCOperation op = m.getOperation();
        MRCRequest rq = m.getRequest();
        try {
            throw err;
        }
        catch (UserException exc) {
            this.reportUserError(op, rq, exc, exc.getErrno());
        }
        catch (MRCException exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof DatabaseException && ((DatabaseException)cause).getType() == DatabaseException.ExceptionType.NOT_ALLOWED) {
                this.reportUserError(op, rq, exc, RPC.POSIXErrno.POSIX_ERROR_EPERM);
            } else {
                this.reportServerError(op, rq, exc);
            }
        }
        catch (DatabaseException exc) {
            if (exc.getType() == DatabaseException.ExceptionType.NOT_ALLOWED) {
                this.reportUserError(op, rq, exc, RPC.POSIXErrno.POSIX_ERROR_EPERM);
            } else if (exc.getType() == DatabaseException.ExceptionType.REDIRECT) {
                try {
                    this.redirect(rq, exc.getAttachment() != null ? (String)exc.getAttachment() : this.master.getReplMasterUUID());
                }
                catch (MRCException e) {
                    this.reportServerError(op, rq, e);
                }
            } else {
                this.reportServerError(op, rq, exc);
            }
        }
        catch (Throwable exc) {
            this.reportServerError(op, rq, exc);
        }
    }

    private void reportUserError(MRCOperation op, MRCRequest rq, Throwable exc, RPC.POSIXErrno errno) {
        if (Logging.isDebug()) {
            Logging.logUserError(7, Logging.Category.proc, this, exc);
        }
        op.finishRequest(rq, new ErrorRecord(RPC.ErrorType.ERRNO, errno, exc.getMessage(), exc));
    }

    private void reportServerError(MRCOperation op, MRCRequest rq, Throwable exc) {
        if (Logging.isDebug()) {
            Logging.logUserError(7, Logging.Category.proc, this, exc);
        }
        op.finishRequest(rq, new ErrorRecord(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "An error has occurred at the MRC. Details: " + exc.getMessage(), exc));
    }

    private void redirect(MRCRequest rq, String uuid) {
        rq.getRPCRequest().sendRedirect(uuid);
    }

    public static final class RequestMethod {
        RequestType type;
        MRCOperation op;
        MRCRequest rq;
        String fileId;
        Capability capability;
        XLocSetCoordinatorCallback callback;
        XLocList curXLocList;
        XLocList newXLocList;

        public RequestMethod(RequestType type, String fileId, MRCRequest rq, MRCOperation op, XLocSetCoordinatorCallback callback, Capability cap, XLocList curXLocList, XLocList newXLocList) {
            this.type = type;
            this.op = op;
            this.rq = rq;
            this.fileId = fileId;
            this.callback = callback;
            this.capability = cap;
            this.curXLocList = curXLocList;
            this.newXLocList = newXLocList;
        }

        public RequestType getRequestType() {
            return this.type;
        }

        public String getFileId() {
            return this.fileId;
        }

        public MRCRequest getRequest() {
            return this.rq;
        }

        public MRCOperation getOperation() {
            return this.op;
        }

        public XLocSetCoordinatorCallback getCallback() {
            return this.callback;
        }

        public Capability getCapability() {
            return this.capability;
        }

        public XLocList getCurXLocList() {
            return this.curXLocList;
        }

        public XLocList getNewXLocList() {
            return this.newXLocList;
        }
    }

    private static enum RequestType {
        ADD_REPLICAS,
        REMOVE_REPLICAS;

    }
}

