/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.xtreemfs.common.KeyValuePairs;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONParser;
import org.xtreemfs.foundation.json.JSONString;
import org.xtreemfs.mrc.ac.FileAccessPolicy;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.metadata.ACLEntry;
import org.xtreemfs.mrc.metadata.ReplicationPolicy;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.metadata.XAttr;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.OSDStatusManager;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class Converter {
    public static Map<String, Object> aclToMap(Iterator<ACLEntry> acl, FileAccessPolicy policy) {
        if (acl == null) {
            return null;
        }
        HashMap<String, Object> aclMap = new HashMap<String, Object>();
        while (acl.hasNext()) {
            ACLEntry next = acl.next();
            aclMap.put(next.getEntity(), policy.translatePermissions(next.getRights()));
        }
        return aclMap;
    }

    public static ACLEntry[] mapToACL(StorageManager sMan, long fileId, Map<String, Object> aclMap) {
        if (aclMap == null) {
            return null;
        }
        ACLEntry[] acl = new ACLEntry[aclMap.size()];
        Iterator<Map.Entry<String, Object>> entries = aclMap.entrySet().iterator();
        for (int i = 0; i < acl.length; ++i) {
            assert (entries.hasNext());
            Map.Entry<String, Object> entry = entries.next();
            acl[i] = sMan.createACLEntry(fileId, entry.getKey(), ((Long)entry.getValue()).shortValue());
        }
        Arrays.sort(acl, new Comparator<ACLEntry>(){

            @Override
            public int compare(ACLEntry o1, ACLEntry o2) {
                return o1.getEntity().compareTo(o2.getEntity());
            }
        });
        return acl;
    }

    public static String xLocListToString(XLocList xLocList) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < xLocList.getReplicaCount(); ++i) {
            sb.append("[<");
            XLoc repl = xLocList.getReplica(i);
            StripingPolicy sp = repl.getStripingPolicy();
            sb.append(Converter.stripingPolicyToString(sp)).append(">, (");
            for (int j = 0; j < repl.getOSDCount(); ++j) {
                sb.append(repl.getOSD(j)).append(j == repl.getOSDCount() - 1 ? "" : ", ");
            }
            sb.append(")]").append(i == xLocList.getReplicaCount() - 1 ? "" : ", ");
        }
        sb.append(", ").append(xLocList.getVersion()).append(", ").append(xLocList.getReplUpdatePolicy()).append("]");
        return sb.toString();
    }

    public static String xLocListToJSON(XLocList xLocList, OSDStatusManager osdMan) throws JSONException, UnknownUUIDException {
        HashMap<String, Object> list = new HashMap<String, Object>();
        list.put("update-policy", xLocList.getReplUpdatePolicy());
        list.put("version", Long.valueOf(xLocList.getVersion()));
        ArrayList replicas = new ArrayList(xLocList.getReplicaCount());
        Iterator<XLoc> iter = xLocList.iterator();
        while (iter.hasNext()) {
            XLoc l = iter.next();
            HashMap<String, Object> replica = new HashMap<String, Object>();
            replica.put("striping-policy", Converter.getStripingPolicyAsJSON(l.getStripingPolicy()));
            replica.put("replication-flags", l.getReplicationFlags());
            ArrayList osds = new ArrayList(l.getOSDCount());
            for (int i = 0; i < l.getOSDCount(); ++i) {
                HashMap<String, String> osd = new HashMap<String, String>();
                ServiceUUID uuid = new ServiceUUID(l.getOSD(i));
                DIR.Service osdData = osdMan.getOSDService(uuid.toString());
                String coords = osdData == null ? "" : KeyValuePairs.getValue(osdData.getData().getDataList(), "vivaldi_coordinates");
                osd.put("uuid", uuid.toString());
                osd.put("vivaldi_coordinates", coords);
                osd.put("address", uuid.getAddressString());
                osds.add(osd);
            }
            replica.put("osds", osds);
            replicas.add(replica);
        }
        list.put("replicas", replicas);
        return JSONParser.writeJSON(list);
    }

    public static XLocList xLocSetToXLocList(StorageManager sMan, GlobalTypes.XLocSet.Builder xLocSet) {
        XLoc[] replicas = new XLoc[xLocSet.getReplicasCount()];
        for (int i = 0; i < xLocSet.getReplicasCount(); ++i) {
            GlobalTypes.Replica repl = xLocSet.getReplicas(i);
            GlobalTypes.StripingPolicy sp = repl.getStripingPolicy();
            replicas[i] = sMan.createXLoc(sMan.createStripingPolicy(sp.getType().toString(), sp.getStripeSize(), sp.getWidth()), repl.getOsdUuidsList().toArray(new String[repl.getOsdUuidsList().size()]), repl.getReplicationFlags());
        }
        return sMan.createXLocList(replicas, xLocSet.getReplicaUpdatePolicy(), xLocSet.getVersion());
    }

    public static GlobalTypes.XLocSet.Builder xLocListToXLocSet(XLocList xLocList) {
        if (xLocList == null) {
            return null;
        }
        GlobalTypes.XLocSet.Builder xLocSetBuilder = GlobalTypes.XLocSet.newBuilder().setReplicaUpdatePolicy(xLocList.getReplUpdatePolicy()).setVersion(xLocList.getVersion()).setReadOnlyFileSize(0L);
        for (int i = 0; i < xLocList.getReplicaCount(); ++i) {
            XLoc xRepl = xLocList.getReplica(i);
            StripingPolicy xSP = xRepl.getStripingPolicy();
            GlobalTypes.StripingPolicy.Builder sp = GlobalTypes.StripingPolicy.newBuilder().setType(GlobalTypes.StripingPolicyType.valueOf(xSP.getPattern())).setStripeSize(xSP.getStripeSize()).setWidth(xSP.getWidth());
            GlobalTypes.Replica.Builder replBuilder = GlobalTypes.Replica.newBuilder().setReplicationFlags(xRepl.getReplicationFlags()).setStripingPolicy(sp);
            for (int j = 0; j < xRepl.getOSDCount(); ++j) {
                replBuilder.addOsdUuids(xRepl.getOSD(j));
            }
            xLocSetBuilder.addReplicas(replBuilder);
        }
        return xLocSetBuilder;
    }

    public static StripingPolicy stringToStripingPolicy(StorageManager sMan, String spString) {
        StringTokenizer st = new StringTokenizer(spString, " ,\t");
        String policy = st.nextToken();
        if (policy.equals("RAID0")) {
            policy = GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0.toString();
        }
        int size = Integer.parseInt(st.nextToken());
        int width = Integer.parseInt(st.nextToken());
        return sMan.createStripingPolicy(policy, size, width);
    }

    public static GlobalTypes.StripingPolicy jsonStringToStripingPolicy(String spString) throws JSONException {
        Map spMap = (Map)JSONParser.parseJSON(new JSONString(spString));
        if (spMap == null || spMap.isEmpty()) {
            return null;
        }
        String pattern = (String)spMap.get("pattern");
        long size = (Long)spMap.get("size");
        long width = (Long)spMap.get("width");
        return GlobalTypes.StripingPolicy.newBuilder().setType(GlobalTypes.StripingPolicyType.valueOf(pattern)).setStripeSize((int)size).setWidth((int)width).build();
    }

    public static String stripingPolicyToString(StripingPolicy sp) {
        return sp.getPattern() + ", " + sp.getStripeSize() + ", " + sp.getWidth();
    }

    public static String stripingPolicyToString(GlobalTypes.StripingPolicy sp) {
        return sp.getType().toString() + ", " + sp.getStripeSize() + ", " + sp.getWidth();
    }

    public static GlobalTypes.StripingPolicy.Builder stripingPolicyToStripingPolicy(StripingPolicy sp) {
        return GlobalTypes.StripingPolicy.newBuilder().setType(GlobalTypes.StripingPolicyType.valueOf(sp.getPattern())).setStripeSize(sp.getStripeSize()).setWidth(sp.getWidth());
    }

    public static String stripingPolicyToJSONString(StripingPolicy sp) throws JSONException {
        return JSONParser.writeJSON(Converter.getStripingPolicyAsJSON(sp));
    }

    static GlobalTypes.Replica.Builder replicaFromJSON(String value) throws JSONException {
        Map jsonObj = (Map)JSONParser.parseJSON(new JSONString(value));
        long rf = (Long)jsonObj.get("replication-flags");
        Map jsonSP = (Map)jsonObj.get("striping-policy");
        String spName = (String)jsonSP.get("pattern");
        GlobalTypes.StripingPolicyType spType = GlobalTypes.StripingPolicyType.STRIPING_POLICY_RAID0;
        long width = (Long)jsonSP.get("width");
        long size = (Long)jsonSP.get("size");
        GlobalTypes.StripingPolicy.Builder sp = GlobalTypes.StripingPolicy.newBuilder().setType(spType).setStripeSize((int)size).setWidth((int)width);
        List osds = (List)jsonObj.get("osds");
        GlobalTypes.Replica.Builder builder = GlobalTypes.Replica.newBuilder();
        for (String osd : osds) {
            builder.addOsdUuids(osd);
        }
        return builder;
    }

    private static Map<String, Object> getStripingPolicyAsJSON(StripingPolicy sp) {
        HashMap<String, Object> spMap = new HashMap<String, Object>();
        spMap.put("pattern", sp.getPattern());
        spMap.put("size", sp.getStripeSize());
        spMap.put("width", sp.getWidth());
        return spMap;
    }

    public static List<String> stringArrayToList(String[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (String s : array) {
            list.add(s);
        }
        return list;
    }

    public static List<XAttr> attrMapsToAttrList(StorageManager sMan, long fileId, List<Map<String, Object>> mappedData) {
        LinkedList<XAttr> list = new LinkedList<XAttr>();
        for (Map<String, Object> attr : mappedData) {
            list.add(sMan.createXAttr(fileId, (String)attr.get("userId"), (String)attr.get("key"), (byte[])attr.get("value")));
        }
        return list;
    }

    public static short[] stringToShortArray(String shortList) {
        StringTokenizer st = new StringTokenizer(shortList, " \t,;");
        short[] result = new short[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i] = Short.parseShort(st.nextToken());
            ++i;
        }
        return result;
    }

    public static String shortArrayToString(short[] shorts) {
        String result = "";
        for (int i = 0; i < shorts.length; ++i) {
            result = result + shorts[i];
            if (i >= shorts.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public static String replicationPolicyToString(ReplicationPolicy rp) {
        return rp.getName() + ", " + rp.getFactor() + ", " + rp.getFlags();
    }

    public static ReplicationPolicy stringToReplicationPolicy(StorageManager sMan, String rpString) {
        StringTokenizer st = new StringTokenizer(rpString, " ,\t");
        final String policy = rpString.startsWith(",") ? "" : st.nextToken();
        final int numRepls = Integer.parseInt(st.nextToken());
        final int flags = Integer.parseInt(st.nextToken());
        return new ReplicationPolicy(){

            @Override
            public String getName() {
                return policy;
            }

            @Override
            public int getFactor() {
                return numRepls;
            }

            @Override
            public int getFlags() {
                return flags;
            }
        };
    }

    public static ReplicationPolicy jsonStringToReplicationPolicy(String rpString) throws JSONException {
        Map rpMap = (Map)JSONParser.parseJSON(new JSONString(rpString));
        if (rpMap == null || rpMap.isEmpty()) {
            return null;
        }
        final String name = (String)rpMap.get("update-policy");
        if (name == null) {
            return null;
        }
        Long factor = (Long)rpMap.get("replication-factor");
        final int numRepls = factor == null ? 1 : factor.intValue();
        Long flags = (Long)rpMap.get("replication-flags");
        final int replFlags = flags == null ? 0 : flags.intValue();
        return new ReplicationPolicy(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getFactor() {
                return numRepls;
            }

            @Override
            public int getFlags() {
                return replFlags;
            }
        };
    }

    public static String replicationPolicyToJSONString(ReplicationPolicy rp) throws JSONException {
        return JSONParser.writeJSON(Converter.getReplicationPolicyAsJSON(rp));
    }

    private static Map<String, Object> getReplicationPolicyAsJSON(ReplicationPolicy rp) {
        HashMap<String, Object> rpMap = new HashMap<String, Object>();
        rpMap.put("update-policy", rp.getName());
        rpMap.put("replication-factor", rp.getFactor());
        rpMap.put("replication-flags", rp.getFlags());
        return rpMap;
    }
}

