/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.utils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.common.xloc.ReplicationFlags;
import org.xtreemfs.foundation.json.JSONException;
import org.xtreemfs.foundation.json.JSONParser;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.mrc.MRCConfig;
import org.xtreemfs.mrc.MRCException;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.ac.FileAccessManager;
import org.xtreemfs.mrc.database.AtomicDBUpdate;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.DatabaseResultSet;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.database.VolumeInfo;
import org.xtreemfs.mrc.database.VolumeManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.metadata.ReplicationPolicy;
import org.xtreemfs.mrc.metadata.StripingPolicy;
import org.xtreemfs.mrc.metadata.XAttr;
import org.xtreemfs.mrc.metadata.XLoc;
import org.xtreemfs.mrc.metadata.XLocList;
import org.xtreemfs.mrc.osdselection.OSDStatusManager;
import org.xtreemfs.mrc.utils.Converter;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;

public class MRCHelper {
    public static final String POLICY_ATTR_PREFIX = "policies";
    public static final String VOL_ATTR_PREFIX = "volattr";
    public static final String XTREEMFS_POLICY_ATTR_PREFIX = "xtreemfs.policies.";

    public static String createGlobalFileId(VolumeInfo volume, FileMetadata file) {
        return volume.getId() + ":" + file.getId();
    }

    public static DIR.Service createDSVolumeInfo(VolumeInfo vol, OSDStatusManager osdMan, StorageManager sMan, String mrcUUID) {
        String free = String.valueOf(osdMan.getFreeSpace(vol.getId()));
        String volSize = null;
        try {
            volSize = String.valueOf(sMan.getVolumeInfo().getVolumeSize());
            try {
                long quota = vol.getVolumeQuota();
                long quotaFreeSpace = quota - vol.getVolumeSize();
                if (quota != 0L && quotaFreeSpace < Long.valueOf(free)) {
                    quotaFreeSpace = quotaFreeSpace < 0L ? 0L : quotaFreeSpace;
                    free = String.valueOf(quotaFreeSpace);
                }
            }
            catch (DatabaseException e) {
                Logging.logMessage(4, Logging.Category.storage, null, "could not retrieve volume quota from database for volume '%s': %s", vol.getName(), e.toString());
            }
        }
        catch (DatabaseException e) {
            Logging.logMessage(4, Logging.Category.storage, null, "could not retrieve volume size from database for volume '%s': %s", vol.getName(), e.toString());
        }
        DIR.ServiceDataMap.Builder dmap = MRCHelper.buildServiceDataMap("mrc", mrcUUID, "free", free, "used", volSize);
        try {
            DatabaseResultSet<XAttr> attrIt = sMan.getXAttrs(1L, "");
            while (attrIt.hasNext()) {
                XAttr attr = (XAttr)attrIt.next();
                if (!attr.getKey().startsWith("xtreemfs.volattr.")) continue;
                byte[] value = attr.getValue();
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("attr." + attr.getKey().substring("xtreemfs.volattr.".length())).setValue(value == null ? null : new String(value)));
            }
            attrIt.destroy();
        }
        catch (DatabaseException e) {
            Logging.logMessage(3, Logging.Category.storage, null, OutputUtils.stackTraceToString(e), new Object[0]);
        }
        DIR.Service sreg = DIR.Service.newBuilder().setType(DIR.ServiceType.SERVICE_TYPE_VOLUME).setUuid(vol.getId()).setVersion(0L).setName(vol.getName()).setData(dmap).setLastUpdatedS(0L).build();
        return sreg;
    }

    public static int updateFileTimes(long parentId, FileMetadata file, boolean setATime, boolean setCTime, boolean setMTime, StorageManager sMan, int currentTime, AtomicDBUpdate update) throws DatabaseException {
        if (parentId == -1L) {
            return -1;
        }
        if (setATime) {
            file.setAtime(currentTime);
        }
        if (setCTime) {
            file.setCtime(currentTime);
        }
        if (setMTime) {
            file.setMtime(currentTime);
        }
        sMan.setMetadata(file, (byte)0, update);
        return currentTime;
    }

    public static XLoc createReplica(StripingPolicy stripingPolicy, StorageManager sMan, OSDStatusManager osdMan, VolumeInfo volume, long parentDirId, String path, InetAddress clientAddress, GlobalTypes.VivaldiCoordinates clientCoordinates, XLocList currentXLoc, int replFlags) throws DatabaseException, UserException, MRCException {
        if (stripingPolicy == null) {
            stripingPolicy = sMan.getDefaultStripingPolicy(parentDirId);
        }
        if (stripingPolicy == null) {
            stripingPolicy = sMan.getDefaultStripingPolicy(1L);
        }
        if (stripingPolicy == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EIO, "could not open file " + path + ": no default striping policy available");
        }
        DIR.ServiceSet.Builder usableOSDs = osdMan.getUsableOSDs(volume.getId(), clientAddress, clientCoordinates, currentXLoc, stripingPolicy.getWidth());
        if (usableOSDs == null || usableOSDs.getServicesCount() == 0) {
            Logging.logMessage(4, Logging.Category.all, (Object)null, "no suitable OSDs available for file %s", path);
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EIO, "could not assign OSDs to file " + path + ": no feasible OSDs available");
        }
        int width = Math.min(stripingPolicy.getWidth(), usableOSDs.getServicesCount());
        List<DIR.Service> osdServices = usableOSDs.getServicesList();
        String[] osds = new String[width];
        for (int i = 0; i < width; ++i) {
            osds[i] = osdServices.get(i).getUuid();
        }
        if (width != stripingPolicy.getWidth()) {
            stripingPolicy = sMan.createStripingPolicy(stripingPolicy.getPattern(), stripingPolicy.getStripeSize(), width);
        }
        return sMan.createXLoc(stripingPolicy, osds, replFlags);
    }

    public static boolean isAddable(XLocList xLocList, List<String> newOSDs) {
        if (xLocList != null) {
            for (int i = 0; i < xLocList.getReplicaCount(); ++i) {
                XLoc replica = xLocList.getReplica(i);
                for (int j = 0; j < replica.getOSDCount(); ++j) {
                    for (String newOsd : newOSDs) {
                        if (!replica.getOSD(j).equals(newOsd)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static boolean isResolvable(List<String> newOSDs) {
        if (newOSDs != null) {
            for (String osd : newOSDs) {
                try {
                    new ServiceUUID(osd).getAddress();
                }
                catch (Exception exc) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isConsistent(XLocList xLocList) {
        HashSet<String> tmp = new HashSet<String>();
        if (xLocList != null) {
            for (int i = 0; i < xLocList.getReplicaCount(); ++i) {
                XLoc replica = xLocList.getReplica(i);
                for (int j = 0; j < replica.getOSDCount(); ++j) {
                    String osd = replica.getOSD(j);
                    if (tmp.contains(osd)) {
                        return false;
                    }
                    tmp.add(osd);
                }
            }
        }
        return true;
    }

    public static String getSysAttrValue(MRCConfig config, StorageManager sMan, OSDStatusManager osdMan, FileAccessManager faMan, String path, FileMetadata file, String keyString) throws DatabaseException, UserException, JSONException {
        if (keyString.startsWith("policies.")) {
            return MRCHelper.getPolicyValue(sMan, keyString);
        }
        if (keyString.startsWith("volattr.")) {
            return MRCHelper.getVolAttrValue(sMan, keyString);
        }
        SysAttrs key = null;
        try {
            key = SysAttrs.valueOf(keyString);
        }
        catch (IllegalArgumentException exc) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "unknown system attribute '" + keyString + "'");
        }
        if (key != null) {
            switch (key) {
                case locations: {
                    if (file.isDirectory()) {
                        return "";
                    }
                    XLocList xLocList = file.getXLocList();
                    try {
                        return xLocList == null ? "" : Converter.xLocListToJSON(xLocList, osdMan);
                    }
                    catch (UnknownUUIDException exc) {
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EIO, "cannot retrieve '" + SysAttrs.locations.name() + "' attribute value: " + exc);
                    }
                }
                case file_id: {
                    return MRCHelper.createGlobalFileId(sMan.getVolumeInfo(), file);
                }
                case object_type: {
                    String ref = sMan.getSoftlinkTarget(file.getId());
                    return ref != null ? "3" : (file.isDirectory() ? "2" : "1");
                }
                case url: {
                    InetSocketAddress addr = config.getDirectoryService();
                    return config.getURLScheme() + "://" + addr.getHostName() + ":" + addr.getPort() + "/" + path;
                }
                case owner: {
                    return file.getOwnerId();
                }
                case group: {
                    return file.getOwningGroupId();
                }
                case default_sp: {
                    if (!file.isDirectory()) {
                        return "";
                    }
                    StripingPolicy sp = sMan.getDefaultStripingPolicy(file.getId());
                    if (sp == null) {
                        return "";
                    }
                    return Converter.stripingPolicyToJSONString(sp);
                }
                case ac_policy_id: {
                    return file.getId() == 1L ? sMan.getVolumeInfo().getAcPolicyId() + "" : "";
                }
                case osel_policy: {
                    return file.getId() == 1L ? Converter.shortArrayToString(sMan.getVolumeInfo().getOsdPolicy()) : "";
                }
                case rsel_policy: {
                    return file.getId() == 1L ? Converter.shortArrayToString(sMan.getVolumeInfo().getReplicaPolicy()) : "";
                }
                case read_only: {
                    if (file.isDirectory()) {
                        return "";
                    }
                    return String.valueOf(file.isReadOnly());
                }
                case usable_osds: {
                    if (file.getId() != 1L) {
                        return "";
                    }
                    try {
                        DIR.ServiceSet.Builder srvs = osdMan.getUsableOSDs(sMan.getVolumeInfo().getId());
                        HashMap<String, String> osds = new HashMap<String, String>();
                        for (DIR.Service srv : srvs.getServicesList()) {
                            ServiceUUID uuid = new ServiceUUID(srv.getUuid());
                            osds.put(uuid.toString(), uuid.getAddressString());
                        }
                        return JSONParser.writeJSON(osds);
                    }
                    catch (UnknownUUIDException exc) {
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EIO, "cannot retrieve '" + SysAttrs.usable_osds.name() + "' attribute value: " + exc);
                    }
                }
                case free_space: {
                    return file.getId() == 1L ? String.valueOf(osdMan.getFreeSpace(sMan.getVolumeInfo().getId())) : "";
                }
                case used_space: {
                    return file.getId() == 1L ? String.valueOf(sMan.getVolumeInfo().getVolumeSize()) : "";
                }
                case num_files: {
                    return file.getId() == 1L ? String.valueOf(sMan.getVolumeInfo().getNumFiles()) : "";
                }
                case num_dirs: {
                    return file.getId() == 1L ? String.valueOf(sMan.getVolumeInfo().getNumDirs()) : "";
                }
                case snapshots: {
                    if (file.getId() != 1L || sMan.getVolumeInfo().isSnapVolume()) {
                        return "";
                    }
                    Object[] snaps = sMan.getAllSnapshots();
                    Arrays.sort(snaps);
                    ArrayList<Object> snapshots = new ArrayList<Object>(snaps.length);
                    for (Object snap : snaps) {
                        if (((String)snap).equals(".dump")) continue;
                        snapshots.add(snap);
                    }
                    return JSONParser.writeJSON(snapshots);
                }
                case snapshots_enabled: {
                    return file.getId() == 1L && !sMan.getVolumeInfo().isSnapVolume() ? String.valueOf(sMan.getVolumeInfo().isSnapshotsEnabled()) : "";
                }
                case snapshot_time: {
                    return file.getId() == 1L && sMan.getVolumeInfo().isSnapVolume() ? Long.toString(sMan.getVolumeInfo().getCreationTime()) : "";
                }
                case acl: {
                    Map<String, Object> acl;
                    try {
                        acl = faMan.getACLEntries(sMan, file);
                    }
                    catch (MRCException e) {
                        Logging.logError(3, null, e);
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL);
                    }
                    if (acl != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        for (Map.Entry<String, Object> entry : acl.entrySet()) {
                            map.put(entry.getKey(), "" + entry.getValue());
                        }
                        return JSONParser.writeJSON(map);
                    }
                }
                case default_rp: {
                    if (!file.isDirectory()) {
                        return "";
                    }
                    ReplicationPolicy rp = sMan.getDefaultReplicationPolicy(file.getId());
                    if (rp == null) {
                        return "";
                    }
                    return Converter.replicationPolicyToJSONString(rp);
                }
                case quota: {
                    return String.valueOf(sMan.getVolumeInfo().getVolumeQuota());
                }
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSysAttrValue(StorageManager sMan, VolumeManager vMan, FileAccessManager faMan, long parentId, FileMetadata file, String keyString, String value, AtomicDBUpdate update) throws UserException, DatabaseException {
        if (keyString.startsWith(POLICY_ATTR_PREFIX.toString() + ".")) {
            MRCHelper.setPolicyValue(sMan, keyString, value, update);
            return;
        }
        SysAttrs key = null;
        try {
            key = SysAttrs.valueOf(keyString);
        }
        catch (IllegalArgumentException exc) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "unknown system attribute '" + keyString + "'");
        }
        switch (key) {
            case default_sp: {
                if (!file.isDirectory()) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "default striping policies can only be set on volumes and directories");
                }
                try {
                    GlobalTypes.StripingPolicy sp = null;
                    sp = Converter.jsonStringToStripingPolicy(value);
                    if (file.getId() == 1L && sp == null) {
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "cannot remove the volume's default striping policy");
                    }
                    ReplicationPolicy replPolicy = sMan.getDefaultReplicationPolicy(file.getId());
                    if (sp != null && sp.getWidth() > 1 && replPolicy != null && (replPolicy.getName().equals("WaR1") || replPolicy.getName().equals("WqRq"))) {
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Striping of rw-replicated Files is not supported yet.");
                    }
                    sMan.setDefaultStripingPolicy(file.getId(), sp, update);
                    return;
                }
                catch (JSONException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid default striping policy: " + value);
                }
                catch (ClassCastException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid default striping policy: " + value);
                }
                catch (NullPointerException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid default striping policy: " + value);
                }
                catch (IllegalArgumentException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid default striping policy: " + value);
                }
            }
            case osel_policy: {
                if (file.getId() != 1L) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "OSD selection policies can only be set on volumes");
                }
                try {
                    short[] newPol = Converter.stringToShortArray(value);
                    sMan.getVolumeInfo().setOsdPolicy(newPol, update);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid OSD selection policy: " + value);
                }
            }
            case rsel_policy: {
                if (file.getId() != 1L) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "replica selection policies can only be set and configured on volumes");
                }
                try {
                    short[] newPol = Converter.stringToShortArray(value);
                    sMan.getVolumeInfo().setReplicaPolicy(newPol, update);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid replica selection policy: " + value);
                }
            }
            case read_only: {
                if (file.isDirectory()) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "only files can be made read-only");
                }
                boolean readOnly = Boolean.valueOf(value);
                if (!readOnly && file.getXLocList() != null && file.getXLocList().getReplicaCount() > 1) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "read-only flag cannot be removed from files with multiple replicas");
                }
                if (file.getXLocList() != null) {
                    XLocList xLoc = file.getXLocList();
                    XLoc[] replicas = new XLoc[xLoc.getReplicaCount()];
                    for (int i = 0; i < replicas.length; ++i) {
                        replicas[i] = xLoc.getReplica(i);
                    }
                    replicas[0].setReplicationFlags(ReplicationFlags.setFullReplica(ReplicationFlags.setReplicaIsComplete(replicas[0].getReplicationFlags())));
                    XLocList newXLoc = sMan.createXLocList(replicas, readOnly ? "ronly" : "", xLoc.getVersion() + 1);
                    file.setXLocList(newXLoc);
                    sMan.setMetadata(file, (byte)1, update);
                }
                file.setReadOnly(readOnly);
                sMan.setMetadata(file, (byte)1, update);
                return;
            }
            case snapshots: {
                if (!file.isDirectory()) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOTDIR, "snapshots of single files are not allowed so far");
                }
                int index = value.indexOf(" ");
                String command = null;
                String name = null;
                try {
                    command = value.substring(0, index);
                    name = value.substring(index + 1);
                }
                catch (Exception exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "malformed snapshot configuration");
                }
                if (command.charAt(0) == 'c') {
                    vMan.createSnapshot(sMan.getVolumeInfo().getId(), name, parentId, file, command.equals("cr"));
                    return;
                }
                if (!command.equals("d")) throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid snapshot command: " + value);
                vMan.deleteSnapshot(sMan.getVolumeInfo().getId(), file, name);
                return;
            }
            case snapshots_enabled: {
                if (file.getId() != 1L) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "snapshots can only be enabled or disabled on volumes");
                }
                boolean enable = Boolean.parseBoolean(value);
                sMan.getVolumeInfo().setAllowSnaps(enable, update);
                return;
            }
            case mark_replica_complete: {
                if (file.isDirectory()) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EISDIR, "file required");
                }
                XLocList xlocs = file.getXLocList();
                XLoc[] xlocArray = new XLoc[xlocs.getReplicaCount()];
                Iterator<XLoc> it = xlocs.iterator();
                int i = 0;
                while (it.hasNext()) {
                    XLoc xloc = it.next();
                    if (value.equals(xloc.getOSD(0))) {
                        xloc.setReplicationFlags(ReplicationFlags.setReplicaIsComplete(xloc.getReplicationFlags()));
                    }
                    xlocArray[i] = xloc;
                    ++i;
                }
                XLocList newXLocList = sMan.createXLocList(xlocArray, xlocs.getReplUpdatePolicy(), xlocs.getVersion());
                file.setXLocList(newXLocList);
                sMan.setMetadata(file, (byte)1, update);
                return;
            }
            case acl: {
                int index = value.indexOf(" ");
                try {
                    String command = value.substring(0, index);
                    String params = value.substring(index + 1);
                    if (command.equals("m")) {
                        int index2 = params.lastIndexOf(58);
                        String entity = params.substring(0, index2);
                        String rights = params.substring(index2 + 1);
                        HashMap<String, Object> entries = new HashMap<String, Object>();
                        entries.put(entity, rights);
                        faMan.updateACLEntries(sMan, file, parentId, entries, update);
                        return;
                    }
                    if (!command.equals("x")) throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid ACL modification command: " + command);
                    ArrayList<Object> entries = new ArrayList<Object>(1);
                    entries.add(params);
                    faMan.removeACLEntries(sMan, file, parentId, entries, update);
                    return;
                }
                catch (MRCException e) {
                    Logging.logError(3, null, e);
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL);
                }
                catch (Exception exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "malformed ACL modification request");
                }
            }
            case set_repl_update_policy: {
                StripingPolicy stripingPolicy;
                if (file.isDirectory()) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EISDIR, "file required");
                }
                XLocList xlocs = file.getXLocList();
                XLoc[] xlocArray = new XLoc[xlocs.getReplicaCount()];
                Iterator<XLoc> it = xlocs.iterator();
                int i = 0;
                while (it.hasNext()) {
                    xlocArray[i] = it.next();
                    ++i;
                }
                String replUpdatePolicy = xlocs.getReplUpdatePolicy();
                if (!("WqRq".equals(value) || "WaR1".equals(value) || "".equals(value) || "ronly".equals(value))) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Invalid replica update policy: " + value);
                }
                if ("WaRa".equals(value)) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Do no longer use the policy WaRa. Instead you're probably looking for the WaR1 policy (write all replicas, read from one)." + value);
                }
                if ("ronly".equals(replUpdatePolicy) && xlocArray.length > 1) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "changing replica update policies of read-only-replicated files is not allowed");
                }
                if ("".equals(value) && xlocs.getReplicaCount() > 1) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "number of replicas has to be reduced to 1 before replica update policy can be set to  (current replica count = " + xlocs.getReplicaCount() + ")");
                }
                if ("ronly".equals(replUpdatePolicy) && ("WqRq".equals(value) || "WaR1".equals(value)) || "ronly".equals(value) && ("WqRq".equals(replUpdatePolicy) || "WaR1".equals(replUpdatePolicy))) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "Currently, it is not possible to change from a read-only to a read/write replication policy or vise versa.");
                }
                XLocList newXLocList = sMan.createXLocList(xlocArray, value, xlocs.getVersion() + 1);
                if ("ronly".equals(value)) {
                    newXLocList.getReplica(0).setReplicationFlags(ReplicationFlags.setFullReplica(ReplicationFlags.setReplicaIsComplete(newXLocList.getReplica(0).getReplicationFlags())));
                    file.setReadOnly(true);
                }
                if ((stripingPolicy = file.getXLocList().getReplica(0).getStripingPolicy()).getWidth() > 1 && (value.equals("WaR1") || value.equals("WqRq"))) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "RW-replication of striped files is not supported yet.");
                }
                if ("ronly".equals(replUpdatePolicy) && "".equals(value)) {
                    file.setReadOnly(false);
                }
                file.setXLocList(newXLocList);
                sMan.setMetadata(file, (byte)1, update);
                return;
            }
            case default_rp: {
                if (!file.isDirectory()) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "default replication policies can only be set on volumes and directories");
                }
                try {
                    ReplicationPolicy rp = null;
                    rp = Converter.jsonStringToReplicationPolicy(value);
                    if (rp.getFactor() == 1 && !"".equals(rp.getName())) {
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "a default replication policy requires a replication factor >= 2");
                    }
                    if (sMan.getDefaultStripingPolicy(file.getId()).getWidth() > 1 && (rp.getName().equals("WaR1") || rp.getName().equals("WqRq"))) {
                        throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "RW-replication of striped files is not supported yet.");
                    }
                    sMan.setDefaultReplicationPolicy(file.getId(), rp, update);
                    return;
                }
                catch (JSONException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid default replication policy: " + value);
                }
                catch (ClassCastException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid default replication policy: " + value);
                }
                catch (NullPointerException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid default replication policy: " + value);
                }
                catch (IllegalArgumentException exc) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid default replication policy: " + value);
                }
            }
            case quota: {
                if (file.getId() != 1L) {
                    throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "quota must be set on volume root");
                }
                sMan.getVolumeInfo().setVolumeQuota(Long.valueOf(value), update);
                return;
            }
            default: {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "system attribute '" + keyString + "' is immutable");
            }
        }
    }

    public static List<String> getSpecialAttrNames(StorageManager sMan, String namePrefix) throws DatabaseException {
        String prefix = "xtreemfs." + namePrefix;
        LinkedList<String> result = new LinkedList<String>();
        DatabaseResultSet<XAttr> it = sMan.getXAttrs(1L, "");
        while (it.hasNext()) {
            XAttr attr = (XAttr)it.next();
            if (!attr.getKey().startsWith(prefix)) continue;
            result.add(attr.getKey());
        }
        it.destroy();
        return result;
    }

    public static DIR.ServiceDataMap.Builder buildServiceDataMap(String ... kvPairs) {
        assert (kvPairs.length % 2 == 0);
        DIR.ServiceDataMap.Builder builder = DIR.ServiceDataMap.newBuilder();
        for (int i = 0; i < kvPairs.length; i += 2) {
            GlobalTypes.KeyValuePair.Builder kvp = GlobalTypes.KeyValuePair.newBuilder();
            kvp.setKey(kvPairs[i]);
            kvp.setValue(kvPairs[i + 1]);
            builder.addData(kvp);
        }
        return builder;
    }

    private static String getPolicyValue(StorageManager sMan, String keyString) throws DatabaseException {
        byte[] value = sMan.getXAttr(1L, "", "xtreemfs." + keyString);
        return value == null ? null : new String(value);
    }

    private static String getVolAttrValue(StorageManager sMan, String keyString) throws DatabaseException {
        byte[] value = sMan.getXAttr(1L, "", "xtreemfs." + keyString);
        return value == null ? null : new String(value);
    }

    private static void setPolicyValue(StorageManager sMan, String keyString, String value, AtomicDBUpdate update) throws DatabaseException, UserException {
        String checkString = keyString.substring(POLICY_ATTR_PREFIX.length() + 1);
        int index = checkString.indexOf(46);
        if (index <= 0) {
            if (keyString.startsWith(".")) {
                keyString = keyString.substring(1);
            }
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EPERM, "'" + keyString + "=" + value + " :' " + "XtreemFS no longer supports global policy attributes. " + "It is necessary to specify a policy e.g., '1000." + keyString + "=" + value + "'");
        }
        byte[] bytes = value.getBytes();
        sMan.setXAttr(1L, "", "xtreemfs." + keyString, bytes == null || bytes.length == 0 ? null : bytes, update);
    }

    public static enum FileType {
        nexists,
        dir,
        file;

    }

    public static enum SysAttrs {
        locations,
        file_id,
        object_type,
        url,
        owner,
        group,
        default_sp,
        ac_policy_id,
        rsel_policy,
        osel_policy,
        usable_osds,
        free_space,
        used_space,
        num_files,
        num_dirs,
        snapshots,
        snapshots_enabled,
        snapshot_time,
        acl,
        read_only,
        mark_replica_complete,
        set_repl_update_policy,
        default_rp,
        quota;

    }

    public static class GlobalFileIdResolver {
        final String volumeId;
        final long localFileId;

        public GlobalFileIdResolver(String globalFileId) throws UserException {
            try {
                int i = globalFileId.indexOf(58);
                this.volumeId = globalFileId.substring(0, i);
                this.localFileId = Long.parseLong(globalFileId.substring(i + 1));
            }
            catch (Exception exc) {
                throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EINVAL, "invalid global file ID: " + globalFileId + "; expected pattern: <volume_ID>:<local_file_ID>");
            }
        }

        public String getVolumeId() {
            return this.volumeId;
        }

        public long getLocalFileId() {
            return this.localFileId;
        }
    }
}

