/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.utils;

import java.util.ArrayList;
import java.util.List;

public class Path {
    private static final char SEPARATOR = '/';
    private String path;
    private List<Integer> compIndices;

    public Path(String volumeName, String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            this.parsePath(volumeName + path);
        } else {
            this.parsePath(volumeName + "/" + path);
        }
    }

    public Path(String path) {
        this.parsePath(path);
    }

    private void parsePath(String path) {
        if (path.length() == 0) {
            this.path = "";
            this.compIndices = new ArrayList<Integer>(15);
            this.compIndices.add(-1);
        } else {
            while (path.contains("//")) {
                path = path.replace("//", "/");
            }
            this.path = path.charAt(path.length() - 1) == '/' ? path.substring(0, path.length() - 1) : path;
            this.compIndices = new ArrayList<Integer>(15);
            this.compIndices.add(-1);
            char[] chars = this.path.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != '/') continue;
                this.compIndices.add(i);
            }
        }
    }

    public Path(String[] comps) {
        this.compIndices = new ArrayList<Integer>(15);
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (String comp : comps) {
            this.compIndices.add(index);
            index += comp.length() + 1;
            sb.append("/" + comp);
        }
        this.path = sb.toString();
    }

    public String getComp(int index) {
        if (index >= this.compIndices.size()) {
            return null;
        }
        return this.path.substring(this.compIndices.get(index) + 1, index == this.compIndices.size() - 1 ? this.path.length() : this.compIndices.get(index + 1).intValue());
    }

    public String getLastComp(int index) {
        if (index >= this.compIndices.size()) {
            return null;
        }
        return this.path.substring(this.compIndices.get(this.compIndices.size() - 1 - index) + 1, index == 0 ? this.path.length() : this.compIndices.get(this.compIndices.size() - index).intValue());
    }

    public String getComps(int startIndex, int endIndex) {
        if (endIndex < startIndex) {
            return "";
        }
        if (startIndex >= this.compIndices.size()) {
            startIndex = this.compIndices.size() - 1;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        return this.path.substring(this.compIndices.get(startIndex) + 1, endIndex == this.compIndices.size() - 1 ? this.path.length() : this.compIndices.get(endIndex + 1).intValue());
    }

    public boolean equals(Path p) {
        return this.path.equals(p.path);
    }

    public int getCompCount() {
        return this.compIndices.size();
    }

    public boolean isSubDirOf(Path p) {
        return this.path.startsWith(p.path + "/");
    }

    public String toString() {
        return this.path;
    }
}

