/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.mrc.utils;

import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.mrc.UserException;
import org.xtreemfs.mrc.database.DatabaseException;
import org.xtreemfs.mrc.database.StorageManager;
import org.xtreemfs.mrc.metadata.FileMetadata;
import org.xtreemfs.mrc.utils.Path;

public class PathResolver {
    private String fileName;
    private String parentDirName;
    private final Path path;
    private final FileMetadata[] resolvedPath;

    public PathResolver(StorageManager sMan, Path path) throws DatabaseException, UserException {
        this.path = path;
        this.resolvedPath = sMan.resolvePath(path);
        if (this.resolvedPath.length > 1 && this.resolvedPath[this.resolvedPath.length - 2] == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "path '" + path + "' does not exist");
        }
    }

    public PathResolver(Path path, FileMetadata ... files) {
        this.path = path;
        this.resolvedPath = files;
    }

    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = this.path.getLastComp(0);
        }
        return this.fileName;
    }

    public FileMetadata getFile() throws DatabaseException {
        return this.resolvedPath[this.resolvedPath.length - 1];
    }

    public void checkIfFileExistsAlready() throws DatabaseException, UserException {
        if (this.getFile() != null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_EEXIST, "file or directory '" + this.path + "' exists already");
        }
    }

    public void checkIfFileDoesNotExist() throws DatabaseException, UserException {
        if (this.getFile() == null) {
            throw new UserException(RPC.POSIXErrno.POSIX_ERROR_ENOENT, "file or directory '" + this.path + "' does not exist");
        }
    }

    public String getParentDirName() {
        if (this.parentDirName == null) {
            this.parentDirName = this.path.getCompCount() == 1 ? "" : this.path.getLastComp(1);
        }
        return this.parentDirName;
    }

    public long getParentDirId() throws DatabaseException {
        return this.resolvedPath.length == 1 ? 0L : this.resolvedPath[this.resolvedPath.length - 2].getId();
    }

    public FileMetadata getParentDir() throws DatabaseException {
        return this.resolvedPath.length == 1 ? null : this.resolvedPath[this.resolvedPath.length - 2];
    }

    public long getParentsParentId() throws DatabaseException {
        return this.resolvedPath.length == 1 ? -1L : (this.resolvedPath.length == 2 ? 0L : this.resolvedPath[this.resolvedPath.length - 3].getId());
    }

    public FileMetadata[] getResolvedPath() {
        return this.resolvedPath;
    }

    public String toString() {
        return this.path.toString();
    }
}

