/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

public class AdvisoryLock {
    public static final long LENGTH_LOCK_TO_EOF = 0L;
    public static final long END_LOCK_TO_EOF = -1L;
    private final boolean exclusive;
    private final long lockStart;
    private final long lockEnd;
    private final String clientUuid;
    private final int clientPid;

    public AdvisoryLock(long start, long len, boolean exclusive, String clientUuid, int clientPid) {
        this.exclusive = exclusive;
        this.lockStart = start;
        if (len == 0L) {
            this.lockEnd = -1L;
        } else {
            long end = this.lockStart + len - 1L;
            if (end < 0L) {
                end = 0L;
            }
            this.lockEnd = end;
        }
        this.clientPid = clientPid;
        this.clientUuid = clientUuid;
    }

    public boolean isOverlappingRanges(AdvisoryLock other) {
        if (this.lockEnd == -1L) {
            return other.lockEnd >= this.lockStart || other.lockEnd == -1L;
        }
        if (other.lockEnd == -1L) {
            return this.lockEnd >= other.lockStart || this.lockEnd == -1L;
        }
        return this.lockEnd >= other.lockStart && this.lockStart <= other.lockEnd;
    }

    public boolean isConflicting(AdvisoryLock other) {
        if (this.isOverlappingRanges(other)) {
            return this.exclusive || other.exclusive;
        }
        return false;
    }

    public String getClientUuid() {
        return this.clientUuid;
    }

    public int getClientPid() {
        return this.clientPid;
    }

    public long getOffset() {
        return this.lockStart;
    }

    public long getLength() {
        if (this.lockEnd == -1L) {
            return 0L;
        }
        return this.lockEnd - this.lockStart + 1L;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }
}

