/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import java.util.Map;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.LRUCache;

public class LocationsCache {
    private Map<String, XLocations> cache;
    private final int maximumSize;

    public LocationsCache(int size) {
        this.maximumSize = size;
        this.cache = new LRUCache<String, XLocations>(this.maximumSize);
    }

    public long getVersion(String fileId) {
        XLocations loc = this.cache.get(fileId);
        return loc != null ? (long)loc.getVersion() : 0L;
    }

    public void update(String fileId, XLocations updatedLoc) {
        this.cache.put(fileId, updatedLoc);
    }

    public XLocations getLocations(String fileId) {
        return this.cache.get(fileId);
    }

    public void removeLocations(String fileId) {
        this.cache.remove(fileId);
    }
}

