/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.osd.OSDConfig;
import org.xtreemfs.osd.OSDRequestDispatcher;

public class OSD {
    private OSDRequestDispatcher dispatcher;

    public OSD(OSDConfig config) {
        if (Logging.isInfo()) {
            Logging.logMessage(6, Logging.Category.misc, (Object)null, "JAVA_HOME=%s", System.getProperty("java.home"));
            Logging.logMessage(6, Logging.Category.misc, (Object)null, "UUID: %s", config.getUUID());
        }
        try {
            this.dispatcher = new OSDRequestDispatcher(config);
            this.dispatcher.start();
            final OSDRequestDispatcher ctrl = this.dispatcher;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        if (Logging.isInfo()) {
                            Logging.logMessage(6, Logging.Category.lifecycle, this, "received shutdown signal", new Object[0]);
                        }
                        ctrl.shutdown();
                        if (Logging.isInfo()) {
                            Logging.logMessage(6, Logging.Category.lifecycle, this, "OSD shutdown complete", new Object[0]);
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        catch (Exception ex) {
            Logging.logMessage(3, null, "OSD could not start up due to an exception. Aborted.", new Object[0]);
            Logging.logError(3, null, ex);
            if (this.dispatcher != null) {
                try {
                    this.dispatcher.shutdown();
                }
                catch (Exception e) {
                    Logging.logMessage(3, config.getUUID(), "could not shutdown OSD: ", new Object[0]);
                    Logging.logError(3, config.getUUID(), e);
                }
            }
            System.exit(1);
        }
    }

    public void shutdown() {
        this.dispatcher.shutdown();
    }

    public OSDRequestDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public static void main(String[] args) throws Exception {
        Thread.currentThread().setName("OSD");
        String cfgFile = args.length > 0 ? args[0] : "./etc/xos/xtreemfs/osdconfig.test";
        OSDConfig config = new OSDConfig(cfgFile);
        config.setDefaults();
        config.checkConfig();
        Logging.start(config.getDebugLevel(), config.getDebugCategories());
        new OSD(config);
    }
}

