/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xtreemfs.common.config.ServiceConfig;

public class OSDConfig
extends ServiceConfig {
    private final ServiceConfig.Parameter[] osdParameter = new ServiceConfig.Parameter[]{ServiceConfig.Parameter.DEBUG_LEVEL, ServiceConfig.Parameter.DEBUG_CATEGORIES, ServiceConfig.Parameter.PORT, ServiceConfig.Parameter.HTTP_PORT, ServiceConfig.Parameter.LISTEN_ADDRESS, ServiceConfig.Parameter.HOSTNAME, ServiceConfig.Parameter.DIRECTORY_SERVICE, ServiceConfig.Parameter.OBJECT_DIR, ServiceConfig.Parameter.LOCAL_CLOCK_RENEW, ServiceConfig.Parameter.REMOTE_TIME_SYNC, ServiceConfig.Parameter.USE_SSL, ServiceConfig.Parameter.SSL_PROTOCOL_STRING, ServiceConfig.Parameter.SERVICE_CREDS_CONTAINER, ServiceConfig.Parameter.SERVICE_CREDS_FILE, ServiceConfig.Parameter.SERVICE_CREDS_PASSPHRASE, ServiceConfig.Parameter.TRUSTED_CERTS_CONTAINER, ServiceConfig.Parameter.TRUSTED_CERTS_FILE, ServiceConfig.Parameter.TRUSTED_CERTS_PASSPHRASE, ServiceConfig.Parameter.TRUST_MANAGER, ServiceConfig.Parameter.USE_GRID_SSL_MODE, ServiceConfig.Parameter.GEO_COORDINATES, ServiceConfig.Parameter.CHECKSUM_ENABLED, ServiceConfig.Parameter.CHECKSUM_PROVIDER, ServiceConfig.Parameter.ADMIN_PASSWORD, ServiceConfig.Parameter.WAIT_FOR_DIR, ServiceConfig.Parameter.UUID, ServiceConfig.Parameter.REPORT_FREE_SPACE, ServiceConfig.Parameter.STORAGE_LAYOUT, ServiceConfig.Parameter.IGNORE_CAPABILITIES, ServiceConfig.Parameter.FLEASE_DMAX_MS, ServiceConfig.Parameter.FLEASE_LEASE_TIMEOUT_MS, ServiceConfig.Parameter.FLEASE_MESSAGE_TO_MS, ServiceConfig.Parameter.FLEASE_RETRIES, ServiceConfig.Parameter.POLICY_DIR, ServiceConfig.Parameter.CAPABILITY_SECRET, ServiceConfig.Parameter.SOCKET_SEND_BUFFER_SIZE, ServiceConfig.Parameter.SOCKET_RECEIVE_BUFFER_SIZE, ServiceConfig.Parameter.USE_SNMP, ServiceConfig.Parameter.SNMP_ADDRESS, ServiceConfig.Parameter.SNMP_PORT, ServiceConfig.Parameter.SNMP_ACL, ServiceConfig.Parameter.FAILOVER_MAX_RETRIES, ServiceConfig.Parameter.FAILOVER_WAIT, ServiceConfig.Parameter.MAX_CLIENT_Q, ServiceConfig.Parameter.MAX_REQUEST_QUEUE_LENGTH, ServiceConfig.Parameter.VIVALDI_RECALCULATION_INTERVAL_IN_MS, ServiceConfig.Parameter.VIVALDI_RECALCULATION_EPSILON_IN_MS, ServiceConfig.Parameter.VIVALDI_ITERATIONS_BEFORE_UPDATING, ServiceConfig.Parameter.VIVALDI_MAX_RETRIES_FOR_A_REQUEST, ServiceConfig.Parameter.VIVALDI_MAX_REQUEST_TIMEOUT_IN_MS, ServiceConfig.Parameter.VIVALDI_TIMER_INTERVAL_IN_MS, ServiceConfig.Parameter.STORAGE_THREADS, ServiceConfig.Parameter.USE_RENEWAL_SIGNAL, ServiceConfig.Parameter.USE_MULTIHOMING, ServiceConfig.Parameter.HEALTH_CHECK};
    public static final int CHECKSUM_NONE = 0;
    public static final int CHECKSUM_ADLER32 = 1;
    public static final int CHECKSUM_CRC32 = 2;
    private final Map<String, String> customParams = new HashMap<String, String>();

    public OSDConfig(String filename) throws IOException {
        super(filename);
        this.read();
    }

    public OSDConfig(Properties prop) throws IOException {
        super(prop);
        this.read();
    }

    public OSDConfig(HashMap<String, String> hm) {
        super(hm);
        for (Map.Entry<String, String> entry : hm.entrySet()) {
            if (!entry.getKey().startsWith("config.")) continue;
            this.customParams.put(entry.getKey(), entry.getValue());
        }
    }

    public void read() throws IOException {
        for (String propName : this.props.stringPropertyNames()) {
            if (!propName.startsWith("config.")) continue;
            this.customParams.put(propName, this.props.getProperty(propName));
        }
        for (ServiceConfig.Parameter param : this.osdParameter) {
            this.parameter.put(param, this.readParameter(param));
        }
    }

    public String getObjDir() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.OBJECT_DIR);
    }

    public int getLocalClockRenew() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.LOCAL_CLOCK_RENEW);
    }

    public int getRemoteTimeSync() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.REMOTE_TIME_SYNC);
    }

    public boolean isReportFreeSpace() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.REPORT_FREE_SPACE);
    }

    public void setReportFreeSpace(boolean reportFreeSpace) {
        this.parameter.put(ServiceConfig.Parameter.REPORT_FREE_SPACE, reportFreeSpace);
    }

    public String getChecksumProvider() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.CHECKSUM_PROVIDER);
    }

    public boolean isUseChecksums() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.CHECKSUM_ENABLED);
    }

    public String getCapabilitySecret() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.CAPABILITY_SECRET);
    }

    public boolean isIgnoreCaps() {
        return (Boolean)this.parameter.get((Object)ServiceConfig.Parameter.IGNORE_CAPABILITIES);
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public String getStorageLayout() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.STORAGE_LAYOUT);
    }

    public int getFleaseDmaxMS() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.FLEASE_DMAX_MS);
    }

    public int getFleaseLeaseToMS() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.FLEASE_LEASE_TIMEOUT_MS);
    }

    public int getFleaseMsgToMS() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.FLEASE_MESSAGE_TO_MS);
    }

    public int getFleaseRetries() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.FLEASE_RETRIES);
    }

    public void setCapabilitySecret(String capabilitySecret) {
        this.parameter.put(ServiceConfig.Parameter.CAPABILITY_SECRET, capabilitySecret);
    }

    public int getSocketSendBufferSize() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.SOCKET_SEND_BUFFER_SIZE);
    }

    public int getSocketReceiveBufferSize() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.SOCKET_RECEIVE_BUFFER_SIZE);
    }

    public void setDefaults() {
        super.setDefaults(this.osdParameter);
    }

    public void checkConfig() {
        super.checkConfig(this.osdParameter);
        this.checkMultihomingConfiguration();
    }

    public int getMaxClientQ() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.MAX_CLIENT_Q);
    }

    public int getMaxRequestsQueueLength() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.MAX_REQUEST_QUEUE_LENGTH);
    }

    @Override
    public HashMap<String, String> toHashMap() {
        HashMap<String, String> hm = super.toHashMap();
        hm.putAll(this.customParams);
        return hm;
    }

    public int getVivaldiRecalculationInterval() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.VIVALDI_RECALCULATION_INTERVAL_IN_MS);
    }

    public int getVivaldiRecalculationEpsilon() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.VIVALDI_RECALCULATION_EPSILON_IN_MS);
    }

    public int getVivaldiIterationsBeforeUpdating() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.VIVALDI_ITERATIONS_BEFORE_UPDATING);
    }

    public int getVivaldiMaxRetriesForARequest() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.VIVALDI_MAX_RETRIES_FOR_A_REQUEST);
    }

    public int getVivaldiMaxRequestTimeout() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.VIVALDI_MAX_REQUEST_TIMEOUT_IN_MS);
    }

    public int getVivaldiTimerInterval() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.VIVALDI_TIMER_INTERVAL_IN_MS);
    }

    public int getStorageThreads() {
        return (Integer)this.parameter.get((Object)ServiceConfig.Parameter.STORAGE_THREADS);
    }

    public String getHealthCheckScript() {
        return (String)this.parameter.get((Object)ServiceConfig.Parameter.HEALTH_CHECK);
    }
}

