/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import com.google.protobuf.Message;
import java.io.IOException;
import org.xtreemfs.common.Capability;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.foundation.buffer.ReusableBuffer;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.client.RPCResponse;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.storage.CowPolicy;

public final class OSDRequest {
    private final RPCServerRequest rpcRequest;
    private Message requestArgs;
    private OSDOperation operation;
    private Object attachment;
    private long requestId;
    private static long rqIdCounter = 1L;
    private RPCResponse[] pendingRequests;
    private String fileId;
    private Capability capability;
    private XLocations locationList;
    private CowPolicy cowPolicy;
    private boolean fileOpen;

    public OSDRequest(RPCServerRequest request) {
        this.rpcRequest = request;
        this.requestId = rqIdCounter++;
    }

    public RPCServerRequest getRPCRequest() {
        return this.getRpcRequest();
    }

    public void sendSuccess(Message response, ReusableBuffer data) {
        try {
            this.rpcRequest.sendResponse(response, data);
        }
        catch (IOException ex) {
            Logging.logError(3, this, ex);
        }
    }

    public void sendInternalServerError(Throwable cause) {
        if (this.getRpcRequest() != null) {
            this.rpcRequest.sendError(RPC.ErrorType.INTERNAL_SERVER_ERROR, RPC.POSIXErrno.POSIX_ERROR_NONE, "internal server error:" + cause, OutputUtils.stackTraceToString(cause));
        } else {
            Logging.logMessage(3, this, "internal server error on internal request: %s", cause.toString());
            Logging.logError(3, this, cause);
        }
    }

    public void sendError(RPC.ErrorType type, RPC.POSIXErrno errno, String message) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.stage, this, "sending errno exception %s/%s/%s", type, errno, message);
        }
        this.rpcRequest.sendError(type, errno, message);
    }

    public void sendError(RPC.ErrorType type, RPC.POSIXErrno errno, String message, String debugInfo) {
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.stage, this, "sending errno exception %s/%s/%s", type, errno, message);
        }
        this.rpcRequest.sendError(type, errno, message, debugInfo);
    }

    public RPCServerRequest getRpcRequest() {
        return this.rpcRequest;
    }

    public Message getRequestArgs() {
        return this.requestArgs;
    }

    public void setRequestArgs(Message requestArgs) {
        this.requestArgs = requestArgs;
    }

    public OSDOperation getOperation() {
        return this.operation;
    }

    public void setOperation(OSDOperation operation) {
        this.operation = operation;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public RPCResponse[] getPendingRequests() {
        return this.pendingRequests;
    }

    public void setPendingRequests(RPCResponse[] pendingRequests) {
        this.pendingRequests = pendingRequests;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public void setCapability(Capability capability) {
        this.capability = capability;
    }

    public XLocations getLocationList() {
        return this.locationList;
    }

    public void setLocationList(XLocations locationList) {
        this.locationList = locationList;
    }

    public CowPolicy getCowPolicy() {
        return this.cowPolicy;
    }

    public void setCowPolicy(CowPolicy cowPolicy) {
        this.cowPolicy = cowPolicy;
    }

    public boolean isFileOpen() {
        return this.fileOpen;
    }

    public void setFileOpen(boolean fileOpen) {
        this.fileOpen = fileOpen;
    }

    public void sendError(RPC.RPCHeader.ErrorResponse error) {
        this.getRPCRequest().sendError(error);
    }
}

