/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import com.google.protobuf.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.common.HeartbeatThread;
import org.xtreemfs.common.ServiceAvailability;
import org.xtreemfs.common.config.PolicyContainer;
import org.xtreemfs.common.config.RemoteConfigHelper;
import org.xtreemfs.common.config.ServiceConfig;
import org.xtreemfs.common.monitoring.StatusMonitor;
import org.xtreemfs.common.statusserver.PrintStackTrace;
import org.xtreemfs.common.statusserver.StatusServer;
import org.xtreemfs.common.uuids.ServiceUUID;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.common.uuids.UnknownUUIDException;
import org.xtreemfs.common.xloc.XLocations;
import org.xtreemfs.dir.DIRClient;
import org.xtreemfs.dir.discovery.DiscoveryUtils;
import org.xtreemfs.foundation.CrashReporter;
import org.xtreemfs.foundation.LifeCycleListener;
import org.xtreemfs.foundation.SSLOptions;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.checksums.ChecksumFactory;
import org.xtreemfs.foundation.checksums.provider.JavaChecksumProvider;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.pbrpc.Schemes;
import org.xtreemfs.foundation.pbrpc.client.RPCNIOSocketClient;
import org.xtreemfs.foundation.pbrpc.generatedinterfaces.RPC;
import org.xtreemfs.foundation.pbrpc.server.RPCNIOSocketServer;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequest;
import org.xtreemfs.foundation.pbrpc.server.RPCServerRequestListener;
import org.xtreemfs.foundation.pbrpc.server.RPCUDPSocketServer;
import org.xtreemfs.foundation.pbrpc.utils.ErrorUtils;
import org.xtreemfs.foundation.util.FSUtils;
import org.xtreemfs.osd.OSDConfig;
import org.xtreemfs.osd.OSDRequest;
import org.xtreemfs.osd.OSDStatusListener;
import org.xtreemfs.osd.ReplicatedFileStatusJSON;
import org.xtreemfs.osd.ReplicatedFileStatusPage;
import org.xtreemfs.osd.StatusPage;
import org.xtreemfs.osd.operations.CheckObjectOperation;
import org.xtreemfs.osd.operations.CleanupGetResultsOperation;
import org.xtreemfs.osd.operations.CleanupGetStatusOperation;
import org.xtreemfs.osd.operations.CleanupIsRunningOperation;
import org.xtreemfs.osd.operations.CleanupStartOperation;
import org.xtreemfs.osd.operations.CleanupStopOperation;
import org.xtreemfs.osd.operations.CleanupVersionsStartOperation;
import org.xtreemfs.osd.operations.DeleteOperation;
import org.xtreemfs.osd.operations.EventCloseFile;
import org.xtreemfs.osd.operations.EventCreateFileVersion;
import org.xtreemfs.osd.operations.EventInsertPaddingObject;
import org.xtreemfs.osd.operations.EventRWRStatus;
import org.xtreemfs.osd.operations.EventWriteObject;
import org.xtreemfs.osd.operations.FleaseMessageOperation;
import org.xtreemfs.osd.operations.GetFileIDListOperation;
import org.xtreemfs.osd.operations.GetObjectSetOperation;
import org.xtreemfs.osd.operations.InternalGetFileSizeOperation;
import org.xtreemfs.osd.operations.InternalGetGmaxOperation;
import org.xtreemfs.osd.operations.InternalRWRAuthStateInvalidatedOperation;
import org.xtreemfs.osd.operations.InternalRWRAuthStateOperation;
import org.xtreemfs.osd.operations.InternalRWRFetchOperation;
import org.xtreemfs.osd.operations.InternalRWRStatusOperation;
import org.xtreemfs.osd.operations.InternalRWRTruncateOperation;
import org.xtreemfs.osd.operations.InternalRWRUpdateOperation;
import org.xtreemfs.osd.operations.InternalTruncateOperation;
import org.xtreemfs.osd.operations.InvalidateXLocSetOperation;
import org.xtreemfs.osd.operations.LocalReadOperation;
import org.xtreemfs.osd.operations.LockAcquireOperation;
import org.xtreemfs.osd.operations.LockCheckOperation;
import org.xtreemfs.osd.operations.LockReleaseOperation;
import org.xtreemfs.osd.operations.OSDOperation;
import org.xtreemfs.osd.operations.RWRNotifyOperation;
import org.xtreemfs.osd.operations.ReadOperation;
import org.xtreemfs.osd.operations.RepairObjectOperation;
import org.xtreemfs.osd.operations.ShutdownOperation;
import org.xtreemfs.osd.operations.TruncateOperation;
import org.xtreemfs.osd.operations.VivaldiPingOperation;
import org.xtreemfs.osd.operations.WriteOperation;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.osd.stages.DeletionStage;
import org.xtreemfs.osd.stages.PreprocStage;
import org.xtreemfs.osd.stages.ReplicationStage;
import org.xtreemfs.osd.stages.StorageStage;
import org.xtreemfs.osd.stages.VivaldiStage;
import org.xtreemfs.osd.storage.CleanupThread;
import org.xtreemfs.osd.storage.CleanupVersionsThread;
import org.xtreemfs.osd.storage.HashStorageLayout;
import org.xtreemfs.osd.storage.MetadataCache;
import org.xtreemfs.osd.vivaldi.VivaldiNode;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;
import org.xtreemfs.pbrpc.generatedinterfaces.DIRServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.GlobalTypes;
import org.xtreemfs.pbrpc.generatedinterfaces.MRCServiceClient;
import org.xtreemfs.pbrpc.generatedinterfaces.OSD;
import org.xtreemfs.pbrpc.generatedinterfaces.OSDServiceClient;

public class OSDRequestDispatcher
implements RPCServerRequestListener,
LifeCycleListener {
    private static final int RPC_TIMEOUT = 15000;
    private static final int CONNECTION_TIMEOUT = 300000;
    protected final Map<Integer, OSDOperation> operations;
    protected final Map<Class<?>, OSDOperation> internalEvents;
    protected final HeartbeatThread heartbeatThread;
    protected final OSDConfig config;
    protected final DIRClient dirClient;
    protected final MRCServiceClient mrcClient;
    protected final OSDServiceClient osdClient;
    protected final OSDServiceClient osdClientForReplication;
    protected final RPCNIOSocketClient rpcClientForReplication;
    protected final RPCNIOSocketClient rpcClient;
    protected final RPCNIOSocketServer rpcServer;
    protected long requestId;
    protected String authString;
    protected final PreprocStage preprocStage;
    protected final StorageStage stStage;
    protected final DeletionStage delStage;
    protected final ReplicationStage replStage;
    protected final RPCUDPSocketServer udpCom;
    protected final StatusServer statusServer;
    protected final long startupTime;
    protected final AtomicLong numBytesTX;
    protected final AtomicLong numBytesRX;
    protected final AtomicLong numObjsTX;
    protected final AtomicLong numObjsRX;
    protected final AtomicLong numReplBytesRX;
    protected final AtomicLong numReplObjsRX;
    protected final VivaldiStage vStage;
    protected final AtomicReference<GlobalTypes.VivaldiCoordinates> myCoordinates;
    protected final CleanupThread cThread;
    protected final CleanupVersionsThread cvThread;
    protected final RWReplicationStage rwrStage;
    private List<OSDStatusListener> statusListener;
    private final ServiceAvailability serviceAvailability;

    public OSDRequestDispatcher(OSDConfig config) throws Exception {
        InetSocketAddress bindPoint;
        Logging.logMessage(6, this, "XtreemFS OSD version 1.5.0-master", new Object[0]);
        this.config = config;
        assert (config.getUUID() != null);
        if (this.config.getDirectoryService().getHostName().equals(".autodiscover")) {
            Logging.logMessage(6, Logging.Category.net, this, "trying to discover local XtreemFS DIR service...", new Object[0]);
            DIR.DirService dir = DiscoveryUtils.discoverDir(10);
            if (dir == null) {
                Logging.logMessage(3, Logging.Category.net, this, "CANNOT FIND XtreemFS DIR service via discovery broadcasts... no response", new Object[0]);
                throw new IOException("no DIR service found via discovery broadcast");
            }
            Logging.logMessage(6, Logging.Category.net, this, "found XtreemFS DIR service at " + dir.getAddress() + ":" + dir.getPort(), new Object[0]);
            config.setDirectoryService(new InetSocketAddress(dir.getAddress(), dir.getPort()));
        }
        if (config.isInitializable().booleanValue()) {
            try {
                ServiceConfig remoteConfig = RemoteConfigHelper.getConfigurationFromDIR(config);
                config.mergeConfig(remoteConfig);
            }
            catch (Exception e) {
                Logging.logMessage(4, this, "Couldn't fetch configuration from DIR. Reason: " + e.getMessage(), new Object[0]);
                Logging.logError(7, config.getUUID(), e);
            }
        }
        this.numBytesTX = new AtomicLong();
        this.numBytesRX = new AtomicLong();
        this.numObjsTX = new AtomicLong();
        this.numObjsRX = new AtomicLong();
        this.numReplBytesRX = new AtomicLong();
        this.numReplObjsRX = new AtomicLong();
        ChecksumFactory.getInstance().addProvider(new JavaChecksumProvider());
        this.operations = new HashMap<Integer, OSDOperation>();
        this.internalEvents = new HashMap();
        this.initializeOperations();
        File objDir = new File(config.getObjDir());
        if (!objDir.exists() && !objDir.mkdirs()) {
            throw new IOException("unable to create object directory: " + objDir.getAbsolutePath());
        }
        SSLOptions.TrustManager tm1 = null;
        SSLOptions.TrustManager tm2 = null;
        if (config.isUsingSSL()) {
            PolicyContainer policyContainer = new PolicyContainer(config);
            try {
                tm1 = policyContainer.getTrustManager();
                tm2 = policyContainer.getTrustManager();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (Logging.isInfo() && tm1 != null) {
                Logging.logMessage(6, Logging.Category.misc, this, "using custom trust manager '%s'", tm1.getClass().getName());
            }
        }
        SSLOptions serverSSLopts = config.isUsingSSL() ? new SSLOptions(new FileInputStream(config.getServiceCredsFile()), config.getServiceCredsPassphrase(), config.getServiceCredsContainer(), new FileInputStream(config.getTrustedCertsFile()), config.getTrustedCertsPassphrase(), config.getTrustedCertsContainer(), false, config.isGRIDSSLmode(), config.getSSLProtocolString(), tm1) : null;
        this.rpcServer = new RPCNIOSocketServer(config.getPort(), config.getAddress(), this, serverSSLopts, config.getSocketReceiveBufferSize(), config.getMaxClientQ());
        this.rpcServer.setLifeCycleListener(this);
        SSLOptions clientSSLopts = config.isUsingSSL() ? new SSLOptions(new FileInputStream(config.getServiceCredsFile()), config.getServiceCredsPassphrase(), config.getServiceCredsContainer(), new FileInputStream(config.getTrustedCertsFile()), config.getTrustedCertsPassphrase(), config.getTrustedCertsContainer(), false, config.isGRIDSSLmode(), config.getSSLProtocolString(), tm2) : null;
        InetSocketAddress inetSocketAddress = bindPoint = config.getAddress() != null ? new InetSocketAddress(config.getAddress(), 0) : null;
        if (Logging.isInfo() && bindPoint != null) {
            Logging.logMessage(6, Logging.Category.misc, this, "outgoing server connections will be bound to '%s'", config.getAddress());
        }
        this.rpcClient = new RPCNIOSocketClient(clientSSLopts, 15000, 300000, config.getSocketSendBufferSize(), config.getSocketReceiveBufferSize(), bindPoint, "OSDRequestDispatcher");
        this.rpcClient.setLifeCycleListener(this);
        this.rpcClientForReplication = new RPCNIOSocketClient(clientSSLopts, 30000, 300000, "OSDRequestDispatcher (for replication)");
        this.rpcClientForReplication.setLifeCycleListener(this);
        this.serviceAvailability = new ServiceAvailability();
        MetadataCache metadataCache = new MetadataCache();
        HashStorageLayout storageLayout = null;
        if (!config.getStorageLayout().equalsIgnoreCase(HashStorageLayout.class.getSimpleName())) {
            throw new RuntimeException("unknown storage layout in config file: " + config.getStorageLayout());
        }
        storageLayout = new HashStorageLayout(config, metadataCache);
        this.udpCom = new RPCUDPSocketServer(config.getPort(), this);
        this.udpCom.setLifeCycleListener(this);
        this.preprocStage = new PreprocStage(this, metadataCache, storageLayout, config.getMaxRequestsQueueLength());
        this.preprocStage.setLifeCycleListener(this);
        this.stStage = new StorageStage(this, metadataCache, storageLayout, config.getStorageThreads(), config.getMaxRequestsQueueLength());
        this.stStage.setLifeCycleListener(this);
        this.delStage = new DeletionStage(this, metadataCache, storageLayout, config.getMaxRequestsQueueLength());
        this.delStage.setLifeCycleListener(this);
        this.replStage = new ReplicationStage(this, config.getMaxRequestsQueueLength());
        this.replStage.setLifeCycleListener(this);
        this.rwrStage = new RWReplicationStage(this, serverSSLopts, config.getMaxRequestsQueueLength());
        this.rwrStage.setLifeCycleListener(this);
        DIRServiceClient dirRpcClient = new DIRServiceClient(this.rpcClient, config.getDirectoryService());
        this.dirClient = new DIRClient(dirRpcClient, config.getDirectoryServices(), config.getFailoverMaxRetries(), config.getFailoverWait());
        this.mrcClient = new MRCServiceClient(this.rpcClient, null);
        this.osdClient = new OSDServiceClient(this.rpcClient, null);
        this.osdClientForReplication = new OSDServiceClient(this.rpcClientForReplication, null);
        TimeSync.initialize(this.dirClient, config.getRemoteTimeSync(), config.getLocalClockRenew());
        UUIDResolver.start(this.dirClient, 10000, 600000);
        UUIDResolver.addLocalMapping(config.getUUID(), config.getPort(), Schemes.getScheme(config.isUsingSSL(), config.isGRIDSSLmode()));
        UUIDResolver.addLocalMapping(config.getUUID(), config.getPort(), "pbrpcu");
        this.myCoordinates = new AtomicReference();
        HeartbeatThread.ServiceDataGenerator gen = new HeartbeatThread.ServiceDataGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DIR.ServiceSet getServiceData() {
                OSDConfig config = OSDRequestDispatcher.this.config;
                String freeSpace = "0";
                String useableSpace = "0";
                if (config.isReportFreeSpace()) {
                    freeSpace = String.valueOf(FSUtils.getFreeSpace(config.getObjDir()));
                    useableSpace = String.valueOf(FSUtils.getUsableSpace(config.getObjDir()));
                }
                String totalSpace = "-1";
                try {
                    File f = new File(config.getObjDir());
                    totalSpace = String.valueOf(f.getTotalSpace());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                OperatingSystemMXBean osb = ManagementFactory.getOperatingSystemMXBean();
                String load = String.valueOf((int)(osb.getSystemLoadAverage() * 100.0 / (double)osb.getAvailableProcessors()));
                long totalRAM = Runtime.getRuntime().maxMemory();
                long usedRAM = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                OSD.OSDHealthResult healthCheckResult = OSD.OSDHealthResult.OSD_HEALTH_RESULT_NOT_AVAIL;
                BufferedReader scriptOutputReader = null;
                String scriptOutput = "";
                if (!config.getHealthCheckScript().equals("")) {
                    try {
                        Process scriptProcess = Runtime.getRuntime().exec(new String[]{config.getHealthCheckScript(), config.getObjDir()});
                        int healthCheckExitValue = scriptProcess.waitFor();
                        healthCheckResult = OSD.OSDHealthResult.valueOf(healthCheckExitValue);
                        scriptOutputReader = new BufferedReader(new InputStreamReader(scriptProcess.getInputStream()));
                        String line = "";
                        while ((line = scriptOutputReader.readLine()) != null) {
                            scriptOutput = scriptOutput + line;
                            scriptOutput = scriptOutput + "\n";
                        }
                        if (healthCheckResult == null) {
                            Logging.logMessage(4, Logging.Category.misc, this, "Health check script returns invalid value (" + healthCheckExitValue + ")", new Object[0]);
                            healthCheckResult = OSD.OSDHealthResult.OSD_HEALTH_RESULT_NOT_AVAIL;
                        }
                    }
                    catch (Exception e) {
                        Logging.logMessage(4, Logging.Category.misc, this, "Exception while reading health check result: " + e.getMessage(), new Object[0]);
                    }
                    finally {
                        if (scriptOutputReader != null) {
                            try {
                                scriptOutputReader.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                DIR.ServiceSet.Builder data = DIR.ServiceSet.newBuilder();
                DIR.ServiceDataMap.Builder dmap = DIR.ServiceDataMap.newBuilder();
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("load").setValue(load).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("total").setValue(totalSpace).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("free").setValue(freeSpace).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("usable").setValue(useableSpace).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("totalRAM").setValue(Long.toString(totalRAM)).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("usedRAM").setValue(Long.toString(usedRAM)).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("osd_health_check").setValue(String.valueOf(healthCheckResult.getNumber())).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("osd_health_check_output").setValue(scriptOutput).build());
                dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("proto_version").setValue(Integer.toString(30001)).build());
                GlobalTypes.VivaldiCoordinates coord = OSDRequestDispatcher.this.myCoordinates.get();
                if (coord != null) {
                    dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("vivaldi_coordinates").setValue(VivaldiNode.coordinatesToString(coord)).build());
                }
                for (Map.Entry<String, String> e : config.getCustomParams().entrySet()) {
                    dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey(e.getKey()).setValue(e.getValue()));
                }
                if (config.getHttpPort() != -1) {
                    try {
                        String address = "".equals(config.getHostName()) ? (config.getAddress() == null ? config.getUUID().getMappings()[0].resolvedAddr.getAddress().getHostAddress() : config.getAddress().getHostAddress()) : config.getHostName();
                        dmap.addData(GlobalTypes.KeyValuePair.newBuilder().setKey("status_page_url").setValue("http://" + address + ":" + config.getHttpPort()));
                    }
                    catch (UnknownUUIDException ex) {
                        // empty catch block
                    }
                }
                DIR.Service.Builder me = DIR.Service.newBuilder();
                me.setType(DIR.ServiceType.SERVICE_TYPE_OSD);
                me.setUuid(config.getUUID().toString());
                me.setName("OSD @ " + config.getUUID());
                me.setVersion(0L);
                me.setData(dmap);
                me.setLastUpdatedS(0L);
                data.addServices(me);
                return data.build();
            }
        };
        this.heartbeatThread = new HeartbeatThread("OSD HB Thr", this.dirClient, config.getUUID(), gen, config, true);
        if (config.getHttpPort() == -1) {
            this.statusServer = null;
        } else {
            this.statusServer = new StatusServer(DIR.ServiceType.SERVICE_TYPE_OSD, this, config.getHttpPort());
            this.statusServer.registerModule(new StatusPage());
            this.statusServer.registerModule(new PrintStackTrace());
            this.statusServer.registerModule(new ReplicatedFileStatusPage());
            this.statusServer.registerModule(new ReplicatedFileStatusJSON());
            if (config.getAdminPassword().length() > 0) {
                this.statusServer.addAuthorizedUser("admin", config.getAdminPassword());
            }
            this.statusServer.start();
        }
        this.startupTime = System.currentTimeMillis();
        this.vStage = new VivaldiStage(this, config.getMaxRequestsQueueLength());
        this.vStage.setLifeCycleListener(this);
        this.cThread = new CleanupThread(this, storageLayout);
        this.cThread.setLifeCycleListener(this);
        this.cvThread = new CleanupVersionsThread(this, storageLayout);
        this.cvThread.setLifeCycleListener(this);
        this.statusListener = new ArrayList<OSDStatusListener>();
        if (config.isUsingSnmp().booleanValue()) {
            this.statusListener.add(new StatusMonitor(this, config.getSnmpAddress(), (int)config.getSnmpPort(), config.getSnmpACLFile()));
            this.notifyConfigurationChange();
        }
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.lifecycle, this, "OSD at %s ready", this.getConfig().getUUID().toString());
        }
    }

    public CleanupThread getCleanupThread() {
        return this.cThread;
    }

    public CleanupVersionsThread getCleanupVersionsThread() {
        return this.cvThread;
    }

    public void start() {
        try {
            this.rpcServer.start();
            this.rpcClient.start();
            this.rpcClientForReplication.start();
            this.rpcServer.waitForStartup();
            this.rpcClient.waitForStartup();
            this.udpCom.start();
            this.preprocStage.start();
            this.delStage.start();
            this.stStage.start();
            this.replStage.start();
            this.vStage.start();
            this.cThread.start();
            this.cvThread.start();
            this.rwrStage.start();
            this.udpCom.waitForStartup();
            this.preprocStage.waitForStartup();
            this.delStage.waitForStartup();
            this.stStage.waitForStartup();
            this.vStage.waitForStartup();
            this.cThread.waitForStartup();
            this.cvThread.waitForStartup();
            this.rwrStage.waitForStartup();
            this.heartbeatThread.initialize();
            this.heartbeatThread.start();
            this.heartbeatThread.waitForStartup();
            if (Logging.isInfo()) {
                Logging.logMessage(6, Logging.Category.lifecycle, this, "OSD RequestController and all services operational", new Object[0]);
            }
        }
        catch (Exception ex) {
            Logging.logMessage(3, this, "STARTUP FAILED!", new Object[0]);
            Logging.logError(3, this, ex);
            System.exit(1);
        }
    }

    public void shutdown() {
        try {
            for (OSDStatusListener listener : this.statusListener) {
                listener.shuttingDown();
            }
            this.heartbeatThread.shutdown();
            this.heartbeatThread.waitForShutdown();
            this.rpcServer.shutdown();
            this.rpcClient.shutdown();
            this.rpcClientForReplication.shutdown();
            this.rpcServer.waitForShutdown();
            this.rpcClient.waitForShutdown();
            this.rpcClientForReplication.waitForShutdown();
            this.serviceAvailability.shutdown();
            this.udpCom.shutdown();
            this.preprocStage.shutdown();
            this.delStage.shutdown();
            this.stStage.shutdown();
            this.replStage.shutdown();
            this.rwrStage.shutdown();
            this.vStage.shutdown();
            this.cThread.cleanupStop();
            this.cThread.shutdown();
            this.cvThread.cleanupStop();
            this.cvThread.shutdown();
            this.serviceAvailability.shutdown();
            this.udpCom.waitForShutdown();
            this.preprocStage.waitForShutdown();
            this.delStage.waitForShutdown();
            this.stStage.waitForShutdown();
            this.replStage.waitForShutdown();
            this.rwrStage.waitForShutdown();
            this.vStage.waitForShutdown();
            this.cThread.waitForShutdown();
            this.cvThread.waitForShutdown();
            if (this.statusServer != null) {
                this.statusServer.shutdown();
            }
            if (Logging.isInfo()) {
                Logging.logMessage(6, Logging.Category.lifecycle, this, "OSD and all stages terminated", new Object[0]);
            }
        }
        catch (Exception ex) {
            Logging.logMessage(3, this, "shutdown failed", new Object[0]);
            Logging.logError(3, this, ex);
        }
    }

    public void asyncShutdown() {
        try {
            for (OSDStatusListener listener : this.statusListener) {
                listener.shuttingDown();
            }
            this.heartbeatThread.shutdown();
            this.rpcServer.shutdown();
            this.rpcClient.shutdown();
            this.rpcClientForReplication.shutdown();
            this.udpCom.shutdown();
            this.preprocStage.shutdown();
            this.delStage.shutdown();
            this.stStage.shutdown();
            this.replStage.shutdown();
            this.rwrStage.shutdown();
            this.vStage.shutdown();
            this.cThread.cleanupStop();
            this.cThread.shutdown();
            this.cvThread.cleanupStop();
            this.cvThread.shutdown();
            this.serviceAvailability.shutdown();
            this.statusServer.shutdown();
            if (Logging.isInfo()) {
                Logging.logMessage(6, Logging.Category.lifecycle, this, "OSD and all stages terminated", new Object[0]);
            }
        }
        catch (Exception ex) {
            Logging.logMessage(3, this, "shutdown failed", new Object[0]);
            Logging.logError(3, this, ex);
        }
    }

    public OSDOperation getOperation(int procId) {
        return this.operations.get(procId);
    }

    public OSDOperation getInternalEvent(Class<?> clazz) {
        return this.internalEvents.get(clazz);
    }

    public OSDConfig getConfig() {
        return this.config;
    }

    public DIRClient getDIRClient() {
        return this.dirClient;
    }

    public MRCServiceClient getMRCClient() {
        return this.mrcClient;
    }

    public OSDServiceClient getOSDClient() {
        return this.osdClient;
    }

    public OSDServiceClient getOSDClientForReplication() {
        return this.osdClientForReplication;
    }

    public RPCNIOSocketClient getRPCClient() {
        return this.rpcClient;
    }

    @Override
    public void startupPerformed() {
    }

    @Override
    public void shutdownPerformed() {
    }

    @Override
    public void crashPerformed(Throwable cause) {
        String report = CrashReporter.createCrashReport("OSD", "1.5.0-master", cause);
        System.out.println(report);
        CrashReporter.reportXtreemFSCrash(report);
        this.shutdown();
    }

    public boolean isHeadOSD(XLocations xloc) {
        ServiceUUID headOSD = xloc.getLocalReplica().getOSDs().get(0);
        return this.config.getUUID().equals(headOSD);
    }

    public long getFreeSpace() {
        return FSUtils.getFreeSpace(this.config.getObjDir());
    }

    public long getTotalSpace() {
        File f = new File(this.config.getObjDir());
        long s = f.getTotalSpace();
        return s;
    }

    @Override
    public void receiveRecord(RPCServerRequest rq) {
        RPC.RPCHeader hdr = rq.getHeader();
        if (hdr.getMessageType() != RPC.MessageType.RPC_REQUEST) {
            rq.sendError(RPC.ErrorType.GARBAGE_ARGS, RPC.POSIXErrno.POSIX_ERROR_EIO, "expected RPC request message type but got " + hdr.getMessageType());
            return;
        }
        RPC.RPCHeader.RequestHeader rqHdr = hdr.getRequestHeader();
        if (rqHdr.getInterfaceId() != 30001) {
            rq.sendError(RPC.ErrorType.INVALID_INTERFACE_ID, RPC.POSIXErrno.POSIX_ERROR_EIO, "Invalid interface id. This is an OSD service. You probably wanted to contact another service. Check the used address and port.");
            return;
        }
        try {
            OSDRequest request = new OSDRequest(rq);
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.stage, this, "received new request: %s", rq.toString());
            }
            this.preprocStage.prepareRequest(request, new PreprocStage.ParseCompleteCallback(){

                @Override
                public void parseComplete(OSDRequest result, RPC.RPCHeader.ErrorResponse error) {
                    if (error == null) {
                        result.getOperation().startRequest(result);
                    } else {
                        result.getRPCRequest().sendError(error);
                    }
                }
            });
        }
        catch (Exception ex) {
            rq.sendError(ErrorUtils.getInternalServerError(ex));
            Logging.logError(3, this, ex);
        }
    }

    public int getNumClientConnections() {
        return this.rpcServer.getNumConnections();
    }

    public long getPendingRequests() {
        return this.rpcServer.getPendingRequests();
    }

    private void initializeOperations() {
        OSDOperation op = new ReadOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new WriteOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new DeleteOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new TruncateOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalGetGmaxOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalTruncateOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new CheckObjectOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new RepairObjectOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalGetFileSizeOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new ShutdownOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new LocalReadOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new CleanupStartOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new CleanupIsRunningOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new CleanupStopOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new CleanupGetStatusOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new CleanupGetResultsOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new CleanupVersionsStartOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new GetObjectSetOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new LockAcquireOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new LockCheckOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new LockReleaseOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new VivaldiPingOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new FleaseMessageOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalRWRUpdateOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalRWRTruncateOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalRWRStatusOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalRWRFetchOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new GetFileIDListOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new RWRNotifyOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalRWRAuthStateOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InvalidateXLocSetOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new InternalRWRAuthStateInvalidatedOperation(this);
        this.operations.put(op.getProcedureId(), op);
        op = new EventCloseFile(this);
        this.internalEvents.put(EventCloseFile.class, op);
        op = new EventCreateFileVersion(this);
        this.internalEvents.put(EventCreateFileVersion.class, op);
        op = new EventWriteObject(this);
        this.internalEvents.put(EventWriteObject.class, op);
        op = new EventInsertPaddingObject(this);
        this.internalEvents.put(EventInsertPaddingObject.class, op);
        op = new EventRWRStatus(this);
        this.internalEvents.put(EventRWRStatus.class, op);
    }

    public StorageStage getStorageStage() {
        return this.stStage;
    }

    public DeletionStage getDeletionStage() {
        return this.delStage;
    }

    public PreprocStage getPreprocStage() {
        return this.preprocStage;
    }

    public ReplicationStage getReplicationStage() {
        return this.replStage;
    }

    public void sendUDPMessage(RPC.RPCHeader header, Message message, InetSocketAddress receiver) throws IOException {
        this.udpCom.sendRequest(header, message, receiver);
    }

    public VivaldiStage getVivaldiStage() {
        return this.vStage;
    }

    public RWReplicationStage getRWReplicationStage() {
        return this.rwrStage;
    }

    public ServiceAvailability getServiceAvailability() {
        return this.serviceAvailability;
    }

    public void objectReceived() {
        long num = this.numObjsRX.incrementAndGet();
        for (OSDStatusListener listener : this.statusListener) {
            listener.numObjsRXChanged(num);
        }
    }

    public void objectReplicated() {
        long num = this.numReplObjsRX.incrementAndGet();
        for (OSDStatusListener listener : this.statusListener) {
            listener.numReplObjsRX(num);
        }
    }

    public void objectSent() {
        long num = this.numObjsTX.incrementAndGet();
        for (OSDStatusListener listener : this.statusListener) {
            listener.numObjsTXChanged(num);
        }
    }

    public void replicatedDataReceived(int numBytes) {
        long num = this.numReplBytesRX.addAndGet(numBytes);
        for (OSDStatusListener listener : this.statusListener) {
            listener.numReplBytesRXChanged(num);
        }
    }

    public void dataReceived(int numBytes) {
        long num = this.numBytesRX.addAndGet(numBytes);
        for (OSDStatusListener listener : this.statusListener) {
            listener.numBytesRXChanged(num);
        }
    }

    public void dataSent(int numBytes) {
        long num = this.numBytesTX.addAndGet(numBytes);
        for (OSDStatusListener listener : this.statusListener) {
            listener.numBytesTXChanged(num);
        }
    }

    public long getObjectsReceived() {
        return this.numObjsRX.get();
    }

    public long getObjectsSent() {
        return this.numObjsTX.get();
    }

    public long getBytesReceived() {
        return this.numBytesRX.get();
    }

    public long getBytesSent() {
        return this.numBytesTX.get();
    }

    public long getReplicatedObjectsReceived() {
        return this.numReplObjsRX.get();
    }

    public long getReplicatedBytesReceived() {
        return this.numReplBytesRX.get();
    }

    public void updateVivaldiCoordinates(GlobalTypes.VivaldiCoordinates newVC) {
        this.myCoordinates.set(newVC);
    }

    public String getHostName() {
        return this.heartbeatThread.getAdvertisedHostName();
    }

    public void addStatusListener(OSDStatusListener listener) {
        this.statusListener.add(listener);
    }

    public void removeStatusListener(OSDStatusListener listener) {
        this.statusListener.remove(listener);
    }

    public void notifyConfigurationChange() {
        for (OSDStatusListener listener : this.statusListener) {
            listener.OSDConfigChanged(this.config);
        }
    }

    public long getLastHeartbeat() {
        return this.heartbeatThread.getLastHeartbeat();
    }

    public String getPrimary(String fileId) {
        return this.rwrStage.getPrimary(fileId);
    }
}

