/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.osd.AdvisoryLock;
import org.xtreemfs.osd.storage.CowPolicy;

public final class OpenFileTable {
    private final HashMap<String, OpenFileTableEntry> openFiles = new HashMap();
    private final SortedSet<OpenFileTableEntry> expTimes = new TreeSet<OpenFileTableEntry>();
    private final SortedSet<OpenFileTableEntry> expTimesWrite = new TreeSet<OpenFileTableEntry>(OpenFileTableEntry.createWriteExpComparator());

    public CowPolicy refresh(String fId, long expTime, boolean write) {
        OpenFileTableEntry currEntry = this.openFiles.get(fId);
        if (currEntry != null) {
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.proc, this, "refreshing for %s", fId);
            }
            if (expTime > currEntry.expTime) {
                this.expTimes.remove(currEntry);
                currEntry.setExpirationTime(expTime);
                this.openFiles.put(fId, currEntry);
                boolean success = this.expTimes.add(currEntry);
                assert (success);
                if (write) {
                    this.expTimesWrite.remove(currEntry);
                    currEntry.setWriteExpirationTime(expTime);
                    currEntry.setWrite();
                    this.expTimesWrite.add(currEntry);
                }
            }
            return currEntry.getCowPolicy();
        }
        Logging.logMessage(4, this, "attempt to keep file %s open failed because no open state exists anymore", fId);
        return null;
    }

    public void openFile(String fId, long expTime, CowPolicy policy, boolean write) {
        assert (!this.openFiles.containsKey(fId));
        if (Logging.isDebug()) {
            Logging.logMessage(7, Logging.Category.proc, this, "new entry for %s", fId);
        }
        OpenFileTableEntry newEntry = new OpenFileTableEntry(fId, expTime, policy);
        this.openFiles.put(fId, newEntry);
        this.expTimes.add(newEntry);
        if (write) {
            newEntry.setWriteExpirationTime(expTime);
            newEntry.setWrite();
            this.expTimesWrite.add(newEntry);
        }
    }

    public boolean contains(String fId) {
        return this.openFiles.containsKey(fId);
    }

    public List<OpenFileTableEntry> clean(long toTime) {
        OpenFileTableEntry currEntry;
        LinkedList<OpenFileTableEntry> closedFiles = new LinkedList<OpenFileTableEntry>();
        OpenFileTableEntry dummyEntry = new OpenFileTableEntry(null, toTime);
        Iterator it = this.expTimes.iterator();
        while (it.hasNext() && (currEntry = (OpenFileTableEntry)it.next()).compareTo(dummyEntry) < 0) {
            String fId = currEntry.fileId;
            this.openFiles.remove(fId);
            it.remove();
            currEntry.setClosed();
            closedFiles.add(currEntry);
        }
        return closedFiles;
    }

    public List<OpenFileTableEntry> cleanWritten(long toTime) {
        OpenFileTableEntry currEntry;
        LinkedList<OpenFileTableEntry> closedFiles = new LinkedList<OpenFileTableEntry>();
        OpenFileTableEntry dummyEntry = new OpenFileTableEntry(null, toTime);
        Iterator it = this.expTimesWrite.iterator();
        while (it.hasNext() && (currEntry = (OpenFileTableEntry)it.next()).compareTo(dummyEntry) < 0) {
            String fId = currEntry.fileId;
            this.openFiles.remove(fId);
            it.remove();
            closedFiles.add(currEntry);
        }
        return closedFiles;
    }

    public boolean isClosed(String fileId) {
        OpenFileTableEntry fileEntry = this.openFiles.get(fileId);
        if (fileEntry != null) {
            return fileEntry.expTime < System.currentTimeMillis() / 1000L;
        }
        return true;
    }

    public void setDeleteOnClose(String fileId) {
        OpenFileTableEntry fileEntry = this.openFiles.get(fileId);
        if (fileEntry != null) {
            fileEntry.setDeleteOnClose();
        }
    }

    public boolean isDeleteOnClose(String fileId) {
        OpenFileTableEntry fileEntry = this.openFiles.get(fileId);
        if (fileEntry != null) {
            return fileEntry.isDeleteOnClose();
        }
        return false;
    }

    public OpenFileTableEntry close(String fileId) {
        OpenFileTableEntry currEntry = this.openFiles.get(fileId);
        if (currEntry != null) {
            this.expTimes.remove(currEntry);
            this.expTimesWrite.remove(currEntry);
            this.openFiles.remove(fileId);
            currEntry.setClosed();
        }
        return currEntry;
    }

    public int getNumOpenFiles() {
        return this.openFiles.size();
    }

    public OpenFileTableEntry getEntry(String fileId) {
        return this.openFiles.get(fileId);
    }

    public static class OpenFileTableEntry
    implements Comparable<OpenFileTableEntry> {
        private final String fileId;
        private final CowPolicy fileCowPolicy;
        private long expTime;
        private long writeExpTime;
        private Map<String, AdvisoryLock> advisoryLocks;
        private boolean closed;
        private boolean write;
        private boolean deleteOnClose;

        private OpenFileTableEntry(String fid, long et) {
            this(fid, et, (CowPolicy)null);
        }

        private OpenFileTableEntry(String fid, long et, CowPolicy cow) {
            this.fileId = fid;
            this.expTime = et;
            this.writeExpTime = 0L;
            this.closed = false;
            this.deleteOnClose = false;
            this.write = false;
            this.fileCowPolicy = cow != null ? cow : new CowPolicy(CowPolicy.cowMode.NO_COW);
        }

        private void setExpirationTime(long newExpTime) {
            this.expTime = newExpTime;
        }

        private void setWriteExpirationTime(long newExpTime) {
            this.writeExpTime = newExpTime;
        }

        public String getFileId() {
            return this.fileId;
        }

        public CowPolicy getCowPolicy() {
            return this.fileCowPolicy;
        }

        public boolean isClosed() {
            return this.closed;
        }

        private void setClosed() {
            this.closed = true;
        }

        private void setDeleteOnClose() {
            this.deleteOnClose = true;
        }

        public boolean isDeleteOnClose() {
            return this.deleteOnClose;
        }

        private void setWrite() {
            this.write = true;
        }

        public void clearWrite() {
            this.write = false;
        }

        public boolean isWrite() {
            return this.write;
        }

        public AdvisoryLock acquireLock(String client_uuid, int pid, long offset, long length, boolean exclusive) {
            String procId = OpenFileTableEntry.getProcId(client_uuid, pid);
            AdvisoryLock l = new AdvisoryLock(offset, length, exclusive, client_uuid, pid);
            if (this.advisoryLocks == null) {
                this.advisoryLocks = new HashMap<String, AdvisoryLock>();
                this.advisoryLocks.put(procId, l);
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.all, this, "acquired lock for file %s by %s (%d-%d)", this.fileId, procId, offset, length);
                }
                return l;
            }
            for (Map.Entry<String, AdvisoryLock> e : this.advisoryLocks.entrySet()) {
                if (e.getKey().equals(procId) || !e.getValue().isConflicting(l)) continue;
                assert (e.getValue().getClientPid() != l.getClientPid() || !e.getValue().getClientUuid().equals(l.getClientUuid())) : procId + " vs " + e.getKey();
                if (Logging.isDebug()) {
                    Logging.logMessage(7, Logging.Category.all, this, "acquired for file %s by %s failed, conflickting lock by", this.fileId, procId, e.getKey());
                }
                return null;
            }
            if (Logging.isDebug()) {
                Logging.logMessage(7, Logging.Category.all, this, "acquired lock for file %s by %s (%d-%d)", this.fileId, procId, offset, length);
            }
            this.advisoryLocks.put(procId, l);
            return l;
        }

        public AdvisoryLock checkLock(String client_uuid, int pid, long offset, long length, boolean exclusive) {
            String procId = OpenFileTableEntry.getProcId(client_uuid, pid);
            AdvisoryLock l = new AdvisoryLock(offset, length, exclusive, client_uuid, pid);
            if (this.advisoryLocks == null) {
                return l;
            }
            for (Map.Entry<String, AdvisoryLock> e : this.advisoryLocks.entrySet()) {
                if (e.getKey().equals(procId)) {
                    return l;
                }
                if (!e.getValue().isConflicting(l)) continue;
                return e.getValue();
            }
            return l;
        }

        public void unlock(String client_uuid, int pid) {
            if (this.advisoryLocks == null) {
                return;
            }
            String procId = OpenFileTableEntry.getProcId(client_uuid, pid);
            this.advisoryLocks.remove(procId);
        }

        private static String getProcId(String clientUuid, int pid) {
            return String.format("%010d%s", pid, clientUuid);
        }

        public boolean equals(Object o) {
            try {
                OpenFileTableEntry e = (OpenFileTableEntry)o;
                return this.fileId.equals(e.fileId);
            }
            catch (ClassCastException ex) {
                return false;
            }
        }

        @Override
        public int compareTo(OpenFileTableEntry e) {
            int res = 0;
            res = this.expTime < e.expTime ? -1 : (this.expTime == e.expTime ? (e.fileId == null ? -1 : this.fileId.compareTo(e.fileId)) : 1);
            return res;
        }

        public static Comparator<OpenFileTableEntry> createWriteExpComparator() {
            return new Comparator<OpenFileTableEntry>(){

                @Override
                public int compare(OpenFileTableEntry e1, OpenFileTableEntry e2) {
                    int res = 0;
                    res = e1.writeExpTime < e2.writeExpTime ? -1 : (e1.writeExpTime == e2.writeExpTime ? (e1.fileId == null ? -1 : e2.fileId.compareTo(e1.fileId)) : 1);
                    return res;
                }
            };
        }

        public String toString() {
            return "(" + this.fileId + "," + this.expTime + "ms)";
        }
    }
}

