/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.foundation.json.JSONParser;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

public class ReplicatedFileStatusJSON
extends StatusServerModule {
    private OSDRequestDispatcher myDispatcher;

    @Override
    public String getDisplayName() {
        return "OSD Replicated File Table JSON Interface";
    }

    @Override
    public String getUriPath() {
        return "/rft.json";
    }

    @Override
    public boolean isAvailableForService(DIR.ServiceType service) {
        return service == DIR.ServiceType.SERVICE_TYPE_OSD;
    }

    @Override
    public void initialize(DIR.ServiceType service, Object serviceRequestDispatcher) {
        assert (service == DIR.ServiceType.SERVICE_TYPE_OSD);
        this.myDispatcher = (OSDRequestDispatcher)serviceRequestDispatcher;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            final AtomicReference result = new AtomicReference();
            this.myDispatcher.getRWReplicationStage().getStatus(new RWReplicationStage.StatusCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void statusComplete(Map<String, Map<String, String>> status) {
                    AtomicReference atomicReference = result;
                    synchronized (atomicReference) {
                        result.set(status);
                        result.notifyAll();
                    }
                }
            });
            AtomicReference atomicReference = result;
            synchronized (atomicReference) {
                if (result.get() == null) {
                    result.wait();
                }
            }
            Map status = (Map)result.get();
            String statusJSON = JSONParser.writeJSON(status);
            Headers headers = httpExchange.getResponseHeaders();
            headers.set("Access-Control-Allow-Origin", "*");
            headers.set("Access-Control-Allow-Methods", "GET");
            headers.set("Content-Type", "application/json");
            this.sendResponse(httpExchange, statusJSON);
        }
        catch (Throwable ex) {
            Logging.logError(4, null, ex);
            httpExchange.sendResponseHeaders(500, 0L);
        }
    }
}

