/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.osd.rwre.RWReplicationStage;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

class ReplicatedFileStatusPage
extends StatusServerModule {
    private OSDRequestDispatcher myDispatcher;

    ReplicatedFileStatusPage() {
    }

    @Override
    public String getDisplayName() {
        return "OSD Replicated File Table";
    }

    @Override
    public String getUriPath() {
        return "/rft";
    }

    @Override
    public boolean isAvailableForService(DIR.ServiceType service) {
        return service == DIR.ServiceType.SERVICE_TYPE_OSD;
    }

    @Override
    public void initialize(DIR.ServiceType service, Object serviceRequestDispatcher) {
        assert (service == DIR.ServiceType.SERVICE_TYPE_OSD);
        this.myDispatcher = (OSDRequestDispatcher)serviceRequestDispatcher;
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try {
            StringBuffer sb = new StringBuffer();
            final AtomicReference result = new AtomicReference();
            sb.append("<HTML><HEAD><TITLE>Replicated File Status List</TITLE>");
            sb.append("<STYLE type=\"text/css\">body,table,tr,td,h1 ");
            sb.append("{font-family:Arial,Helvetica,sans-serif;}</STYLE></HEAD><BODY>");
            sb.append("<H1>List of Open Replicated Files</H1>");
            sb.append("<TABLE border=\"1\">");
            sb.append("<TR><TD><B>File ID</B></TD><TD><B>Status</B></TD></TR>");
            this.myDispatcher.getRWReplicationStage().getStatus(new RWReplicationStage.StatusCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void statusComplete(Map<String, Map<String, String>> status) {
                    AtomicReference atomicReference = result;
                    synchronized (atomicReference) {
                        result.set(status);
                        result.notifyAll();
                    }
                }
            });
            AtomicReference atomicReference = result;
            synchronized (atomicReference) {
                if (result.get() == null) {
                    result.wait();
                }
            }
            Map status = (Map)result.get();
            for (String fileId : status.keySet()) {
                sb.append("<TR><TD>");
                sb.append(fileId);
                String role = (String)((Map)status.get(fileId)).get("role");
                String bgcolor = "#FFFFFF";
                if (role != null && role.equals("primary")) {
                    bgcolor = "#A3FFA3";
                } else if (role != null && role.startsWith("backup")) {
                    bgcolor = "#FFFF66";
                }
                sb.append("</TD><TD style=\"background-color:");
                sb.append(bgcolor);
                sb.append("\"><TABLE border=\"0\">");
                for (Map.Entry e : ((Map)status.get(fileId)).entrySet()) {
                    sb.append("<TR><TD>");
                    sb.append((String)e.getKey());
                    sb.append("</TD><TD>");
                    sb.append((String)e.getValue());
                    sb.append("</TD></TR>\n");
                }
                sb.append("</TABLE></TD></TR>\n");
            }
            this.sendResponse(httpExchange, sb.toString());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            httpExchange.sendResponseHeaders(500, 0L);
        }
    }
}

