/*
 * Decompiled with CFR 0.152.
 */
package org.xtreemfs.osd;

import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import org.xtreemfs.common.statusserver.StatusServerModule;
import org.xtreemfs.common.uuids.UUIDResolver;
import org.xtreemfs.foundation.TimeSync;
import org.xtreemfs.foundation.buffer.BufferPool;
import org.xtreemfs.foundation.logging.Logging;
import org.xtreemfs.foundation.util.OutputUtils;
import org.xtreemfs.osd.OSDRequestDispatcher;
import org.xtreemfs.pbrpc.generatedinterfaces.DIR;

class StatusPage
extends StatusServerModule {
    private final String statusPageTemplate;
    private OSDRequestDispatcher myDispatcher;

    public StatusPage() {
        StringBuffer sb = null;
        try {
            InputStream is = StatusPage.class.getClassLoader().getResourceAsStream("org/xtreemfs/osd/templates/status.html");
            if (is == null) {
                is = StatusPage.class.getClass().getResourceAsStream("../templates/status.html");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuffer();
            String line = br.readLine();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception ex) {
            Logging.logError(3, null, ex);
        }
        this.statusPageTemplate = sb == null ? "<H1>Template was not found, unable to show status page!</h1>" : sb.toString();
    }

    @Override
    public String getDisplayName() {
        return "OSD Status Summary";
    }

    @Override
    public String getUriPath() {
        return "/";
    }

    @Override
    public boolean isAvailableForService(DIR.ServiceType service) {
        return service == DIR.ServiceType.SERVICE_TYPE_OSD;
    }

    @Override
    public void initialize(DIR.ServiceType service, Object serviceRequestDispatcher) {
        assert (service == DIR.ServiceType.SERVICE_TYPE_OSD);
        this.myDispatcher = (OSDRequestDispatcher)serviceRequestDispatcher;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        long globalTime = TimeSync.getGlobalTime();
        long localTime = TimeSync.getLocalSystemTime();
        HashMap<Vars, String> values = new HashMap<Vars, String>();
        values.put(Vars.AVAILPROCS, Runtime.getRuntime().availableProcessors() + " bytes");
        values.put(Vars.FREEMEM, Runtime.getRuntime().freeMemory() + " bytes");
        values.put(Vars.MAXMEM, Runtime.getRuntime().maxMemory() + " bytes");
        values.put(Vars.BPSTATS, BufferPool.getStatus());
        values.put(Vars.UUID, this.myDispatcher.getConfig().getUUID().toString());
        values.put(Vars.PORT, Integer.toString(this.myDispatcher.getConfig().getPort()));
        values.put(Vars.DEBUG, Integer.toString(this.myDispatcher.getConfig().getDebugLevel()));
        values.put(Vars.NUMCON, Integer.toString(this.myDispatcher.getNumClientConnections()));
        values.put(Vars.PINKYQ, Long.toString(this.myDispatcher.getPendingRequests()));
        values.put(Vars.PARSERQ, Integer.toString(this.myDispatcher.getPreprocStage().getQueueLength()));
        values.put(Vars.STORAGEQ, Integer.toString(this.myDispatcher.getStorageStage().getQueueLength()));
        values.put(Vars.DELETIONQ, Integer.toString(this.myDispatcher.getDeletionStage().getQueueLength()));
        values.put(Vars.OPENFILES, Integer.toString(this.myDispatcher.getPreprocStage().getNumOpenFiles()));
        values.put(Vars.OBJWRITE, Long.toString(this.myDispatcher.getObjectsReceived()));
        values.put(Vars.OBJREAD, Long.toString(this.myDispatcher.getObjectsSent()));
        values.put(Vars.BYTETX, OutputUtils.formatBytes(this.myDispatcher.getBytesSent()));
        values.put(Vars.BYTERX, OutputUtils.formatBytes(this.myDispatcher.getBytesReceived()));
        values.put(Vars.REPLOBJWRITE, Long.toString(this.myDispatcher.getReplicatedObjectsReceived()));
        values.put(Vars.REPLBYTERX, OutputUtils.formatBytes(this.myDispatcher.getReplicatedBytesReceived()));
        values.put(Vars.DELETES, Long.toString(this.myDispatcher.getDeletionStage().getNumFilesDeleted()));
        values.put(Vars.GLOBALTIME, new Date(globalTime).toString() + " (" + globalTime + ")");
        values.put(Vars.GLOBALRESYNC, Long.toString(TimeSync.getTimeSyncInterval()));
        values.put(Vars.LOCALTIME, new Date(localTime).toString() + " (" + localTime + ")");
        values.put(Vars.LOCALRESYNC, Long.toString(TimeSync.getLocalRenewInterval()));
        values.put(Vars.UUIDCACHE, UUIDResolver.getCache());
        values.put(Vars.VERSION, "1.5.0-master");
        values.put(Vars.PROTOVERSION, Integer.toString(30001));
        String schema = "pbrpc";
        if (this.myDispatcher.getConfig().isUsingSSL()) {
            schema = this.myDispatcher.getConfig().isGRIDSSLmode() ? "pbrpcg" : "pbrpcs";
        }
        values.put(Vars.DIRURL, schema + "://" + this.myDispatcher.getConfig().getDirectoryService().getHostName() + ":" + this.myDispatcher.getConfig().getDirectoryService().getPort());
        long freeMem = Runtime.getRuntime().freeMemory();
        String span = "<span>";
        if (freeMem < 0x2000000L) {
            span = "<span class=\"levelWARN\">";
        } else if (freeMem < 0x200000L) {
            span = "<span class=\"levelERROR\">";
        }
        values.put(Vars.MEMSTAT, span + OutputUtils.formatBytes(freeMem) + " / " + OutputUtils.formatBytes(Runtime.getRuntime().maxMemory()) + " / " + OutputUtils.formatBytes(Runtime.getRuntime().totalMemory()) + "</span>");
        long freeDisk = this.myDispatcher.getFreeSpace();
        span = "<span>";
        if (freeDisk < Integer.MIN_VALUE) {
            span = "<span class=\"levelWARN\">";
        } else if (freeDisk < 0x20000000L) {
            span = "<span class=\"levelERROR\">";
        }
        values.put(Vars.DISKFREE, span + OutputUtils.formatBytes(freeDisk) + "</span>");
        String html = this.statusPageTemplate;
        for (Vars key : values.keySet()) {
            html = html.replace(key.toString(), (CharSequence)values.get((Object)key));
        }
        this.sendResponse(httpExchange, html);
    }

    private static enum Vars {
        UUID("<!-- $UUID -->"),
        MAXMEM("<!-- $MAXMEM -->"),
        FREEMEM("<!-- $FREEMEM -->"),
        AVAILPROCS("<!-- $AVAILPROCS -->"),
        BPSTATS("<!-- $BPSTATS -->"),
        PORT("<!-- $PORT -->"),
        DIRURL("<!-- $DIRURL -->"),
        DEBUG("<!-- $DEBUG -->"),
        NUMCON("<!-- $NUMCON -->"),
        PINKYQ("<!-- $PINKYQ -->"),
        PARSERQ("<!-- $PARSERQ -->"),
        AUTHQ("<!-- $AUTHQ -->"),
        STORAGEQ("<!-- $STORAGEQ -->"),
        DELETIONQ("<!-- $DELETIONQ -->"),
        OPENFILES("<!-- $OPENFILES -->"),
        OBJWRITE("<!-- $OBJWRITE -->"),
        OBJREAD("<!-- $OBJREAD -->"),
        BYTETX("<!-- $BYTETX -->"),
        BYTERX("<!-- $BYTERX -->"),
        REPLOBJWRITE("<!-- $REPLOBJWRITE -->"),
        REPLBYTERX("<!-- $REPLBYTERX -->"),
        GMAXMSG("<!-- $GMAXMSG -->"),
        GMAXRPC("<!-- $GMAXRPC -->"),
        DELETES("<!-- $DELETES -->"),
        GLOBALTIME("<!-- $GLOBALTIME -->"),
        GLOBALRESYNC("<!-- $GLOBALRESYNC -->"),
        LOCALTIME("<!-- $LOCALTIME -->"),
        LOCALRESYNC("<!-- $LOCALRESYNC -->"),
        MEMSTAT("<!-- $MEMSTAT -->"),
        UUIDCACHE("<!-- $UUIDCACHE -->"),
        STATCOLLECT("<!-- $STATCOLLECT -->"),
        DISKFREE("<!-- $DISKFREE -->"),
        PROTOVERSION("<!-- $PROTOVERSION -->"),
        VERSION("<!-- $VERSION -->");

        private String template;

        private Vars(String template) {
            this.template = template;
        }

        public String toString() {
            return this.template;
        }
    }
}

